/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.advertising;

import com.sun.multicast.advertising.Advertisement;
import com.sun.multicast.advertising.InvalidAdvertisementException;
import com.sun.multicast.advertising.Listener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Vector;

class AddressListener
implements Runnable {
    static final int SD_PORT = 9875;
    static final int SAPBUFFERSIZE = 2048;
    InetAddress listeningAddress;
    Vector advertisementList;
    MulticastSocket mSocket;
    int invalidAdvertisements;
    static Listener SAPListener;

    AddressListener(InetAddress inetAddress) throws IOException {
        this.listeningAddress = inetAddress;
        this.mSocket = new MulticastSocket(9875);
        this.mSocket.joinGroup(this.listeningAddress);
        this.advertisementList = new Vector();
        this.invalidAdvertisements = 0;
        try {
            SAPListener = Listener.getListener();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    int getInvalidAdvertisementCount() {
        return this.invalidAdvertisements;
    }

    InetAddress getListeningAddress() {
        return this.listeningAddress;
    }

    int getCurrentAdCount() {
        return this.advertisementList.size();
    }

    synchronized Advertisement[] getAdvertisements() {
        Advertisement[] advertisementArray = new Advertisement[this.advertisementList.size()];
        int n = 0;
        int n2 = 0;
        while (n < this.advertisementList.size()) {
            Advertisement advertisement = (Advertisement)this.advertisementList.elementAt(n);
            Advertisement advertisement2 = (Advertisement)advertisement.clone();
            if (advertisement2 != null) {
                advertisementArray[n2++] = advertisement2;
            }
            ++n;
        }
        return advertisementArray;
    }

    synchronized boolean isAddressInUse(InetAddress inetAddress) {
        int n = 0;
        while (n < this.advertisementList.size()) {
            Advertisement advertisement = (Advertisement)this.advertisementList.elementAt(n);
            if (inetAddress.equals(advertisement.getAdvertisedAddress())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    synchronized Advertisement findOriginalAdvertisement(Advertisement advertisement) {
        int n = 0;
        while (n < this.advertisementList.size()) {
            Advertisement advertisement2 = (Advertisement)this.advertisementList.elementAt(n);
            if (advertisement2.matches(advertisement)) {
                return advertisement2;
            }
            ++n;
        }
        return null;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    byte[] byArray = new byte[2048];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, 2048);
                    this.mSocket.receive(datagramPacket);
                    Advertisement advertisement = new Advertisement(datagramPacket);
                    if (advertisement.isDeletion()) {
                        this.deleteAdvertisement(advertisement);
                        continue;
                    }
                    this.checkForDuplicate(advertisement);
                }
            }
            catch (IOException iOException) {
                continue;
            }
            catch (InvalidAdvertisementException invalidAdvertisementException) {
                ++this.invalidAdvertisements;
                continue;
            }
            break;
        }
    }

    private synchronized void checkForDuplicate(Advertisement advertisement) {
        int n = 0;
        while (n < this.advertisementList.size()) {
            Advertisement advertisement2 = (Advertisement)this.advertisementList.elementAt(n);
            if (advertisement2.matches(advertisement)) {
                if (advertisement2.getVersion() < advertisement.getVersion()) {
                    this.advertisementList.removeElement(advertisement2);
                    advertisement2.replace(advertisement);
                    this.advertisementList.addElement(advertisement);
                    return;
                }
                advertisement2.setLastTime(new Date());
                return;
            }
            ++n;
        }
        this.advertisementList.addElement(advertisement);
        SAPListener.informListenersAdd(advertisement);
    }

    private synchronized void deleteAdvertisement(Advertisement advertisement) {
        int n = 0;
        while (n < this.advertisementList.size()) {
            Advertisement advertisement2 = (Advertisement)this.advertisementList.elementAt(n);
            if (advertisement2.matches(advertisement)) {
                this.advertisementList.removeElement(advertisement2);
                advertisement2.delete();
                return;
            }
            ++n;
        }
    }

    synchronized void timeout(Date date) {
        if (this.getCurrentAdCount() == 0) {
            return;
        }
        int n = 1800;
        int n2 = ((Advertisement)this.advertisementList.elementAt(0)).recalculateInterval(this.listeningAddress);
        if (n2 * 10 > n) {
            n = n2 * 10;
        }
        int n3 = 0;
        while (n3 < this.advertisementList.size()) {
            Advertisement advertisement = (Advertisement)this.advertisementList.elementAt(n3);
            if (advertisement.getEndTime() != null && date.after(advertisement.getEndTime()) || date.getTime() - advertisement.getLastTime().getTime() > (long)(n * 1000)) {
                advertisement.delete();
                this.advertisementList.removeElement(advertisement);
            }
            ++n3;
        }
    }
}

