/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.advertising;

import com.sun.multicast.advertising.Advertisement;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Vector;

class AddressAdvertiser {
    static final int SD_PORT = 9875;
    InetAddress advertisingAddress;
    Vector advertisementList;
    private MulticastSocket mSocket;

    AddressAdvertiser(InetAddress inetAddress) throws IOException {
        this.advertisingAddress = inetAddress;
        this.mSocket = new MulticastSocket(9875);
        this.mSocket.joinGroup(this.advertisingAddress);
        this.advertisementList = new Vector();
    }

    synchronized void startAdvertising(InetAddress inetAddress, int n, Date date, Date date2) throws UnknownHostException {
        Advertisement advertisement = new Advertisement(inetAddress, n);
        if (date != null) {
            advertisement.setStartTime(date);
        }
        if (date2 != null) {
            advertisement.setEndTime(date2);
        }
        this.advertisementList.addElement(advertisement);
    }

    synchronized void startAdvertising(Advertisement advertisement) {
        this.advertisementList.addElement(advertisement);
    }

    synchronized boolean stopAdvertising(InetAddress inetAddress) {
        int n = this.advertisementList.size();
        int n2 = 0;
        while (n2 < n) {
            Advertisement advertisement = (Advertisement)this.advertisementList.elementAt(n2);
            if (inetAddress.equals(advertisement.getAdvertisedAddress())) {
                advertisement.stopAdvertising(this.advertisingAddress, this.mSocket);
                this.advertisementList.removeElementAt(n2);
                return true;
            }
            ++n2;
        }
        return false;
    }

    synchronized boolean stopAdvertising(Advertisement advertisement) {
        int n = this.advertisementList.size();
        int n2 = 0;
        while (n2 < n) {
            Advertisement advertisement2 = (Advertisement)this.advertisementList.elementAt(n2);
            if (advertisement2.matches(advertisement)) {
                advertisement2.stopAdvertising(this.advertisingAddress, this.mSocket);
                this.advertisementList.removeElementAt(n2);
                return true;
            }
            ++n2;
        }
        return false;
    }

    int getAdvertisementCount() {
        return this.advertisementList.size();
    }

    InetAddress getAdvertisingAddress() {
        return this.advertisingAddress;
    }

    synchronized void timeout(int n) throws IOException {
        int n2 = 0;
        while (n2 < this.advertisementList.size()) {
            ((Advertisement)this.advertisementList.elementAt(n2)).advertise(this.advertisingAddress, this.mSocket, n);
            ++n2;
        }
    }
}

