/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import zipkin.Codec;
import zipkin.internal.Util;

public final class DependencyLink
implements Serializable {
    private static final long serialVersionUID = 0L;
    public final String parent;
    public final String child;
    public final long callCount;

    public static DependencyLink create(String parent, String child, long callCount) {
        return new DependencyLink(parent, child, callCount);
    }

    DependencyLink(String parent, String child, long callCount) {
        this.parent = Util.checkNotNull(parent, "parent").toLowerCase();
        this.child = Util.checkNotNull(child, "child").toLowerCase();
        this.callCount = callCount;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return new String(Codec.JSON.writeDependencyLink(this), Util.UTF_8);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DependencyLink) {
            DependencyLink that = (DependencyLink)o;
            return this.parent.equals(that.parent) && this.child.equals(that.child) && this.callCount == that.callCount;
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.parent.hashCode();
        h *= 1000003;
        h ^= this.child.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.callCount >>> 32 ^ this.callCount));
        return h;
    }

    final Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(Codec.THRIFT.writeDependencyLink(this));
    }

    static final class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final byte[] bytes;

        SerializedForm(byte[] bytes) {
            this.bytes = bytes;
        }

        Object readResolve() throws ObjectStreamException {
            try {
                return Codec.THRIFT.readDependencyLink(this.bytes);
            }
            catch (IllegalArgumentException e) {
                throw new StreamCorruptedException(e.getMessage());
            }
        }
    }

    public static final class Builder {
        private String parent;
        private String child;
        private long callCount;

        Builder() {
        }

        Builder(DependencyLink source) {
            this.parent = source.parent;
            this.child = source.child;
            this.callCount = source.callCount;
        }

        public Builder parent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder child(String child) {
            this.child = child;
            return this;
        }

        public Builder callCount(long callCount) {
            this.callCount = callCount;
            return this;
        }

        public DependencyLink build() {
            return new DependencyLink(this.parent, this.child, this.callCount);
        }
    }
}

