/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AnnotationSubmitter;
import com.github.kristofa.brave.AutoValue_ServerTracer;
import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerSpanState;
import com.github.kristofa.brave.SpanAndEndpoint;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanCollectorReporterAdapter;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.internal.Nullable;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Endpoint;
import java.util.Random;
import zipkin.Span;
import zipkin.reporter.Reporter;

public abstract class ServerTracer
extends AnnotationSubmitter {
    public static Builder builder() {
        return new AutoValue_ServerTracer.Builder();
    }

    @Override
    abstract SpanAndEndpoint.ServerSpanAndEndpoint spanAndEndpoint();

    abstract Random randomGenerator();

    abstract Reporter<Span> reporter();

    abstract Sampler traceSampler();

    @Override
    abstract AnnotationSubmitter.Clock clock();

    abstract boolean traceId128Bit();

    public void clearCurrentSpan() {
        this.spanAndEndpoint().state().setCurrentServerSpan(null);
    }

    @Deprecated
    public void setStateCurrentTrace(long traceId, long spanId, @Nullable Long parentSpanId, String name) {
        SpanId id = SpanId.builder().traceId(traceId).spanId(spanId).parentId(parentSpanId).build();
        this.setStateCurrentTrace(id, name);
    }

    public void setStateCurrentTrace(SpanId spanId, String spanName) {
        Util.checkNotBlank(spanName, "Null or blank span name", new Object[0]);
        ServerSpan span = ServerSpan.create(spanId.toSpan().setName(spanName));
        this.spanAndEndpoint().state().setCurrentServerSpan(span);
    }

    public void setStateNoTracing() {
        this.spanAndEndpoint().state().setCurrentServerSpan(ServerSpan.NOT_SAMPLED);
    }

    public void setStateUnknown(String spanName) {
        Util.checkNotBlank(spanName, "Null or blank span name", new Object[0]);
        long newTraceId = this.randomGenerator().nextLong();
        if (!this.traceSampler().isSampled(newTraceId)) {
            this.spanAndEndpoint().state().setCurrentServerSpan(ServerSpan.NOT_SAMPLED);
            return;
        }
        SpanId spanId = SpanId.builder().traceIdHigh(this.traceId128Bit() ? this.randomGenerator().nextLong() : 0L).traceId(newTraceId).spanId(newTraceId).build();
        this.setStateCurrentTrace(spanId, spanName);
    }

    public void setServerReceived() {
        this.submitStartAnnotation("sr");
    }

    public void setServerReceived(Endpoint client) {
        this.submitAddress("ca", client);
        this.submitStartAnnotation("sr");
    }

    @Deprecated
    public void setServerReceived(int ipv4, int port, @Nullable String clientService) {
        if (clientService == null) {
            clientService = "unknown";
        }
        this.setServerReceived(Endpoint.builder().ipv4(ipv4).port(port).serviceName(clientService).build());
    }

    public void setServerSend() {
        if (this.submitEndAnnotation("ss", this.reporter())) {
            this.spanAndEndpoint().state().setCurrentServerSpan(null);
        }
    }

    ServerTracer() {
    }

    public static abstract class Builder {
        public Builder state(ServerSpanState state) {
            return this.spanAndEndpoint(SpanAndEndpoint.ServerSpanAndEndpoint.create(state));
        }

        abstract Builder spanAndEndpoint(SpanAndEndpoint.ServerSpanAndEndpoint var1);

        public abstract Builder randomGenerator(Random var1);

        public abstract Builder reporter(Reporter<Span> var1);

        @Deprecated
        public final Builder spanCollector(SpanCollector spanCollector) {
            return this.reporter(new SpanCollectorReporterAdapter(spanCollector));
        }

        public abstract Builder traceSampler(Sampler var1);

        public abstract Builder clock(AnnotationSubmitter.Clock var1);

        abstract Builder traceId128Bit(boolean var1);

        public abstract ServerTracer build();
    }
}

