/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.app.user;

import com.riversoft.weixin.app.AppWxClientFactory;
import com.riversoft.weixin.app.base.AppSetting;
import com.riversoft.weixin.app.base.WxEndpoint;
import com.riversoft.weixin.app.user.SessionKey;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.util.JsonMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Users {
    private static Logger logger = LoggerFactory.getLogger(Users.class);
    private WxClient wxClient;

    public static Users defaultUsers() {
        return Users.with(AppSetting.defaultSettings());
    }

    public static Users with(AppSetting appSetting) {
        Users cards = new Users();
        cards.setWxClient(AppWxClientFactory.getInstance().with(appSetting));
        return cards;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public SessionKey code2Session(String code) {
        String url = WxEndpoint.get("url.user.code2session");
        String sessionKey = this.wxClient.get(String.format(url, this.wxClient.getClientId(), this.wxClient.getClientSecret(), code));
        logger.debug("code to session key: {}", (Object)sessionKey);
        return (SessionKey)JsonMapper.nonEmptyMapper().fromJson(sessionKey, SessionKey.class);
    }
}

