/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.sqlclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.sqlclient.RowSet;
import io.vertx.rxjava.sqlclient.Tuple;
import java.util.List;
import java.util.stream.Collectors;
import rx.Single;

@RxGen(value=io.vertx.sqlclient.SqlClient.class)
public class SqlClient {
    public static final TypeArg<SqlClient> __TYPE_ARG = new TypeArg(obj -> new SqlClient((io.vertx.sqlclient.SqlClient)obj), SqlClient::getDelegate);
    private final io.vertx.sqlclient.SqlClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlClient that = (SqlClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SqlClient(io.vertx.sqlclient.SqlClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.sqlclient.SqlClient getDelegate() {
        return this.delegate;
    }

    public SqlClient query(String sql, final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.query(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<RowSet> rxQuery(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.query(sql, (Handler<AsyncResult<RowSet>>)fut)));
    }

    public SqlClient preparedQuery(String sql, final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.preparedQuery(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<RowSet> rxPreparedQuery(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.preparedQuery(sql, (Handler<AsyncResult<RowSet>>)fut)));
    }

    public SqlClient preparedQuery(String sql, Tuple arguments, final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.preparedQuery(sql, arguments.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<RowSet> rxPreparedQuery(String sql, Tuple arguments) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.preparedQuery(sql, arguments, (Handler<AsyncResult<RowSet>>)fut)));
    }

    public SqlClient preparedBatch(String sql, List<Tuple> batch, final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.preparedBatch(sql, batch.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<RowSet> rxPreparedBatch(String sql, List<Tuple> batch) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.preparedBatch(sql, batch, (Handler<AsyncResult<RowSet>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public static SqlClient newInstance(io.vertx.sqlclient.SqlClient arg) {
        return arg != null ? new SqlClient(arg) : null;
    }
}

