/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.sqlclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.sqlclient.Cursor;
import io.vertx.rxjava.sqlclient.Row;
import io.vertx.rxjava.sqlclient.RowSet;
import io.vertx.rxjava.sqlclient.RowStream;
import io.vertx.rxjava.sqlclient.Tuple;
import java.util.List;
import java.util.stream.Collectors;
import rx.Single;

@RxGen(value=io.vertx.sqlclient.PreparedQuery.class)
public class PreparedQuery {
    public static final TypeArg<PreparedQuery> __TYPE_ARG = new TypeArg(obj -> new PreparedQuery((io.vertx.sqlclient.PreparedQuery)obj), PreparedQuery::getDelegate);
    private final io.vertx.sqlclient.PreparedQuery delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreparedQuery that = (PreparedQuery)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public PreparedQuery(io.vertx.sqlclient.PreparedQuery delegate) {
        this.delegate = delegate;
    }

    public io.vertx.sqlclient.PreparedQuery getDelegate() {
        return this.delegate;
    }

    public PreparedQuery execute(final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.execute((Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<RowSet> rxExecute() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.execute((Handler<AsyncResult<RowSet>>)fut)));
    }

    public PreparedQuery execute(Tuple args, final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.execute(args.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<RowSet> rxExecute(Tuple args) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.execute(args, (Handler<AsyncResult<RowSet>>)fut)));
    }

    public Cursor cursor() {
        Cursor ret = Cursor.newInstance(this.delegate.cursor());
        return ret;
    }

    public Cursor cursor(Tuple args) {
        Cursor ret = Cursor.newInstance(this.delegate.cursor(args.getDelegate()));
        return ret;
    }

    public RowStream<Row> createStream(int fetch, Tuple args) {
        RowStream<Row> ret = RowStream.newInstance(this.delegate.createStream(fetch, args.getDelegate()), Row.__TYPE_ARG);
        return ret;
    }

    public PreparedQuery batch(List<Tuple> argsList, final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.batch(argsList.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<RowSet> rxBatch(List<Tuple> argsList) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.batch(argsList, (Handler<AsyncResult<RowSet>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public static PreparedQuery newInstance(io.vertx.sqlclient.PreparedQuery arg) {
        return arg != null ? new PreparedQuery(arg) : null;
    }
}

