/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.sql;

import io.vertx.rxjava.ext.sql.SQLClient;
import io.vertx.rxjava.ext.sql.SQLConnection;
import io.vertx.rxjava.ext.sql.impl.InTransactionCompletable;
import io.vertx.rxjava.ext.sql.impl.InTransactionObservable;
import io.vertx.rxjava.ext.sql.impl.InTransactionSingle;
import java.util.function.Function;
import rx.Completable;
import rx.Observable;
import rx.Single;
import rx.exceptions.Exceptions;

public class SQLClientHelper {
    public static <T> Observable.Transformer<T, T> txObservableTransformer(SQLConnection sqlConnection) {
        return new InTransactionObservable(sqlConnection);
    }

    public static <T> Observable<T> inTransactionObservable(SQLClient client, Function<SQLConnection, Observable<T>> sourceSupplier) {
        return SQLClientHelper.usingConnectionObservable(client, conn -> ((Observable)sourceSupplier.apply((SQLConnection)conn)).compose(SQLClientHelper.txObservableTransformer(conn)));
    }

    public static <T> Single.Transformer<T, T> txSingleTransformer(SQLConnection sqlConnection) {
        return new InTransactionSingle(sqlConnection);
    }

    public static <T> Single<T> inTransactionSingle(SQLClient client, Function<SQLConnection, Single<T>> sourceSupplier) {
        return SQLClientHelper.usingConnectionSingle(client, conn -> ((Single)sourceSupplier.apply((SQLConnection)conn)).compose(SQLClientHelper.txSingleTransformer(conn)));
    }

    public static Completable.Transformer txCompletableTransformer(SQLConnection sqlConnection) {
        return new InTransactionCompletable(sqlConnection);
    }

    public static Completable inTransactionCompletable(SQLClient client, Function<SQLConnection, Completable> sourceSupplier) {
        return SQLClientHelper.usingConnectionCompletable(client, conn -> ((Completable)sourceSupplier.apply((SQLConnection)conn)).compose(SQLClientHelper.txCompletableTransformer(conn)));
    }

    public static <T> Observable<T> usingConnectionObservable(SQLClient client, Function<SQLConnection, Observable<T>> sourceSupplier) {
        return client.rxGetConnection().flatMapObservable(conn -> {
            try {
                return ((Observable)sourceSupplier.apply((SQLConnection)conn)).doAfterTerminate(conn::close);
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal((Throwable)t);
                conn.close();
                return Observable.error((Throwable)t);
            }
        });
    }

    public static <T> Single<T> usingConnectionSingle(SQLClient client, Function<SQLConnection, Single<T>> sourceSupplier) {
        return client.rxGetConnection().flatMap(conn -> {
            try {
                return ((Single)sourceSupplier.apply((SQLConnection)conn)).doAfterTerminate(conn::close);
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal((Throwable)t);
                conn.close();
                return Single.error((Throwable)t);
            }
        });
    }

    public static Completable usingConnectionCompletable(SQLClient client, Function<SQLConnection, Completable> sourceSupplier) {
        return client.rxGetConnection().flatMapCompletable(conn -> {
            try {
                return ((Completable)sourceSupplier.apply((SQLConnection)conn)).doAfterTerminate(conn::close);
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal((Throwable)t);
                conn.close();
                return Completable.error((Throwable)t);
            }
        });
    }

    private SQLClientHelper() {
    }
}

