/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.sql;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.ext.sql.SQLConnection;
import io.vertx.rxjava.ext.sql.SQLOperations;
import io.vertx.rxjava.ext.sql.SQLRowStream;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.ext.sql.SQLClient.class)
public class SQLClient
implements SQLOperations {
    public static final TypeArg<SQLClient> __TYPE_ARG = new TypeArg(obj -> new SQLClient((io.vertx.ext.sql.SQLClient)obj), SQLClient::getDelegate);
    private final io.vertx.ext.sql.SQLClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLClient that = (SQLClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SQLClient(io.vertx.ext.sql.SQLClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.ext.sql.SQLClient getDelegate() {
        return this.delegate;
    }

    @Override
    public SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.querySingle(sql, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> querySingleObservable(String sql) {
        ObservableFuture<JsonArray> handler = RxHelper.observableFuture();
        this.querySingle(sql, handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxQuerySingle(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.querySingle(sql, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    @Override
    public SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.querySingleWithParams(sql, arguments, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> querySingleWithParamsObservable(String sql, JsonArray arguments) {
        ObservableFuture<JsonArray> handler = RxHelper.observableFuture();
        this.querySingleWithParams(sql, arguments, handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.querySingleWithParams(sql, arguments, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public SQLClient getConnection(final Handler<AsyncResult<SQLConnection>> handler) {
        this.delegate.getConnection((Handler)new Handler<AsyncResult<io.vertx.ext.sql.SQLConnection>>(){

            public void handle(AsyncResult<io.vertx.ext.sql.SQLConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)SQLConnection.newInstance((io.vertx.ext.sql.SQLConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<SQLConnection> getConnectionObservable() {
        ObservableFuture<SQLConnection> handler = RxHelper.observableFuture();
        this.getConnection(handler.toHandler());
        return handler;
    }

    public Single<SQLConnection> rxGetConnection() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.getConnection((Handler<AsyncResult<SQLConnection>>)fut)));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Deprecated
    public Observable<Void> closeObservable() {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.close(handler.toHandler());
        return handler;
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    @Override
    public SQLClient query(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.delegate.query(sql, handler);
        return this;
    }

    @Deprecated
    public Observable<ResultSet> queryObservable(String sql) {
        ObservableFuture<ResultSet> handler = RxHelper.observableFuture();
        this.query(sql, handler.toHandler());
        return handler;
    }

    public Single<ResultSet> rxQuery(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.query(sql, (Handler)fut)));
    }

    @Override
    public SQLClient queryStream(String sql, final Handler<AsyncResult<SQLRowStream>> handler) {
        this.delegate.queryStream(sql, (Handler)new Handler<AsyncResult<io.vertx.ext.sql.SQLRowStream>>(){

            public void handle(AsyncResult<io.vertx.ext.sql.SQLRowStream> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<SQLRowStream> queryStreamObservable(String sql) {
        ObservableFuture<SQLRowStream> handler = RxHelper.observableFuture();
        this.queryStream(sql, handler.toHandler());
        return handler;
    }

    public Single<SQLRowStream> rxQueryStream(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queryStream(sql, (Handler)fut)));
    }

    @Override
    public SQLClient queryStreamWithParams(String sql, JsonArray params, final Handler<AsyncResult<SQLRowStream>> handler) {
        this.delegate.queryStreamWithParams(sql, params, (Handler)new Handler<AsyncResult<io.vertx.ext.sql.SQLRowStream>>(){

            public void handle(AsyncResult<io.vertx.ext.sql.SQLRowStream> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<SQLRowStream> queryStreamWithParamsObservable(String sql, JsonArray params) {
        ObservableFuture<SQLRowStream> handler = RxHelper.observableFuture();
        this.queryStreamWithParams(sql, params, handler.toHandler());
        return handler;
    }

    public Single<SQLRowStream> rxQueryStreamWithParams(String sql, JsonArray params) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queryStreamWithParams(sql, params, (Handler)fut)));
    }

    @Override
    public SQLClient queryWithParams(String sql, JsonArray arguments, Handler<AsyncResult<ResultSet>> handler) {
        this.delegate.queryWithParams(sql, arguments, handler);
        return this;
    }

    @Deprecated
    public Observable<ResultSet> queryWithParamsObservable(String sql, JsonArray arguments) {
        ObservableFuture<ResultSet> handler = RxHelper.observableFuture();
        this.queryWithParams(sql, arguments, handler.toHandler());
        return handler;
    }

    public Single<ResultSet> rxQueryWithParams(String sql, JsonArray arguments) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queryWithParams(sql, arguments, (Handler)fut)));
    }

    @Override
    public SQLClient update(String sql, Handler<AsyncResult<UpdateResult>> handler) {
        this.delegate.update(sql, handler);
        return this;
    }

    @Deprecated
    public Observable<UpdateResult> updateObservable(String sql) {
        ObservableFuture<UpdateResult> handler = RxHelper.observableFuture();
        this.update(sql, handler.toHandler());
        return handler;
    }

    public Single<UpdateResult> rxUpdate(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.update(sql, (Handler)fut)));
    }

    @Override
    public SQLClient updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> handler) {
        this.delegate.updateWithParams(sql, params, handler);
        return this;
    }

    @Deprecated
    public Observable<UpdateResult> updateWithParamsObservable(String sql, JsonArray params) {
        ObservableFuture<UpdateResult> handler = RxHelper.observableFuture();
        this.updateWithParams(sql, params, handler.toHandler());
        return handler;
    }

    public Single<UpdateResult> rxUpdateWithParams(String sql, JsonArray params) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.updateWithParams(sql, params, (Handler)fut)));
    }

    @Override
    public SQLClient call(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.delegate.call(sql, handler);
        return this;
    }

    @Deprecated
    public Observable<ResultSet> callObservable(String sql) {
        ObservableFuture<ResultSet> handler = RxHelper.observableFuture();
        this.call(sql, handler.toHandler());
        return handler;
    }

    public Single<ResultSet> rxCall(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.call(sql, (Handler)fut)));
    }

    @Override
    public SQLClient callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> handler) {
        this.delegate.callWithParams(sql, params, outputs, handler);
        return this;
    }

    @Deprecated
    public Observable<ResultSet> callWithParamsObservable(String sql, JsonArray params, JsonArray outputs) {
        ObservableFuture<ResultSet> handler = RxHelper.observableFuture();
        this.callWithParams(sql, params, outputs, handler.toHandler());
        return handler;
    }

    public Single<ResultSet> rxCallWithParams(String sql, JsonArray params, JsonArray outputs) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.callWithParams(sql, params, outputs, (Handler)fut)));
    }

    public static SQLClient newInstance(io.vertx.ext.sql.SQLClient arg) {
        return arg != null ? new SQLClient(arg) : null;
    }
}

