/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.eventbus;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rxjava.core.eventbus.Message;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.eventbus.MessageProducer.class)
public class MessageProducer<T>
implements WriteStream<T> {
    public static final TypeArg<MessageProducer> __TYPE_ARG = new TypeArg(obj -> new MessageProducer((io.vertx.core.eventbus.MessageProducer)obj), MessageProducer::getDelegate);
    private final io.vertx.core.eventbus.MessageProducer<T> delegate;
    public final TypeArg<T> __typeArg_0;
    private WriteStreamSubscriber<T> subscriber;
    public static final int DEFAULT_WRITE_QUEUE_MAX_SIZE = 1000;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageProducer that = (MessageProducer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate, TypeArg<T> typeArg_0) {
        this.delegate = delegate;
        this.__typeArg_0 = typeArg_0;
    }

    public io.vertx.core.eventbus.MessageProducer getDelegate() {
        return this.delegate;
    }

    public synchronized WriteStreamSubscriber<T> toSubscriber() {
        if (this.subscriber == null) {
            Function conv = this.__typeArg_0.unwrap;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void end(T data) {
        this.delegate.end(this.__typeArg_0.unwrap(data));
    }

    @Override
    public void end(T data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(this.__typeArg_0.unwrap(data), handler);
    }

    @Deprecated
    public Observable<Void> endObservable(T data) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.end(data, handler.toHandler());
        return handler;
    }

    public Single<Void> rxEnd(T data) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(data, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Deprecated
    public MessageProducer<T> send(T message) {
        MessageProducer<T> ret = MessageProducer.newInstance(this.delegate.send(this.__typeArg_0.unwrap(message)), this.__typeArg_0);
        return ret;
    }

    @Deprecated
    public <R> MessageProducer<T> send(T message, final Handler<AsyncResult<Message<R>>> replyHandler) {
        MessageProducer<T> ret = MessageProducer.newInstance(this.delegate.send(this.__typeArg_0.unwrap(message), new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>(){

            public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> ar) {
                if (ar.succeeded()) {
                    replyHandler.handle((Object)Future.succeededFuture(Message.newInstance((io.vertx.core.eventbus.Message)ar.result(), TypeArg.unknown())));
                } else {
                    replyHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }), this.__typeArg_0);
        return ret;
    }

    @Override
    public MessageProducer<T> exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public MessageProducer<T> write(T data) {
        this.delegate.write(this.__typeArg_0.unwrap(data));
        return this;
    }

    @Override
    public MessageProducer<T> write(T data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(this.__typeArg_0.unwrap(data), handler);
        return this;
    }

    @Deprecated
    public Observable<Void> writeObservable(T data) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.write((Object)data, handler.toHandler());
        return handler;
    }

    public Single<Void> rxWrite(T data) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write((Object)data, (Handler)fut)));
    }

    @Override
    public MessageProducer<T> setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public MessageProducer<T> drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public MessageProducer<T> deliveryOptions(DeliveryOptions options) {
        this.delegate.deliveryOptions(options);
        return this;
    }

    public String address() {
        String ret = this.delegate.address();
        return ret;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Deprecated
    public Observable<Void> endObservable() {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.end(handler.toHandler());
        return handler;
    }

    public Single<Void> rxEnd() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end((Handler<AsyncResult<Void>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Deprecated
    public Observable<Void> closeObservable() {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.close(handler.toHandler());
        return handler;
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public static <T> MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg) {
        return arg != null ? new MessageProducer<T>(arg) : null;
    }

    public static <T> MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg, TypeArg<T> __typeArg_T) {
        return arg != null ? new MessageProducer<T>(arg, __typeArg_T) : null;
    }
}

