/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.amqp;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rxjava.amqp.AmqpConnection;
import io.vertx.rxjava.amqp.AmqpMessage;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Single;

@RxGen(value=io.vertx.amqp.AmqpSender.class)
public class AmqpSender
implements WriteStream<AmqpMessage> {
    public static final TypeArg<AmqpSender> __TYPE_ARG = new TypeArg(obj -> new AmqpSender((io.vertx.amqp.AmqpSender)obj), AmqpSender::getDelegate);
    private final io.vertx.amqp.AmqpSender delegate;
    private WriteStreamSubscriber<AmqpMessage> subscriber;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpSender that = (AmqpSender)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AmqpSender(io.vertx.amqp.AmqpSender delegate) {
        this.delegate = delegate;
    }

    public io.vertx.amqp.AmqpSender getDelegate() {
        return this.delegate;
    }

    public synchronized WriteStreamSubscriber<AmqpMessage> toSubscriber() {
        if (this.subscriber == null) {
            Function<AmqpMessage, io.vertx.amqp.AmqpMessage> conv = AmqpMessage::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    public Single<Void> rxEnd() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end((Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(AmqpMessage data) {
        this.delegate.end((Object)data.getDelegate());
    }

    @Override
    public void end(AmqpMessage data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end((Object)data.getDelegate(), handler);
    }

    public Single<Void> rxEnd(AmqpMessage data) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(data, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public WriteStream<AmqpMessage> drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public AmqpSender write(AmqpMessage data) {
        this.delegate.write(data.getDelegate());
        return this;
    }

    public AmqpSender write(AmqpMessage data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(data.getDelegate(), handler);
        return this;
    }

    public Single<Void> rxWrite(AmqpMessage data) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(data, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public AmqpSender exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public AmqpSender setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public AmqpSender send(AmqpMessage message) {
        this.delegate.send(message.getDelegate());
        return this;
    }

    public AmqpSender sendWithAck(AmqpMessage message, Handler<AsyncResult<Void>> acknowledgementHandler) {
        this.delegate.sendWithAck(message.getDelegate(), acknowledgementHandler);
        return this;
    }

    public Single<Void> rxSendWithAck(AmqpMessage message) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sendWithAck(message, (Handler<AsyncResult<Void>>)fut)));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public String address() {
        String ret = this.delegate.address();
        return ret;
    }

    public AmqpConnection connection() {
        AmqpConnection ret = AmqpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public static AmqpSender newInstance(io.vertx.amqp.AmqpSender arg) {
        return arg != null ? new AmqpSender(arg) : null;
    }
}

