/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpVersion;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.http.HttpClientRequest;
import io.vertx.rxjava.core.http.HttpFrame;
import io.vertx.rxjava.core.net.NetSocket;
import io.vertx.rxjava.core.streams.ReadStream;
import java.util.List;
import java.util.function.Function;
import rx.Observable;

@RxGen(value=io.vertx.core.http.HttpClientResponse.class)
public class HttpClientResponse
implements ReadStream<Buffer> {
    public static final TypeArg<HttpClientResponse> __TYPE_ARG = new TypeArg<HttpClientResponse>(obj -> new HttpClientResponse((io.vertx.core.http.HttpClientResponse)obj), HttpClientResponse::getDelegate);
    private final io.vertx.core.http.HttpClientResponse delegate;
    private Observable<Buffer> observable;
    private MultiMap cached_0;
    private MultiMap cached_1;
    private List<String> cached_2;
    private NetSocket cached_3;
    private HttpClientRequest cached_4;

    public HttpClientResponse(io.vertx.core.http.HttpClientResponse delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.http.HttpClientResponse getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Buffer> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.observable = RxHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    public HttpClientResponse resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpClientResponse handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle((Object)Buffer.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientResponse pause() {
        this.delegate.pause();
        return this;
    }

    public HttpClientResponse endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    public int statusCode() {
        int ret = this.delegate.statusCode();
        return ret;
    }

    public String statusMessage() {
        String ret = this.delegate.statusMessage();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public String getHeader(String headerName) {
        String ret = this.delegate.getHeader(headerName);
        return ret;
    }

    public String getTrailer(String trailerName) {
        String ret = this.delegate.getTrailer(trailerName);
        return ret;
    }

    public MultiMap trailers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = MultiMap.newInstance(this.delegate.trailers());
        return ret;
    }

    public List<String> cookies() {
        List ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = this.delegate.cookies();
        return ret;
    }

    public HttpClientResponse bodyHandler(final Handler<Buffer> bodyHandler) {
        this.delegate.bodyHandler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                bodyHandler.handle((Object)Buffer.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientResponse customFrameHandler(final Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler((Handler)new Handler<io.vertx.core.http.HttpFrame>(){

            public void handle(io.vertx.core.http.HttpFrame event) {
                handler.handle((Object)HttpFrame.newInstance(event));
            }
        });
        return this;
    }

    public NetSocket netSocket() {
        NetSocket ret;
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        this.cached_3 = ret = NetSocket.newInstance(this.delegate.netSocket());
        return ret;
    }

    public HttpClientRequest request() {
        HttpClientRequest ret;
        if (this.cached_4 != null) {
            return this.cached_4;
        }
        this.cached_4 = ret = HttpClientRequest.newInstance(this.delegate.request());
        return ret;
    }

    public static HttpClientResponse newInstance(io.vertx.core.http.HttpClientResponse arg) {
        return arg != null ? new HttpClientResponse(arg) : null;
    }
}

