/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.connection.SslSettings;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.impl.TrustAllTrustManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

class SSLSettingsParser {
    private static final Logger log = LoggerFactory.getLogger(SSLSettingsParser.class);
    private final ConnectionString connectionString;
    private final JsonObject config;

    SSLSettingsParser(ConnectionString connectionString, JsonObject config) {
        this.connectionString = connectionString;
        this.config = config;
    }

    public SslSettings settings() {
        SslSettings.Builder builder = this.fromConnectionString().orElseGet(this::fromConfiguration);
        if (this.config.getBoolean("trustAll", Boolean.valueOf(false)).booleanValue()) {
            log.warn((Object)"Mongo client has been set to trust ALL certificates, this can open you up to security issues. Make sure you know the risks.");
            try {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, new TrustManager[]{TrustAllTrustManager.INSTANCE}, new SecureRandom());
                builder.context(context);
            }
            catch (KeyManagementException | NoSuchAlgorithmException context) {
                // empty catch block
            }
        }
        if (this.config.containsKey("caPath")) {
            String caPath = this.config.getString("caPath");
            try {
                TrustManagerFactory tmf = SSLSettingsParser.buildTrustManagerFactory(caPath);
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, tmf.getTrustManagers(), new SecureRandom());
                builder.context(context);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Invalid caPath " + e.getMessage());
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException("Unable to load certificate from caPath '" + caPath + "' " + e.getMessage());
            }
        }
        return builder.build();
    }

    private Optional<SslSettings.Builder> fromConnectionString() {
        return Optional.ofNullable(this.connectionString).map(cs -> SslSettings.builder().applyConnectionString(cs));
    }

    private SslSettings.Builder fromConfiguration() {
        return SslSettings.builder().enabled(this.config.getBoolean("ssl", Boolean.valueOf(false)).booleanValue()).invalidHostNameAllowed(this.config.getBoolean("sslInvalidHostNameAllowed", Boolean.valueOf(false)).booleanValue());
    }

    private static TrustManagerFactory buildTrustManagerFactory(String caPath) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        FileInputStream is = new FileInputStream(caPath);
        X509Certificate cert = (X509Certificate)fact.generateCertificate(is);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, null);
        ks.setCertificateEntry("1", cert);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(ks);
        return trustManagerFactory;
    }
}

