require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.Promise
module Vertx
  #  Represents the writable side of an action that may, or may not, have occurred yet.
  #  <p>
  #  The {::Vertx::Promise#future} method returns the {::Vertx::Future} associated with a promise, the future
  #  can be used for getting notified of the promise completion and retrieve its value.
  #  <p>
  #  A promise extends <code>Handler<AsyncResult<T>></code> so it can be used as a callback.
  class Promise
    # @private
    # @param j_del [::Vertx::Promise] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::Vertx::Promise] the underlying java delegate
    def j_del
      @j_del
    end
    #  Created a succeeded promise with the specified <code>result</code>.
    # @param [Object] result the result
    # @return [::Vertx::Promise] the promise
    def self.succeeded_promise(result=nil)
      if !block_given? && result == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::Promise.java_method(:succeededPromise, []).call(),::Vertx::Promise, nil)
      elsif ::Vertx::Util::unknown_type.accept?(result) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::Promise.java_method(:succeededPromise, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(result)),::Vertx::Promise, nil)
      end
      raise ArgumentError, "Invalid arguments when calling succeeded_promise(#{result})"
    end
    #  Create a failed promise with the specified <code>failureMessage</code>.
    # @overload failedPromise(cause)
    #   @param [Exception] cause the failure cause as a Throwable
    # @overload failedPromise(failureMessage)
    #   @param [String] failureMessage the failure message
    # @return [::Vertx::Promise] the promise
    def self.failed_promise(param_1=nil)
      if param_1.is_a?(Exception) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::Promise.java_method(:failedPromise, [Java::JavaLang::Throwable.java_class]).call(::Vertx::Util::Utils.to_throwable(param_1)),::Vertx::Promise, nil)
      elsif param_1.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::Promise.java_method(:failedPromise, [Java::java.lang.String.java_class]).call(param_1),::Vertx::Promise, nil)
      end
      raise ArgumentError, "Invalid arguments when calling failed_promise(#{param_1})"
    end
    #  Create a promise that hasn't completed yet
    # @return [::Vertx::Promise] the promise
    def self.promise
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::Promise.java_method(:promise, []).call(),::Vertx::Promise, nil)
      end
      raise ArgumentError, "Invalid arguments when calling promise()"
    end
    #  Set the result. Any handler will be called, if there is one, and the promise will be marked as completed.
    #  <p/>
    #  Any handler set on the associated promise will be called.
    # @param [Object] result the result
    # @return [void]
    def complete(result=nil)
      if !block_given? && result == nil
        return @j_del.java_method(:complete, []).call()
      elsif @j_arg_T.accept?(result) && !block_given?
        return @j_del.java_method(:complete, [Java::java.lang.Object.java_class]).call(@j_arg_T.unwrap(result))
      end
      raise ArgumentError, "Invalid arguments when calling complete(#{result})"
    end
    #  Calls {::Vertx::Promise#fail} with the <code>message</code>.
    # @overload fail(cause)
    #   @param [Exception] cause the failure cause
    # @overload fail(message)
    #   @param [String] message the failure message
    # @return [void]
    def fail(param_1=nil)
      if param_1.is_a?(Exception) && !block_given?
        return @j_del.java_method(:fail, [Java::JavaLang::Throwable.java_class]).call(::Vertx::Util::Utils.to_throwable(param_1))
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:fail, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling fail(#{param_1})"
    end
    #  Like {::Vertx::Promise#complete} but returns <code>false</code> when the promise is already completed instead of throwing
    #  an IllegalStateException, it returns <code>true</code> otherwise.
    # @param [Object] result the result
    # @return [true,false] <code>false</code> when the future is already completed
    def try_complete?(result=nil)
      if !block_given? && result == nil
        return @j_del.java_method(:tryComplete, []).call()
      elsif @j_arg_T.accept?(result) && !block_given?
        return @j_del.java_method(:tryComplete, [Java::java.lang.Object.java_class]).call(@j_arg_T.unwrap(result))
      end
      raise ArgumentError, "Invalid arguments when calling try_complete?(#{result})"
    end
    #  Calls {::Vertx::Promise#fail} with the <code>message</code>.
    # @overload tryFail(cause)
    #   @param [Exception] cause the failure cause
    # @overload tryFail(message)
    #   @param [String] message the failure message
    # @return [true,false] false when the future is already completed
    def try_fail?(param_1=nil)
      if param_1.is_a?(Exception) && !block_given?
        return @j_del.java_method(:tryFail, [Java::JavaLang::Throwable.java_class]).call(::Vertx::Util::Utils.to_throwable(param_1))
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:tryFail, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling try_fail?(#{param_1})"
    end
    # @return [::Vertx::Future] the {::Vertx::Future} associated with this promise, it can be used to be aware of the promise completion
    def future
      if !block_given?
        if @cached_future != nil
          return @cached_future
        end
        return @cached_future = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:future, []).call(),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling future()"
    end
  end
end
