require 'vertx-web-common/template_engine'
require 'vertx-web/routing_context'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.TemplateHandler
module VertxWeb
  # 
  #  A handler which renders responses using a template engine and where the template name is selected from the URI
  #  path.
  class TemplateHandler
    # @private
    # @param j_del [::VertxWeb::TemplateHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::TemplateHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == TemplateHandler
    end
    def @@j_api_type.wrap(obj)
      TemplateHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::TemplateHandler.java_class
    end
    #  Something has happened, so handle it.
    # @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(event=nil)
      if event.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(event.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling handle(#{event})"
    end
    #  Set the index template
    # @param [String] indexTemplate the index template
    # @return [self]
    def set_index_template(indexTemplate=nil)
      if indexTemplate.class == String && !block_given?
        @j_del.java_method(:setIndexTemplate, [Java::java.lang.String.java_class]).call(indexTemplate)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_index_template(#{indexTemplate})"
    end
    #  Create a handler
    # @param [::VertxWebCommon::TemplateEngine] engine the template engine
    # @param [String] templateDirectory the template directory where templates will be looked for
    # @param [String] contentType the content type header to be used in the response
    # @return [::VertxWeb::TemplateHandler] the handler
    def self.create(engine=nil,templateDirectory=nil,contentType=nil)
      if engine.class.method_defined?(:j_del) && !block_given? && templateDirectory == nil && contentType == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::TemplateHandler.java_method(:create, [Java::IoVertxExtWebCommonTemplate::TemplateEngine.java_class]).call(engine.j_del),::VertxWeb::TemplateHandler)
      elsif engine.class.method_defined?(:j_del) && templateDirectory.class == String && contentType.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::TemplateHandler.java_method(:create, [Java::IoVertxExtWebCommonTemplate::TemplateEngine.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(engine.j_del,templateDirectory,contentType),::VertxWeb::TemplateHandler)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{engine},#{templateDirectory},#{contentType})"
    end
    #  The default directory where templates will be looked for
    def self.DEFAULT_TEMPLATE_DIRECTORY
      Java::IoVertxExtWebHandler::TemplateHandler.DEFAULT_TEMPLATE_DIRECTORY
    end
    #  The default content type header to be used in the response
    def self.DEFAULT_CONTENT_TYPE
      Java::IoVertxExtWebHandler::TemplateHandler.DEFAULT_CONTENT_TYPE
    end
    #  The default index page
    def self.DEFAULT_INDEX_TEMPLATE
      Java::IoVertxExtWebHandler::TemplateHandler.DEFAULT_INDEX_TEMPLATE
    end
  end
end
