require 'vertx-web/routing_context'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.FaviconHandler
module VertxWeb
  #  A handler that serves favicons.
  #  <p>
  #  If no file system path is specified it will attempt to serve a resource called `favicon.ico` from the classpath.
  class FaviconHandler
    # @private
    # @param j_del [::VertxWeb::FaviconHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::FaviconHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == FaviconHandler
    end
    def @@j_api_type.wrap(obj)
      FaviconHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::FaviconHandler.java_class
    end
    #  Something has happened, so handle it.
    # @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(event=nil)
      if event.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(event.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling handle(#{event})"
    end
    #  Create a handler attempting to load favicon file from the specified path, and with the specified max cache time
    # @overload create()
    # @overload create(path)
    #   @param [String] path the path
    # @overload create(maxAgeSeconds)
    #   @param [Fixnum] maxAgeSeconds max how long the file will be cached by browser, in seconds
    # @overload create(path,maxAgeSeconds)
    #   @param [String] path the path
    #   @param [Fixnum] maxAgeSeconds max how long the file will be cached by browser, in seconds
    # @return [::VertxWeb::FaviconHandler] the handler
    def self.create(param_1=nil,param_2=nil)
      if !block_given? && param_1 == nil && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::FaviconHandler.java_method(:create, []).call(),::VertxWeb::FaviconHandler)
      elsif param_1.class == String && !block_given? && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::FaviconHandler.java_method(:create, [Java::java.lang.String.java_class]).call(param_1),::VertxWeb::FaviconHandler)
      elsif param_1.class == Fixnum && !block_given? && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::FaviconHandler.java_method(:create, [Java::long.java_class]).call(param_1),::VertxWeb::FaviconHandler)
      elsif param_1.class == String && param_2.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::FaviconHandler.java_method(:create, [Java::java.lang.String.java_class,Java::long.java_class]).call(param_1,param_2),::VertxWeb::FaviconHandler)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{param_1},#{param_2})"
    end
    #  The default max age in seconds as set in the cache-control header
    def self.DEFAULT_MAX_AGE_SECONDS
      Java::IoVertxExtWebHandler::FaviconHandler.DEFAULT_MAX_AGE_SECONDS
    end
  end
end
