require 'vertx/server_web_socket'
require 'vertx-web-graphql/apollo_ws_message'
require 'vertx-web/routing_context'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.graphql.ApolloWSHandler
module VertxWebGraphql
  #  A handler for GraphQL requests sent over Apollo's <code>subscriptions-transport-ws</code> transport.
  class ApolloWSHandler
    # @private
    # @param j_del [::VertxWebGraphql::ApolloWSHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebGraphql::ApolloWSHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ApolloWSHandler
    end
    def @@j_api_type.wrap(obj)
      ApolloWSHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandlerGraphql::ApolloWSHandler.java_class
    end
    #  Something has happened, so handle it.
    # @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(event=nil)
      if event.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(event.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling handle(#{event})"
    end
    #  Customize the connection .
    #  This handler will be called at the beginning of each websocket connection.
    # @yield 
    # @return [self]
    def connection_handler
      if block_given?
        @j_del.java_method(:connectionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::ServerWebSocket)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling connection_handler()"
    end
    #  Customize the message .
    #  This handler will be called for each {::VertxWebGraphql::ApolloWSMessage} received.
    # @yield 
    # @return [self]
    def message_handler
      if block_given?
        @j_del.java_method(:messageHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWebGraphql::ApolloWSMessage)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling message_handler()"
    end
    #  Customize the end .
    #  This handler will be called at the end of each websocket connection.
    # @yield 
    # @return [self]
    def end_handler
      if block_given?
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::ServerWebSocket)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling end_handler()"
    end
    #  Customize the query context object.
    #  The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
    # @yield 
    # @return [self]
    def query_context(factory=nil)
      if block_given? && factory == nil
        @j_del.java_method(:queryContext, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| ::Vertx::Util::Utils.to_object(yield(::Vertx::Util::Utils.safe_create(event,::VertxWebGraphql::ApolloWSMessage))) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query_context(#{factory})"
    end
  end
end
