require 'vertx/measured'
require 'vertx/util/utils.rb'
# Generated from io.vertx.micrometer.MetricsService
module VertxMicrometerMetrics
  #  The metrics service mainly allows to return a snapshot of measured objects.<br/>
  #  This service is derived and adapted from <code>MetricsService</code> in the <i>vertx-dropwizard-metrics</i> module.
  class MetricsService
    # @private
    # @param j_del [::VertxMicrometerMetrics::MetricsService] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMicrometerMetrics::MetricsService] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MetricsService
    end
    def @@j_api_type.wrap(obj)
      MetricsService.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxMicrometer::MetricsService.java_class
    end
    #  Creates a metric service for a given  object.
    # @param [::Vertx::Measured] measured the measured object
    # @return [::VertxMicrometerMetrics::MetricsService] the metrics service
    def self.create(measured=nil)
      if measured.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxMicrometer::MetricsService.java_method(:create, [Java::IoVertxCoreMetrics::Measured.java_class]).call(measured.j_del),::VertxMicrometerMetrics::MetricsService)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{measured})"
    end
    # @return [String] the base name of the measured object
    def get_base_name
      if !block_given?
        return @j_del.java_method(:getBaseName, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_base_name()"
    end
    # @return [Set<String>] the known metrics names by this service
    def metrics_names
      if !block_given?
        return ::Vertx::Util::Utils.to_set(@j_del.java_method(:metricsNames, []).call()).map! { |elt| elt }
      end
      raise ArgumentError, "Invalid arguments when calling metrics_names()"
    end
    #  Will return the metrics that begins with the <code>baseName</code>, null if no metrics is available.<p/>
    # @param [String] baseName 
    # @return [Hash{String => Object}] the map of metrics where the key is the name of the metric and the value is the json data representing that metric
    def get_metrics_snapshot(baseName=nil)
      if !block_given? && baseName == nil
        return @j_del.java_method(:getMetricsSnapshot, []).call() != nil ? JSON.parse(@j_del.java_method(:getMetricsSnapshot, []).call().encode) : nil
      elsif baseName.class == String && !block_given?
        return @j_del.java_method(:getMetricsSnapshot, [Java::java.lang.String.java_class]).call(baseName) != nil ? JSON.parse(@j_del.java_method(:getMetricsSnapshot, [Java::java.lang.String.java_class]).call(baseName).encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_metrics_snapshot(#{baseName})"
    end
  end
end
