/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.producer;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.streams.WriteStream;
import io.vertx.kafka.client.common.PartitionInfo;
import io.vertx.kafka.client.producer.KafkaProducerRecord;
import io.vertx.kafka.client.producer.KafkaWriteStream;
import io.vertx.kafka.client.producer.RecordMetadata;
import io.vertx.kafka.client.producer.impl.KafkaProducerImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.Producer;

@VertxGen
public interface KafkaProducer<K, V>
extends WriteStream<KafkaProducerRecord<K, V>> {
    @GenIgnore
    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Properties config) {
        return KafkaProducerImpl.createShared(vertx, name, config);
    }

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Map<String, String> config) {
        return KafkaProducerImpl.createShared(vertx, name, config);
    }

    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Map<String, String> config, Class<K> keyType, Class<V> valueType) {
        return KafkaProducerImpl.createShared(vertx, name, config, keyType, valueType);
    }

    @GenIgnore
    public static <K, V> KafkaProducer<K, V> createShared(Vertx vertx, String name, Properties config, Class<K> keyType, Class<V> valueType) {
        return KafkaProducerImpl.createShared(vertx, name, config, keyType, valueType);
    }

    @GenIgnore
    public static <K, V> KafkaProducer<K, V> create(Vertx vertx, Producer<K, V> producer) {
        KafkaWriteStream<K, V> stream = KafkaWriteStream.create(vertx, producer);
        return new KafkaProducerImpl<K, V>(stream);
    }

    public static <K, V> KafkaProducer<K, V> create(Vertx vertx, Map<String, String> config) {
        KafkaWriteStream stream = KafkaWriteStream.create(vertx, new HashMap<String, Object>(config));
        return new KafkaProducerImpl(stream).registerCloseHook();
    }

    public static <K, V> KafkaProducer<K, V> create(Vertx vertx, Map<String, String> config, Class<K> keyType, Class<V> valueType) {
        KafkaWriteStream<K, V> stream = KafkaWriteStream.create(vertx, new HashMap<String, Object>(config), keyType, valueType);
        return new KafkaProducerImpl<K, V>(stream).registerCloseHook();
    }

    @GenIgnore
    public static <K, V> KafkaProducer<K, V> create(Vertx vertx, Properties config) {
        KafkaWriteStream stream = KafkaWriteStream.create(vertx, config);
        return new KafkaProducerImpl(stream).registerCloseHook();
    }

    @GenIgnore
    public static <K, V> KafkaProducer<K, V> create(Vertx vertx, Properties config, Class<K> keyType, Class<V> valueType) {
        KafkaWriteStream<K, V> stream = KafkaWriteStream.create(vertx, config, keyType, valueType);
        return new KafkaProducerImpl<K, V>(stream).registerCloseHook();
    }

    @Fluent
    public KafkaProducer<K, V> exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public KafkaProducer<K, V> write(KafkaProducerRecord<K, V> var1);

    public void end();

    public void end(KafkaProducerRecord<K, V> var1);

    @Fluent
    public KafkaProducer<K, V> setWriteQueueMaxSize(int var1);

    public boolean writeQueueFull();

    @Fluent
    public KafkaProducer<K, V> drainHandler(Handler<Void> var1);

    @Fluent
    public KafkaProducer<K, V> write(KafkaProducerRecord<K, V> var1, Handler<AsyncResult<RecordMetadata>> var2);

    @Fluent
    public KafkaProducer<K, V> partitionsFor(String var1, Handler<AsyncResult<List<PartitionInfo>>> var2);

    @Fluent
    public KafkaProducer<K, V> flush(Handler<Void> var1);

    public void close();

    public void close(Handler<AsyncResult<Void>> var1);

    public void close(long var1, Handler<AsyncResult<Void>> var3);

    @GenIgnore
    public KafkaWriteStream<K, V> asStream();

    @GenIgnore
    public Producer<K, V> producer();
}

