/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.ssh.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.termd.core.ssh.TtyCommand;
import io.termd.core.ssh.netty.NettyIoServiceFactoryFactory;
import io.termd.core.tty.TtyConnection;
import io.termd.core.util.Helper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;

public class NettySshTtyBootstrap {
    private String host = "localhost";
    private int port = 5000;
    private Charset charset = StandardCharsets.UTF_8;
    private EventLoopGroup parentGroup = new NioEventLoopGroup(1);
    private EventLoopGroup childGroup = new NioEventLoopGroup();
    private SshServer server;
    private KeyPairProvider keyPairProvider = new SimpleGeneratorHostKeyProvider(new File("hostkey.ser").toPath());
    private PasswordAuthenticator passwordAuthenticator = (username, password, session) -> true;

    public String getHost() {
        return this.host;
    }

    public NettySshTtyBootstrap setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public NettySshTtyBootstrap setPort(int port) {
        this.port = port;
        return this;
    }

    public CompletableFuture<Void> start(Consumer<TtyConnection> handler) throws Exception {
        CompletableFuture<Void> fut = new CompletableFuture<Void>();
        this.start(handler, Helper.startedHandler(fut));
        return fut;
    }

    public KeyPairProvider getKeyPairProvider() {
        return this.keyPairProvider;
    }

    public NettySshTtyBootstrap setKeyPairProvider(KeyPairProvider keyPairProvider) {
        this.keyPairProvider = keyPairProvider;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void start(Consumer<TtyConnection> factory, Consumer<Throwable> doneHandler) {
        this.server = SshServer.setUpDefaultServer();
        this.server.setIoServiceFactoryFactory((IoServiceFactoryFactory)new NettyIoServiceFactoryFactory(this.childGroup));
        this.server.setPort(this.port);
        this.server.setHost(this.host);
        this.server.setKeyPairProvider(this.keyPairProvider);
        this.server.setPasswordAuthenticator(this.passwordAuthenticator);
        this.server.setShellFactory(() -> new TtyCommand(this.charset, factory));
        try {
            this.server.start();
        }
        catch (Exception e) {
            doneHandler.accept(e);
            return;
        }
        doneHandler.accept(null);
    }

    public CompletableFuture<Void> stop() throws InterruptedException {
        CompletableFuture<Void> fut = new CompletableFuture<Void>();
        this.stop(Helper.stoppedHandler(fut));
        return fut;
    }

    public void stop(Consumer<Throwable> doneHandler) {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (IOException e) {
                doneHandler.accept(e);
                return;
            }
            doneHandler.accept(null);
        } else {
            doneHandler.accept(new IllegalStateException("Server not started"));
        }
    }
}

