/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLong;
import rx.Notification;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.internal.operators.BackpressureUtils;
import rx.plugins.RxJavaHooks;

public final class OperatorMaterialize<T>
implements Observable.Operator<Notification<T>, T> {
    public static <T> OperatorMaterialize<T> instance() {
        return Holder.INSTANCE;
    }

    OperatorMaterialize() {
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Notification<T>> child) {
        final ParentSubscriber parent = new ParentSubscriber(child);
        child.add(parent);
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                if (n > 0L) {
                    parent.requestMore(n);
                }
            }
        });
        return parent;
    }

    static class ParentSubscriber<T>
    extends Subscriber<T> {
        private final Subscriber<? super Notification<T>> child;
        private volatile Notification<T> terminalNotification;
        private boolean busy;
        private boolean missed;
        private final AtomicLong requested = new AtomicLong();

        ParentSubscriber(Subscriber<? super Notification<T>> child) {
            this.child = child;
        }

        @Override
        public void onStart() {
            this.request(0L);
        }

        void requestMore(long n) {
            BackpressureUtils.getAndAddRequest(this.requested, n);
            this.request(n);
            this.drain();
        }

        @Override
        public void onCompleted() {
            this.terminalNotification = Notification.createOnCompleted();
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.terminalNotification = Notification.createOnError(e);
            RxJavaHooks.onError(e);
            this.drain();
        }

        @Override
        public void onNext(T t) {
            this.child.onNext(Notification.createOnNext(t));
            this.decrementRequested();
        }

        private void decrementRequested() {
            long r;
            AtomicLong localRequested = this.requested;
            do {
                if ((r = localRequested.get()) != Long.MAX_VALUE) continue;
                return;
            } while (!localRequested.compareAndSet(r, r - 1L));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drain() {
            ParentSubscriber parentSubscriber = this;
            synchronized (parentSubscriber) {
                if (this.busy) {
                    this.missed = true;
                    return;
                }
            }
            AtomicLong localRequested = this.requested;
            while (!this.child.isUnsubscribed()) {
                Notification<T> tn = this.terminalNotification;
                if (tn != null && localRequested.get() > 0L) {
                    this.terminalNotification = null;
                    this.child.onNext(tn);
                    if (!this.child.isUnsubscribed()) {
                        this.child.onCompleted();
                    }
                    return;
                }
                ParentSubscriber parentSubscriber2 = this;
                synchronized (parentSubscriber2) {
                    if (!this.missed) {
                        this.busy = false;
                        return;
                    }
                }
            }
        }
    }

    static final class Holder {
        static final OperatorMaterialize<Object> INSTANCE = new OperatorMaterialize();

        Holder() {
        }
    }
}

