/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.graphite;

import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.lang.Nullable;
import io.micrometer.graphite.GraphiteProtocol;
import java.util.concurrent.TimeUnit;

public interface GraphiteConfig
extends DropwizardConfig {
    public static final GraphiteConfig DEFAULT = k -> null;

    @Nullable
    public String get(String var1);

    default public String prefix() {
        return "graphite";
    }

    default public String[] tagsAsPrefix() {
        return new String[0];
    }

    default public TimeUnit rateUnits() {
        String v = this.get(this.prefix() + ".rateUnits");
        return v == null ? TimeUnit.SECONDS : TimeUnit.valueOf(v.toUpperCase());
    }

    default public TimeUnit durationUnits() {
        String v = this.get(this.prefix() + ".durationUnits");
        return v == null ? TimeUnit.MILLISECONDS : TimeUnit.valueOf(v.toUpperCase());
    }

    default public String host() {
        String v = this.get(this.prefix() + ".host");
        return v == null ? "localhost" : v;
    }

    default public int port() {
        String v = this.get(this.prefix() + ".port");
        return v == null ? 2004 : Integer.parseInt(v);
    }

    default public boolean enabled() {
        String v = this.get(this.prefix() + ".enabled");
        return v == null || Boolean.valueOf(v) != false;
    }

    default public GraphiteProtocol protocol() {
        String v = this.get(this.prefix() + ".protocol");
        if (v == null) {
            return GraphiteProtocol.PICKLED;
        }
        for (GraphiteProtocol flavor : GraphiteProtocol.values()) {
            if (!flavor.toString().equalsIgnoreCase(v)) continue;
            return flavor;
        }
        throw new IllegalArgumentException("Unrecognized graphite protocol '" + v + "' (check property " + this.prefix() + ".protocol)");
    }
}

