/*
 * Decompiled with CFR 0.152.
 */
package io.github.jhipster.config.metric;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import io.github.jhipster.config.JHipsterProperties;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"jhipster.metrics.logs.enabled"})
public class JHipsterLoggingMetricsExportConfiguration {
    private final Logger log = LoggerFactory.getLogger(JHipsterLoggingMetricsExportConfiguration.class);
    private final JHipsterProperties jHipsterProperties;

    public JHipsterLoggingMetricsExportConfiguration(JHipsterProperties jHipsterProperties) {
        this.jHipsterProperties = jHipsterProperties;
    }

    @Bean
    public MetricRegistry dropwizardRegistry() {
        return new MetricRegistry();
    }

    @Bean
    public Slf4jReporter consoleReporter(MetricRegistry dropwizardRegistry) {
        this.log.info("Initializing Metrics Log reporting");
        Marker metricsMarker = MarkerFactory.getMarker((String)"metrics");
        Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)dropwizardRegistry).outputTo(LoggerFactory.getLogger((String)"metrics")).markWith(metricsMarker).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        reporter.start(this.jHipsterProperties.getMetrics().getLogs().getReportFrequency(), TimeUnit.SECONDS);
        return reporter;
    }

    @Bean
    public MeterRegistry consoleLoggingRegistry(MetricRegistry dropwizardRegistry) {
        DropwizardConfig dropwizardConfig = new DropwizardConfig(){

            public String prefix() {
                return "console";
            }

            public String get(String key) {
                return null;
            }
        };
        return new DropwizardMeterRegistry(dropwizardConfig, dropwizardRegistry, HierarchicalNameMapper.DEFAULT, Clock.SYSTEM){

            protected Double nullGaugeValue() {
                return null;
            }
        };
    }
}

