/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.IOException;
import java.net.ProtocolException;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.AbstractHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExecutionContext;
import org.apache.http.protocol.HttpRequestRetryHandler;

public class HttpRequestExecutor
extends AbstractHttpProcessor {
    protected static final int WAIT_FOR_CONTINUE_MS = 10000;
    protected final HttpContext defaultContext;
    private HttpParams params = null;
    private HttpRequestRetryHandler retryhandler = null;

    public HttpRequestExecutor(HttpContext parentContext) {
        this.defaultContext = new HttpExecutionContext(parentContext);
    }

    public HttpRequestExecutor() {
        this(null);
    }

    public final HttpContext getContext() {
        return this.defaultContext;
    }

    public final HttpParams getParams() {
        return this.params;
    }

    public final void setParams(HttpParams params) {
        this.params = params;
    }

    public final HttpRequestRetryHandler getRetryHandler() {
        return this.retryhandler;
    }

    public final void setRetryHandler(HttpRequestRetryHandler retryhandler) {
        this.retryhandler = retryhandler;
    }

    protected boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        if ("HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }

    public HttpResponse execute(HttpRequest request, HttpClientConnection conn) throws IOException, HttpException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException("Client connection may not be null");
        }
        this.defaultContext.setAttribute("http.target_host", conn.getTargetHost());
        this.defaultContext.setAttribute("http.connection", conn);
        this.doPrepareRequest(request, this.defaultContext);
        this.defaultContext.setAttribute("http.request", request);
        HttpResponse response = null;
        int execCount = 0;
        while (true) {
            try {
                this.doEstablishConnection(conn, conn.getTargetHost(), request.getParams());
                response = this.doSendRequest(request, conn, this.defaultContext);
                if (response != null) break;
                response = this.doReceiveResponse(request, conn, this.defaultContext);
                break;
            }
            catch (IOException ex) {
                conn.close();
                if (this.retryhandler == null) {
                    throw ex;
                }
                if (!this.retryhandler.retryRequest(ex, execCount, null)) {
                    throw ex;
                }
            }
            catch (HttpException ex) {
                conn.close();
                throw ex;
            }
            catch (RuntimeException ex) {
                conn.close();
                throw ex;
            }
            ++execCount;
        }
        this.doFinishResponse(response, this.defaultContext);
        return response;
    }

    protected void doPrepareRequest(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        request.getParams().setDefaults(this.params);
        this.preprocessRequest(request, context);
    }

    protected void doEstablishConnection(HttpClientConnection conn, HttpHost target, HttpParams params) throws HttpException, IOException {
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target host may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        if (target == null || target.equals(conn.getTargetHost())) {
            if (HttpConnectionParams.isStaleCheckingEnabled(params) && conn.isOpen() && conn.isStale()) {
                conn.close();
            }
            if (!conn.isOpen()) {
                conn.open(params);
            }
        } else {
            if (conn.isOpen()) {
                conn.close();
            }
            conn.setTargetHost(target);
            conn.open(params);
        }
    }

    protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        HttpResponse response = null;
        context.setAttribute("http.request_sent", Boolean.FALSE);
        conn.sendRequestHeader(request);
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityEnclRequest = (HttpEntityEnclosingRequest)request;
            boolean sendentity = true;
            HttpVersion ver = request.getRequestLine().getHttpVersion();
            if (entityEnclRequest.expectContinue() && ver.greaterEquals(HttpVersion.HTTP_1_1)) {
                conn.flush();
                if (conn.isResponseAvailable(10000)) {
                    int status;
                    response = conn.receiveResponseHeader(request.getParams());
                    if (this.canResponseHaveBody(request, response)) {
                        conn.receiveResponseEntity(response);
                    }
                    if ((status = response.getStatusLine().getStatusCode()) < 200) {
                        if (status != 100) {
                            throw new ProtocolException("Unexpected response: " + response.getStatusLine());
                        }
                        response = null;
                    } else {
                        sendentity = false;
                    }
                }
            }
            if (sendentity) {
                conn.sendRequestEntity(entityEnclRequest);
            }
        }
        conn.flush();
        context.setAttribute("http.request_sent", Boolean.TRUE);
        return response;
    }

    protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        HttpResponse response = null;
        int statuscode = 0;
        while (response == null || statuscode < 200) {
            response = conn.receiveResponseHeader(request.getParams());
            if (this.canResponseHaveBody(request, response)) {
                conn.receiveResponseEntity(response);
            }
            statuscode = response.getStatusLine().getStatusCode();
        }
        return response;
    }

    protected void doFinishResponse(HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        this.postprocessResponse(response, context);
    }
}

