/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyRuntimeException;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.ClassCompletionVerifier;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.classgen.JSRVariableScopeCodeVisitor;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.InputStreamReaderSource;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.tools.GroovyClass;

public class CompilationUnit
extends ProcessingUnit {
    protected HashMap sources;
    protected ArrayList names;
    protected CompileUnit ast;
    protected ArrayList classes;
    protected Verifier verifier;
    protected ClassCompletionVerifier completionVerifier;
    protected boolean debug;
    protected boolean configured;
    protected ClassgenCallback classgenCallback;
    protected ProgressCallback progressCallback;
    private LoopBodyForSourceUnitOperations parse = new LoopBodyForSourceUnitOperations(){

        public void call(SourceUnit source) throws CompilationFailedException {
            source.parse();
            if (CompilationUnit.this.progressCallback != null) {
                CompilationUnit.this.progressCallback.call(source, CompilationUnit.this.phase);
            }
        }
    };
    private LoopBodyForSourceUnitOperations convert = new LoopBodyForSourceUnitOperations(){

        public void call(SourceUnit source) throws CompilationFailedException {
            source.convert();
            CompilationUnit.this.ast.addModule(source.getAST());
            if (CompilationUnit.this.progressCallback != null) {
                CompilationUnit.this.progressCallback.call(source, CompilationUnit.this.phase);
            }
        }
    };
    private LoopBodyForPrimaryClassNodeOperations classgen = new LoopBodyForPrimaryClassNodeOperations(){

        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
            try {
                CompilationUnit.this.verifier.visitClass(classNode);
            }
            catch (GroovyRuntimeException rpe) {
                ASTNode node = rpe.getNode();
                CompilationUnit.this.getErrorCollector().addError(new SyntaxException(rpe.getMessage(), null, node.getLineNumber(), node.getColumnNumber()), source);
            }
            if (source != null && !classNode.isSynthetic() && !"false".equals(System.getProperty("groovy.jsr.check"))) {
                JSRVariableScopeCodeVisitor scopeVisitor = new JSRVariableScopeCodeVisitor(null, source);
                scopeVisitor.visitClass(classNode);
                source.getErrorCollector().failIfErrors();
            }
            ClassVisitor visitor = CompilationUnit.this.createClassVisitor();
            String sourceName = source == null ? classNode.getModule().getDescription() : source.getName();
            AsmClassGenerator generator = new AsmClassGenerator(context, visitor, CompilationUnit.this.classLoader, sourceName);
            generator.visitClass(classNode);
            CompilationUnit.this.completionVerifier.visitClass(classNode);
            if (!CompilationUnit.this.debug) {
                byte[] bytes = ((ClassWriter)visitor).toByteArray();
                CompilationUnit.this.classes.add(new GroovyClass(classNode.getName(), bytes));
            }
            if (CompilationUnit.this.classgenCallback != null) {
                CompilationUnit.this.classgenCallback.call(visitor, classNode);
            }
            LinkedList innerClasses = generator.getInnerClasses();
            while (!innerClasses.isEmpty()) {
                CompilationUnit.this.classgen.call(source, context, (ClassNode)innerClasses.removeFirst());
            }
        }
    };
    private LoopBodyForSourceUnitOperations mark = new LoopBodyForSourceUnitOperations(){

        public void call(SourceUnit source) throws CompilationFailedException {
            if (source.phase < CompilationUnit.this.phase) {
                source.gotoPhase(CompilationUnit.this.phase);
            }
            if (source.phase == CompilationUnit.this.phase && CompilationUnit.this.phaseComplete && !source.phaseComplete) {
                source.completePhase();
            }
        }
    };

    public CompilationUnit() {
        this((CompilerConfiguration)null, (CodeSource)null, (ClassLoader)null);
    }

    public CompilationUnit(ClassLoader loader) {
        this(null, null, loader);
    }

    public CompilationUnit(CompilerConfiguration configuration) {
        this(configuration, (CodeSource)null, (ClassLoader)null);
    }

    public CompilationUnit(CompilerConfiguration configuration, CodeSource security, ClassLoader loader) {
        super(configuration, loader, null);
        this.names = new ArrayList();
        this.sources = new HashMap();
        this.ast = new CompileUnit(this.classLoader, security, this.configuration);
        this.classes = new ArrayList();
        this.verifier = new Verifier();
        this.completionVerifier = new ClassCompletionVerifier();
        this.classgenCallback = null;
    }

    public void configure(CompilerConfiguration configuration) {
        super.configure(configuration);
        this.debug = configuration.getDebug();
        if (!this.configured && this.classLoader instanceof GroovyClassLoader) {
            this.appendCompilerConfigurationClasspathToClassLoader(configuration, (GroovyClassLoader)this.classLoader);
        }
        this.configured = true;
    }

    private void appendCompilerConfigurationClasspathToClassLoader(CompilerConfiguration configuration, GroovyClassLoader classLoader) {
        Iterator iterator = configuration.getClasspath().iterator();
        while (iterator.hasNext()) {
            classLoader.addClasspath((String)iterator.next());
        }
    }

    public CompileUnit getAST() {
        return this.ast;
    }

    public List getClasses() {
        return this.classes;
    }

    public ClassNode getFirstClassNode() {
        return (ClassNode)((ModuleNode)this.ast.getModules().get(0)).getClasses().get(0);
    }

    public ClassNode getClassNode(final String name) {
        ClassNode[] result;
        block2: {
            result = new ClassNode[]{null};
            LoopBodyForPrimaryClassNodeOperations handler = new LoopBodyForPrimaryClassNodeOperations(){

                public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) {
                    if (classNode.getName().equals(name)) {
                        result[0] = classNode;
                    }
                }
            };
            try {
                this.applyToPrimaryClassNodes(handler);
            }
            catch (CompilationFailedException e) {
                if (!this.debug) break block2;
                e.printStackTrace();
            }
        }
        return result[0];
    }

    public void addSources(String[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            File file = new File(paths[i]);
            this.addSource(file);
        }
    }

    public void addSources(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.addSource(files[i]);
        }
    }

    public SourceUnit addSource(File file) {
        return this.addSource(new SourceUnit(file, this.configuration, this.classLoader, this.getErrorCollector()));
    }

    public SourceUnit addSource(URL url) {
        return this.addSource(new SourceUnit(url, this.configuration, this.classLoader, this.getErrorCollector()));
    }

    public SourceUnit addSource(String name, InputStream stream) {
        InputStreamReaderSource source = new InputStreamReaderSource(stream, this.configuration);
        return this.addSource(new SourceUnit(name, source, this.configuration, this.classLoader, this.getErrorCollector()));
    }

    public SourceUnit addSource(SourceUnit source) {
        String name = source.getName();
        source.setClassLoader(this.classLoader);
        this.names.add(name);
        this.sources.put(name, source);
        return source;
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator nameIterator;
            {
                this.nameIterator = CompilationUnit.this.names.iterator();
            }

            public boolean hasNext() {
                return this.nameIterator.hasNext();
            }

            public Object next() {
                String name = (String)this.nameIterator.next();
                return CompilationUnit.this.sources.get(name);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void addClassNode(ClassNode node) {
        ModuleNode module = new ModuleNode(this.ast);
        this.ast.addModule(module);
        module.addClass(node);
    }

    public void setClassgenCallback(ClassgenCallback visitor) {
        this.classgenCallback = visitor;
    }

    public void setProgressCallback(ProgressCallback callback) {
        this.progressCallback = callback;
    }

    public void compile() throws CompilationFailedException {
        this.compile(9);
    }

    public void compile(int throughPhase) throws CompilationFailedException {
        this.gotoPhase(1);
        if (throughPhase >= 2) {
            this.gotoPhase(2);
            this.parse();
            if (throughPhase >= 3) {
                this.gotoPhase(3);
                this.convert();
                if (throughPhase >= 7) {
                    this.gotoPhase(7);
                    this.classgen();
                    if (throughPhase >= 8) {
                        this.gotoPhase(8);
                        this.output();
                        if (throughPhase >= 9) {
                            this.gotoPhase(9);
                        }
                    }
                }
            }
        }
    }

    public void parse() throws CompilationFailedException {
        if (this.phase != 2) {
            throw new GroovyBugError("CompilationUnit not read for parse()");
        }
        this.applyToSourceUnits(this.parse);
        this.completePhase();
        this.applyToSourceUnits(this.mark);
    }

    public void convert() throws CompilationFailedException {
        if (this.phase != 3) {
            throw new GroovyBugError("CompilationUnit not ready for convert()");
        }
        this.applyToSourceUnits(this.convert);
        this.completePhase();
        this.applyToSourceUnits(this.mark);
    }

    public void classgen() throws CompilationFailedException {
        if (this.phase != 7) {
            throw new GroovyBugError("CompilationUnit not ready for classgen()");
        }
        this.applyToPrimaryClassNodes(this.classgen);
        this.completePhase();
        this.applyToSourceUnits(this.mark);
        if (this.progressCallback != null) {
            this.progressCallback.call(this, this.phase);
        }
    }

    protected ClassVisitor createClassVisitor() {
        return new ClassWriter(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void output() throws CompilationFailedException {
        if (!(this.phase == 8 || this.phase == 7 && this.phaseComplete)) {
            throw new GroovyBugError("CompilationUnit not ready for output()");
        }
        boolean failures = false;
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            GroovyClass gclass = (GroovyClass)iterator.next();
            String name = gclass.getName().replace('.', File.separatorChar) + ".class";
            File path = new File(this.configuration.getTargetDirectory(), name);
            File directory = path.getParentFile();
            if (directory != null && !directory.exists()) {
                directory.mkdirs();
            }
            byte[] bytes = gclass.getBytes();
            FileOutputStream stream = null;
            stream = new FileOutputStream(path);
            stream.write(bytes, 0, bytes.length);
            Object var11_10 = null;
            if (stream == null) continue;
            try {
                stream.close();
            }
            catch (Exception e2) {}
            continue;
            {
                catch (IOException e) {
                    this.getErrorCollector().addError(Message.create(e.getMessage(), this));
                    failures = true;
                    var11_10 = null;
                    if (stream == null) continue;
                    try {
                        stream.close();
                    }
                    catch (Exception e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_10 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        this.getErrorCollector().failIfErrors();
        this.completePhase();
        this.applyToSourceUnits(this.mark);
        if (this.progressCallback != null) {
            this.progressCallback.call(this, this.phase);
        }
    }

    protected void mark() throws CompilationFailedException {
        this.applyToSourceUnits(this.mark);
    }

    public void applyToSourceUnits(LoopBodyForSourceUnitOperations body) throws CompilationFailedException {
        boolean failures = false;
        Iterator keys = this.names.iterator();
        while (keys.hasNext()) {
            String name = (String)keys.next();
            SourceUnit source = (SourceUnit)this.sources.get(name);
            if (source.phase > this.phase) continue;
            try {
                body.call(source);
            }
            catch (CompilationFailedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new GroovyBugError(e);
            }
        }
        this.getErrorCollector().failIfErrors();
    }

    public void applyToPrimaryClassNodes(LoopBodyForPrimaryClassNodeOperations body) throws CompilationFailedException {
        boolean failures = false;
        Iterator modules = this.ast.getModules().iterator();
        while (modules.hasNext()) {
            ModuleNode module = (ModuleNode)modules.next();
            try {
                Iterator classNodes = module.getClasses().iterator();
                while (classNodes.hasNext()) {
                    ClassNode classNode = (ClassNode)classNodes.next();
                    SourceUnit context = module.getContext();
                    if (context != null && context.phase > this.phase) continue;
                    body.call(module.getContext(), new GeneratorContext(this.ast), classNode);
                }
            }
            catch (CompilationFailedException e) {
            }
            catch (Exception e) {
                failures = true;
                ErrorCollector nestedCollector = null;
                for (Throwable next = e.getCause(); next != e && next != null; next = next.getCause()) {
                    if (!(next instanceof MultipleCompilationErrorsException)) continue;
                    MultipleCompilationErrorsException mcee = (MultipleCompilationErrorsException)next;
                    nestedCollector = mcee.collector;
                    break;
                }
                if (nestedCollector != null) {
                    this.getErrorCollector().addCollectorContents(nestedCollector);
                    continue;
                }
                this.getErrorCollector().addError(new ExceptionMessage(e, this.configuration.getDebug(), this));
            }
        }
        this.getErrorCollector().failIfErrors();
    }

    public abstract class LoopBodyForPrimaryClassNodeOperations {
        public abstract void call(SourceUnit var1, GeneratorContext var2, ClassNode var3) throws CompilationFailedException;
    }

    public abstract class LoopBodyForSourceUnitOperations {
        public abstract void call(SourceUnit var1) throws CompilationFailedException;
    }

    public static abstract class ProgressCallback {
        public abstract void call(ProcessingUnit var1, int var2) throws CompilationFailedException;
    }

    public static abstract class ClassgenCallback {
        public abstract void call(ClassVisitor var1, ClassNode var2) throws CompilationFailedException;
    }
}

