/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public class JSRVariableScopeCodeVisitor
extends CodeVisitorSupport
implements GroovyClassVisitor {
    private VarScope currentScope = null;
    private CompileUnit unit;
    private SourceUnit source;
    private boolean scriptMode = false;
    private ClassNode currentClass = null;
    private boolean jroseRule = false;

    public JSRVariableScopeCodeVisitor(VarScope scope, SourceUnit source) {
        if ("true".equals(System.getProperty("groovy.jsr.check.rule.jrose"))) {
            this.jroseRule = true;
        }
        this.currentScope = scope;
        this.source = source;
        if (source.getAST() == null) {
            return;
        }
        this.unit = source.getAST().getUnit();
    }

    public void visitBlockStatement(BlockStatement block) {
        VarScope scope = this.currentScope;
        this.currentScope = new VarScope(this.currentScope);
        super.visitBlockStatement(block);
        this.currentScope = scope;
    }

    public void visitForLoop(ForStatement forLoop) {
        VarScope scope = this.currentScope;
        this.currentScope = new VarScope(this.currentScope);
        this.declare(new Var(forLoop.getVariable()), forLoop);
        super.visitForLoop(forLoop);
        this.currentScope = scope;
    }

    public void visitWhileLoop(WhileStatement loop) {
        VarScope scope = this.currentScope;
        this.currentScope = new VarScope(this.currentScope);
        super.visitWhileLoop(loop);
        this.currentScope = scope;
    }

    public void visitDoWhileLoop(DoWhileStatement loop) {
        VarScope scope = this.currentScope;
        this.currentScope = new VarScope(this.currentScope);
        super.visitDoWhileLoop(loop);
        this.currentScope = scope;
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        expression.getRightExpression().visit(this);
        VariableExpression vex = expression.getVariableExpression();
        if (!this.jroseRule && "it".equals(vex.getVariable())) {
            this.addError("'it' is a keyword in this mode.", vex);
        } else {
            this.declare(vex);
        }
    }

    private void addError(String msg, ASTNode expr) {
        int line = expr.getLineNumber();
        int col = expr.getColumnNumber();
        this.source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', line, col), this.source));
    }

    private void declare(VariableExpression expr) {
        this.declare(new Var(expr, this.currentScope), expr);
    }

    private void declare(Var var, ASTNode expr) {
        String scopeType = "scope";
        String variableType = "variable";
        if (expr.getClass() == FieldNode.class) {
            scopeType = "class";
            variableType = "field";
        } else if (expr.getClass() == PropertyNode.class) {
            scopeType = "class";
            variableType = "property";
        }
        StringBuffer msg = new StringBuffer();
        msg.append("The current ").append(scopeType);
        msg.append(" does already contain a ").append(variableType);
        msg.append(" of the name ").append(var.name);
        if (this.currentScope.declares.get(var.name) != null) {
            this.addError(msg.toString(), expr);
            return;
        }
        if (this.currentScope.isClass) {
            this.currentScope.declares.put(var.name, var);
        }
        VarScope scope = this.currentScope.parent;
        while (scope != null) {
            HashMap declares = scope.declares;
            if (scope.isClass) break;
            if (declares.get(var.name) != null) {
                this.addError(msg.toString(), expr);
                break;
            }
            scope = scope.parent;
        }
        this.currentScope.declares.put(var.name, var);
        var.isInStaticContext = this.currentScope.isInStaticContext;
    }

    public void visitVariableExpression(VariableExpression expression) {
        String name = expression.getVariable();
        Var v = this.checkVariableNameForDeclaration(name, expression);
        if (v == null) {
            return;
        }
        this.checkVariableContextAccess(v, expression);
    }

    public void visitFieldExpression(FieldExpression expression) {
        String name = expression.getFieldName();
        Var v = this.checkVariableNameForDeclaration(name, expression);
        this.checkVariableContextAccess(v, expression);
    }

    private void checkAbstractDeclaration(MethodNode methodNode) {
        if (!Modifier.isAbstract(methodNode.getModifiers())) {
            return;
        }
        if (Modifier.isAbstract(this.currentClass.getModifiers())) {
            return;
        }
        this.addError("Can't have an abstract method in a non abstract class. The class '" + this.currentClass.getName() + "' must be declared abstract or the method '" + methodNode.getName() + "' must not be abstract.", methodNode);
    }

    private String getTypeName(String name) {
        if (!name.endsWith("[]")) {
            return name;
        }
        String prefix = "";
        while (name.endsWith("[]")) {
            name = name.substring(0, name.length() - 2);
            prefix = "[";
        }
        if (name.equals("int")) {
            return prefix + "I";
        }
        if (name.equals("long")) {
            return prefix + "J";
        }
        if (name.equals("short")) {
            return prefix + "S";
        }
        if (name.equals("float")) {
            return prefix + "F";
        }
        if (name.equals("double")) {
            return prefix + "D";
        }
        if (name.equals("byte")) {
            return prefix + "B";
        }
        if (name.equals("char")) {
            return prefix + "C";
        }
        if (name.equals("boolean")) {
            return prefix + "Z";
        }
        return prefix + "L" + name + ";";
    }

    private boolean hasEqualParameterTypes(Parameter[] first, Parameter[] second) {
        if (first.length != second.length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            String st;
            String ft = this.getTypeName(first[i].getType());
            if (ft.equals(st = this.getTypeName(second[i].getType()))) continue;
            return false;
        }
        return true;
    }

    private void checkImplementsAndExtends(ClassNode node) {
        ClassNode cn = node.getSuperClassNode();
        if (cn.isInterface()) {
            this.addError("you are not allowed to extend the Interface " + cn.getName() + ", use implements instead", node);
        }
        String[] interfaces = node.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            cn = node.findClassNode(interfaces[i]);
            if (cn.isInterface()) continue;
            this.addError("you are not allowed to implement the Class " + cn.getName() + ", use extends instead", node);
        }
    }

    private void checkClassForOverwritingFinal(ClassNode cn) {
        ClassNode superCN = cn.getSuperClassNode();
        if (superCN == null) {
            return;
        }
        if (!Modifier.isFinal(superCN.getModifiers())) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("you are not allowed to overwrite the final class ");
        msg.append(superCN.getName());
        msg.append(".");
        this.addError(msg.toString(), cn);
    }

    private void checkMethodsForOverwritingFinal(ClassNode cn) {
        List l = cn.getMethods();
        Iterator cnIter = l.iterator();
        while (cnIter.hasNext()) {
            MethodNode method = (MethodNode)cnIter.next();
            Parameter[] parameters = method.getParameters();
            for (ClassNode superCN = cn.getSuperClassNode(); superCN != null; superCN = superCN.getSuperClassNode()) {
                List methods = superCN.getMethods(method.getName());
                Iterator iter = methods.iterator();
                while (iter.hasNext()) {
                    MethodNode m = (MethodNode)iter.next();
                    Parameter[] np = m.getParameters();
                    if (!this.hasEqualParameterTypes(parameters, np)) continue;
                    if (!Modifier.isFinal(m.getModifiers())) {
                        return;
                    }
                    StringBuffer msg = new StringBuffer();
                    msg.append("you are not allowed to overwrite the final method ").append(method.getName());
                    msg.append("(");
                    boolean semi = false;
                    for (int i = 0; i < parameters.length; ++i) {
                        if (semi) {
                            msg.append(",");
                        } else {
                            semi = true;
                        }
                        msg.append(parameters[i].getType());
                    }
                    msg.append(")");
                    msg.append(" from class ").append(superCN.getName());
                    msg.append(".");
                    this.addError(msg.toString(), method);
                    return;
                }
            }
        }
    }

    private void checkVariableContextAccess(Var v, Expression expr) {
        if (v.isInStaticContext || !this.currentScope.isInStaticContext) {
            return;
        }
        String msg = v.name + " is declared in a dynamic context, but you tried to" + " access it from a static context.";
        this.addError(msg, expr);
        Var v2 = new Var(v);
        v2.isInStaticContext = true;
        this.currentScope.declares.put(v2.name, v2);
    }

    private Var checkVariableNameForDeclaration(VariableExpression expression) {
        if (expression == VariableExpression.THIS_EXPRESSION) {
            return null;
        }
        String name = expression.getVariable();
        return this.checkVariableNameForDeclaration(name, expression);
    }

    private Var checkVariableNameForDeclaration(String name, Expression expression) {
        Var var;
        block6: {
            VarScope end;
            VarScope scope;
            block5: {
                var = new Var(name);
                if ("super".equals(var.name) || "this".equals(var.name)) {
                    return null;
                }
                scope = this.currentScope;
                while (scope != null) {
                    if (scope.declares.get(var.name) != null) {
                        var = (Var)scope.declares.get(var.name);
                        break;
                    }
                    if (scope.visibles.get(var.name) != null) {
                        var = (Var)scope.visibles.get(var.name);
                        break;
                    }
                    scope = scope.parent;
                }
                end = scope;
                if (scope != null) break block5;
                ClassNode vn = this.unit.getClass(var.name);
                if (vn != null) break block6;
                this.declare(var, expression);
                if (this.scriptMode) break block6;
                this.addError("The variable " + var.name + " is undefined in the current scope", expression);
                break block6;
            }
            scope = this.currentScope;
            while (scope != end) {
                scope.visibles.put(var.name, var);
                scope = scope.parent;
            }
        }
        return var;
    }

    public void visitClosureExpression(ClosureExpression expression) {
        VarScope scope = this.currentScope;
        this.currentScope = new VarScope(false, this.currentScope, scope.isInStaticContext);
        if (expression.isParameterSpecified()) {
            Parameter[] parameters = expression.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                this.declare(new Var(parameters[i], scope.isInStaticContext), expression);
            }
        } else {
            Var var = new Var("it");
            var.isInStaticContext = scope.isInStaticContext;
            if (this.jroseRule) {
                JRoseCheck check = new JRoseCheck();
                expression.visit(check);
                if (check.itUsed) {
                    this.declare(var, expression);
                }
            } else {
                this.currentScope.declares.put("it", var);
            }
        }
        super.visitClosureExpression(expression);
        this.currentScope = scope;
    }

    public void visitClass(ClassNode node) {
        this.checkImplementsAndExtends(node);
        this.checkClassForOverwritingFinal(node);
        this.checkMethodsForOverwritingFinal(node);
        VarScope scope = this.currentScope;
        this.currentScope = new VarScope(true, this.currentScope, false);
        boolean scriptModeBackup = this.scriptMode;
        this.scriptMode = node.isScript();
        ClassNode classBackup = this.currentClass;
        this.currentClass = node;
        HashMap declares = this.currentScope.declares;
        try {
            this.addVarNames(node);
            this.addVarNames(node.getOuterClass(), this.currentScope.visibles, true);
            this.addVarNames(node.getSuperClass(), this.currentScope.visibles, true);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        node.visitContents(this);
        this.currentClass = classBackup;
        this.currentScope = scope;
        this.scriptMode = scriptModeBackup;
    }

    private void addVarNames(Class c, HashMap refs, boolean visitParent) throws ClassNotFoundException {
        if (c == null) {
            return;
        }
        this.addVarNames(c.getName(), refs, visitParent);
    }

    private void addVarNames(ClassNode cn) {
        if (cn == null) {
            return;
        }
        List l = cn.getFields();
        HashSet<Var> fields = new HashSet<Var>();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            FieldNode f = (FieldNode)iter.next();
            Var var = new Var(f);
            if (fields.contains(var)) {
                this.declare(var, f);
                continue;
            }
            fields.add(var);
            this.currentScope.declares.put(var.name, var);
        }
        l = cn.getMethods();
        HashSet setter = new HashSet();
        HashSet getter = new HashSet();
        Iterator iter2 = l.iterator();
        while (iter2.hasNext()) {
            MethodNode f = (MethodNode)iter2.next();
            String methodName = f.getName();
            String pName = this.getPropertyName(methodName);
            if (pName == null) continue;
            Var var = new Var(pName, f);
            this.currentScope.declares.put(var.name, var);
        }
        l = cn.getProperties();
        HashSet<Var> props = new HashSet<Var>();
        Iterator iter3 = l.iterator();
        while (iter3.hasNext()) {
            PropertyNode f = (PropertyNode)iter3.next();
            Var var = new Var(f);
            if (props.contains(var)) {
                this.declare(var, f);
                continue;
            }
            props.add(var);
            this.currentScope.declares.put(var.name, var);
        }
    }

    private void addVarNames(ClassNode cn, HashMap refs, boolean visitParent) throws ClassNotFoundException {
        AnnotatedNode f;
        if (cn == null) {
            return;
        }
        List l = cn.getFields();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            f = (FieldNode)iter.next();
            if (visitParent && Modifier.isPrivate(((FieldNode)f).getModifiers())) continue;
            refs.put(((FieldNode)f).getName(), new Var((FieldNode)f));
        }
        l = cn.getMethods();
        iter = l.iterator();
        while (iter.hasNext()) {
            String name;
            f = (MethodNode)iter.next();
            if (visitParent && Modifier.isPrivate(((MethodNode)f).getModifiers()) || (name = this.getPropertyName(((MethodNode)f).getName())) == null) continue;
            refs.put(name, new Var(name, (MethodNode)f));
        }
        l = cn.getProperties();
        iter = l.iterator();
        while (iter.hasNext()) {
            f = (PropertyNode)iter.next();
            if (visitParent && Modifier.isPrivate(((PropertyNode)f).getModifiers())) continue;
            refs.put(((PropertyNode)f).getName(), new Var((PropertyNode)f));
        }
        if (!visitParent) {
            return;
        }
        this.addVarNames(cn.getSuperClass(), refs, visitParent);
        MethodNode enclosingMethod = cn.getEnclosingMethod();
        if (enclosingMethod == null) {
            return;
        }
        Parameter[] params = enclosingMethod.getParameters();
        for (int i = 0; i < params.length; ++i) {
            refs.put(params[i].getName(), new Var(params[i], enclosingMethod.isStatic()));
        }
        if (visitParent) {
            this.addVarNames(enclosingMethod.getDeclaringClass(), refs, visitParent);
        }
        this.addVarNames(cn.getOuterClass(), refs, visitParent);
    }

    private void addVarNames(String superclassName, HashMap refs, boolean visitParent) throws ClassNotFoundException {
        if (superclassName == null) {
            return;
        }
        ClassNode cn = this.unit.getClass(superclassName);
        if (cn != null) {
            this.addVarNames(cn, refs, visitParent);
            return;
        }
        Class<?> c = this.unit.getClassLoader().loadClass(superclassName);
        Field[] fields = c.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (visitParent && Modifier.isPrivate(f.getModifiers())) continue;
            refs.put(f.getName(), new Var(f));
        }
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name;
            Method m = methods[i];
            if (visitParent && Modifier.isPrivate(m.getModifiers()) || (name = this.getPropertyName(m.getName())) == null) continue;
            refs.put(name, new Var(name, m));
        }
        if (!visitParent) {
            return;
        }
        this.addVarNames(c.getSuperclass(), refs, visitParent);
    }

    private String getPropertyName(String name) {
        if (!name.startsWith("set") && !name.startsWith("get")) {
            return null;
        }
        String pname = name.substring(3);
        if (pname.length() == 0) {
            return null;
        }
        String s = pname.substring(0, 1).toLowerCase();
        String rest = pname.substring(1);
        return s + rest;
    }

    public void visitConstructor(ConstructorNode node) {
        VarScope scope = this.currentScope;
        this.currentScope = new VarScope(this.currentScope);
        HashMap declares = this.currentScope.declares;
        Parameter[] parameters = node.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            this.declare(new Var(parameters[i], false), node);
        }
        this.currentScope = new VarScope(this.currentScope);
        Statement code = node.getCode();
        if (code != null) {
            code.visit(this);
        }
        this.currentScope = scope;
    }

    public void visitMethod(MethodNode node) {
        this.checkAbstractDeclaration(node);
        VarScope scope = this.currentScope;
        this.currentScope = new VarScope(this.currentScope, node.isStatic());
        HashMap declares = this.currentScope.declares;
        Parameter[] parameters = node.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            declares.put(parameters[i].getName(), new Var(parameters[i], node.isStatic()));
        }
        this.currentScope = new VarScope(this.currentScope);
        Statement code = node.getCode();
        if (code != null) {
            code.visit(this);
        }
        this.currentScope = scope;
    }

    public void visitField(FieldNode node) {
        Expression init = node.getInitialValueExpression();
        if (init != null) {
            init.visit(this);
        }
    }

    public void visitProperty(PropertyNode node) {
        Expression init;
        Statement statement = node.getGetterBlock();
        if (statement != null) {
            statement.visit(this);
        }
        if ((statement = node.getSetterBlock()) != null) {
            statement.visit(this);
        }
        if ((init = node.getInitialValueExpression()) != null) {
            init.visit(this);
        }
    }

    public void visitPropertyExpression(PropertyExpression expression) {
    }

    public void visitCatchStatement(CatchStatement statement) {
        VarScope scope = this.currentScope;
        this.currentScope = new VarScope(this.currentScope);
        this.declare(new Var(statement.getVariable()), statement);
        super.visitCatchStatement(statement);
        this.currentScope = scope;
    }

    private static class JRoseCheck
    extends CodeVisitorSupport {
        boolean closureStarted = false;
        boolean itUsed = false;

        private JRoseCheck() {
        }

        public void visitClosureExpression(ClosureExpression expression) {
            if (this.closureStarted) {
                return;
            }
            this.closureStarted = true;
            Parameter[] param = expression.getParameters();
            for (int i = 0; i < param.length; ++i) {
                this.itUsed = param[i].getName().equals("it") && this.closureStarted || this.itUsed;
            }
            super.visitClosureExpression(expression);
        }

        public void visitVariableExpression(VariableExpression expression) {
            this.itUsed = expression.getVariable().equals("it") && this.closureStarted || this.itUsed;
        }
    }

    private static class VarScope {
        boolean isClass = true;
        boolean isInStaticContext = false;
        VarScope parent;
        HashMap declares = new HashMap();
        HashMap visibles = new HashMap();

        public VarScope(boolean isClass, VarScope parent, boolean staticContext) {
            this.isClass = isClass;
            this.parent = parent;
            this.isInStaticContext = staticContext;
        }

        public VarScope(VarScope parent, boolean staticContext) {
            this(false, parent, staticContext);
        }

        public VarScope(VarScope parent) {
            this(false, parent, parent != null ? parent.isInStaticContext : false);
        }
    }

    private static class Var {
        boolean isStatic = false;
        boolean isFinal = false;
        boolean isDynamicTyped = false;
        String name;
        String type = null;
        Class typeClass = null;
        boolean isInStaticContext = false;

        public boolean equals(Object o) {
            Var v = (Var)o;
            return v.name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public Var(String name) {
            this.name = name;
        }

        public Var(VariableExpression ve, VarScope scope) {
            this.name = ve.getVariable();
            if (ve.isDynamic()) {
                this.isDynamicTyped = true;
            } else {
                this.type = ve.getType();
                this.typeClass = ve.getTypeClass();
            }
            this.isInStaticContext = scope.isInStaticContext;
        }

        public Var(Parameter par, boolean staticContext) {
            this.name = par.getName();
            if (par.isDynamicType()) {
                this.isDynamicTyped = true;
            } else {
                this.type = par.getType();
            }
            this.isInStaticContext = staticContext;
        }

        public Var(FieldNode f) {
            this.name = f.getName();
            if (f.isDynamicType()) {
                this.isDynamicTyped = true;
            } else {
                this.type = f.getType();
            }
            this.isInStaticContext = this.isStatic = f.isStatic();
        }

        public Var(String pName, MethodNode f) {
            this.name = pName;
            if (f.isDynamicReturnType()) {
                this.isDynamicTyped = true;
            } else {
                this.type = f.getReturnType();
            }
            this.isInStaticContext = this.isStatic = f.isStatic();
        }

        public Var(String pName, Method m) {
            this.name = pName;
            this.typeClass = m.getReturnType();
            this.isStatic = Modifier.isStatic(m.getModifiers());
            this.isFinal = Modifier.isFinal(m.getModifiers());
            this.isInStaticContext = this.isStatic;
        }

        public Var(PropertyNode f) {
            this.isInStaticContext = false;
            this.name = f.getName();
            if (f.isDynamicType()) {
                this.isDynamicTyped = true;
            } else {
                this.type = f.getType();
            }
            this.isInStaticContext = false;
        }

        public Var(Field f) {
            this.name = f.getName();
            this.typeClass = f.getType();
            this.isInStaticContext = this.isStatic = Modifier.isStatic(f.getModifiers());
            this.isFinal = Modifier.isFinal(f.getModifiers());
            this.isInStaticContext = this.isStatic;
        }

        public Var(Var v) {
            this.isStatic = v.isStatic;
            this.isFinal = v.isFinal;
            this.isDynamicTyped = v.isDynamicTyped;
            this.name = v.name;
            this.type = v.type;
            this.typeClass = v.typeClass;
            this.isInStaticContext = v.isInStaticContext;
        }
    }
}

