/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovyjarjarasm.asm.Opcodes;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.Statement;

public class PropertyNode
extends AnnotatedNode
implements Opcodes {
    private FieldNode field;
    private Statement getterBlock;
    private Statement setterBlock;
    private int modifiers;

    public PropertyNode(String name, int modifiers, String type, String owner, Expression initialValueExpression, Statement getterBlock, Statement setterBlock) {
        this(new FieldNode(name, modifiers & 8, type, owner, initialValueExpression), modifiers, getterBlock, setterBlock);
    }

    public PropertyNode(FieldNode field, int modifiers, Statement getterBlock, Statement setterBlock) {
        this.field = field;
        this.modifiers = modifiers;
        this.getterBlock = getterBlock;
        this.setterBlock = setterBlock;
    }

    public Statement getGetterBlock() {
        return this.getterBlock;
    }

    public Expression getInitialValueExpression() {
        return this.field.getInitialValueExpression();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.field.getName();
    }

    public Statement getSetterBlock() {
        return this.setterBlock;
    }

    public String getType() {
        return this.field.getType();
    }

    public boolean isDynamicType() {
        return this.field.isDynamicType();
    }

    public FieldNode getField() {
        return this.field;
    }

    public boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }
}

