/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockDataflow;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MethodGen;

public class FindTwoLockWait
implements Detector,
StatelessDetector {
    private BugReporter bugReporter;
    private JavaClass javaClass;
    private Collection<BugInstance> possibleWaitBugs = new LinkedList<BugInstance>();
    private Collection<SourceLineAnnotation> possibleNotifyLocations = new LinkedList<SourceLineAnnotation>();

    public FindTwoLockWait(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        this.javaClass = classContext.getJavaClass();
        this.possibleWaitBugs.clear();
        this.possibleNotifyLocations.clear();
        Method[] arr$ = methodList = this.javaClass.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null || !this.preScreen(methodGen)) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (DataflowAnalysisException e) {
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error analyzing " + method.toString(), (Throwable)e);
            }
        }
        if (!this.possibleNotifyLocations.isEmpty()) {
            Iterator<BugInstance> i$ = this.possibleWaitBugs.iterator();
            while (i$.hasNext()) {
                BugInstance bug = i$.next();
                Iterator<SourceLineAnnotation> i$2 = this.possibleNotifyLocations.iterator();
                while (i$2.hasNext()) {
                    SourceLineAnnotation notifyLine = i$2.next();
                    bug.addSourceLine(notifyLine).describe("SOURCE_NOTIFICATION_DEADLOCK");
                }
                this.bugReporter.reportBug(bug);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(method);
        CFG cfg = classContext.getCFG(method);
        LockDataflow dataflow = classContext.getLockDataflow(method);
        Iterator j = cfg.locationIterator();
        while (j.hasNext()) {
            Location location = (Location)j.next();
            this.visitLocation(classContext, location, methodGen, dataflow);
        }
    }

    public boolean preScreen(MethodGen mg) {
        ConstantPoolGen cpg = mg.getConstantPool();
        int lockCount = mg.isSynchronized() ? 1 : 0;
        boolean sawWaitOrNotify = false;
        for (InstructionHandle handle = mg.getInstructionList().getStart(); !(handle == null || lockCount >= 2 && sawWaitOrNotify); handle = handle.getNext()) {
            INVOKEVIRTUAL inv;
            String methodName;
            Instruction ins = handle.getInstruction();
            if (ins instanceof MONITORENTER) {
                ++lockCount;
                continue;
            }
            if (!(ins instanceof INVOKEVIRTUAL) || !(methodName = (inv = (INVOKEVIRTUAL)ins).getMethodName(cpg)).equals("wait") && !methodName.startsWith("notify")) continue;
            sawWaitOrNotify = true;
        }
        return lockCount >= 2 && sawWaitOrNotify;
    }

    public void visitLocation(ClassContext classContext, Location location, MethodGen methodGen, LockDataflow dataflow) throws DataflowAnalysisException {
        String sourceFile;
        int count;
        ConstantPoolGen cpg = methodGen.getConstantPool();
        if (Hierarchy.isMonitorWait((Instruction)location.getHandle().getInstruction(), (ConstantPoolGen)cpg) && (count = dataflow.getFactAtLocation(location).getNumLockedObjects()) > 1) {
            sourceFile = this.javaClass.getSourceFileName();
            this.possibleWaitBugs.add(new BugInstance((Detector)this, "TLW_TWO_LOCK_WAIT", 1).addClass(this.javaClass).addMethod(methodGen, sourceFile).addSourceLine(classContext, methodGen, sourceFile, location.getHandle()));
        }
        if (Hierarchy.isMonitorNotify((Instruction)location.getHandle().getInstruction(), (ConstantPoolGen)cpg) && (count = dataflow.getFactAtLocation(location).getNumLockedObjects()) > 1) {
            sourceFile = this.javaClass.getSourceFileName();
            this.possibleNotifyLocations.add(SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (MethodGen)methodGen, (String)sourceFile, (InstructionHandle)location.getHandle()));
        }
    }

    public void report() {
    }
}

