/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;

public class ComparatorIdiom
extends PreorderVisitor
implements Detector {
    BugReporter bugReporter;

    public ComparatorIdiom(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void visit(JavaClass obj) {
        try {
            if (Repository.instanceOf((JavaClass)obj, (String)"java.util.Comparator") && !Repository.instanceOf((JavaClass)obj, (String)"java.io.Serializable")) {
                int priority = 2;
                int lastDollar = this.getClassName().lastIndexOf(36);
                if (lastDollar > 0 && Character.isDigit(this.getClassName().charAt(lastDollar + 1))) {
                    priority = 3;
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_COMPARATOR_SHOULD_BE_SERIALIZABLE", priority).addClass((PreorderVisitor)this));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void report() {
    }
}

