/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.coders;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.nustaq.offheap.bytez.BasicBytez;
import org.nustaq.offheap.bytez.onheap.HeapBytez;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzNameRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTDecoder;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.util.FSTUtil;

public class FSTBytezDecoder
implements FSTDecoder {
    BasicBytez input;
    HeapBytez ascStringCache;
    FSTConfiguration conf;
    public FSTClazzNameRegistry clnames;
    long pos;
    InputStream inputStream;
    long readUntil = 0L;
    byte[] tmp;
    char[] chBufS;

    public FSTBytezDecoder(FSTConfiguration conf, BasicBytez input) {
        this(conf);
        if (FSTConfiguration.isAndroid) {
            throw new RuntimeException("not supported on android");
        }
        this.input = input;
    }

    public FSTBytezDecoder(FSTConfiguration conf) {
        this.conf = conf;
        this.clnames = (FSTClazzNameRegistry)conf.getCachedObject(FSTClazzNameRegistry.class);
        if (this.clnames == null) {
            this.clnames = new FSTClazzNameRegistry(conf.getClassRegistry(), conf);
        } else {
            this.clnames.clear();
        }
    }

    @Override
    public int ensureReadAhead(int bytes) {
        if (this.inputStream != null) {
            if (this.pos + (long)bytes > this.readUntil) {
                return this.readNextInputChunk(bytes);
            }
        } else if (this.pos + (long)bytes > this.input.length()) {
            return -1;
        }
        return 0;
    }

    protected int readNextInputChunk(int bytes) {
        try {
            int read;
            int toRead = Math.max(Integer.MAX_VALUE, bytes);
            if (this.inputStream instanceof ByteArrayInputStream) {
                toRead = Math.min(((ByteArrayInputStream)this.inputStream).available(), toRead);
            }
            if (this.tmp == null || this.tmp.length < toRead) {
                this.tmp = new byte[toRead];
            }
            if ((read = this.inputStream.read(this.tmp, 0, toRead)) > 0) {
                if (this.input.length() < this.pos + (long)read) {
                    BasicBytez bytez = this.input.newInstance(2L * (this.pos + (long)read));
                    this.input.copyTo(bytez, 0L, 0L, this.pos);
                    this.input = (HeapBytez)bytez;
                }
                this.input.set(this.pos, this.tmp, 0, read);
                this.readUntil = this.pos + (long)read;
                return read;
            }
            if (read == -1) {
                return -1;
            }
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
        return 0;
    }

    char[] getCharBuf(int siz) {
        char[] chars = this.chBufS;
        if (chars == null || chars.length < siz) {
            this.chBufS = chars = new char[Math.max(siz, 15)];
        }
        return chars;
    }

    @Override
    public String readStringUTF() throws IOException {
        int len = this.readFInt();
        char[] charBuf = this.getCharBuf(len * 2);
        this.ensureReadAhead(len * 2);
        this.input.getCharArr(this.pos, charBuf, 0, len);
        this.pos += (long)(len * 2);
        return new String(charBuf, 0, len);
    }

    @Override
    public byte readObjectHeaderTag() throws IOException {
        return this.readFByte();
    }

    @Override
    public String readStringAsc() throws IOException {
        int len = this.readFInt();
        if (this.ascStringCache == null || this.ascStringCache.length() < (long)len) {
            this.ascStringCache = new HeapBytez(new byte[len]);
        }
        this.ensureReadAhead(len);
        this.input.copyTo(this.ascStringCache, 0L, this.pos, len);
        this.pos += (long)len;
        return new String(this.ascStringCache.getBase(), 0, 0, len);
    }

    public BasicBytez getInput() {
        return this.input;
    }

    public void setInput(BasicBytez input) {
        this.input = input;
    }

    @Override
    public Object readFPrimitiveArray(Object array, Class componentType, int len) {
        if (componentType == Byte.TYPE) {
            this.ensureReadAhead(len);
            byte[] arr = (byte[])array;
            this.input.getArr(this.pos, arr, 0, len);
            this.pos += (long)len;
            return arr;
        }
        if (componentType == Character.TYPE) {
            this.ensureReadAhead(len * 2);
            char[] arr = (char[])array;
            this.input.getCharArr(this.pos, arr, 0, len);
            this.pos += (long)(len * 2);
            return arr;
        }
        if (componentType == Short.TYPE) {
            this.ensureReadAhead(len * 2);
            short[] arr = (short[])array;
            this.input.getShortArr(this.pos, arr, 0, len);
            this.pos += (long)(len * 2);
            return arr;
        }
        if (componentType == Integer.TYPE) {
            this.ensureReadAhead(len * 4);
            int[] arr = (int[])array;
            this.input.getIntArr(this.pos, arr, 0, len);
            this.pos += (long)(len * 4);
            return arr;
        }
        if (componentType == Float.TYPE) {
            this.ensureReadAhead(len * 4);
            float[] arr = (float[])array;
            this.input.getFloatArr(this.pos, arr, 0, len);
            this.pos += (long)(len * 4);
            return arr;
        }
        if (componentType == Double.TYPE) {
            this.ensureReadAhead(len * 8);
            double[] arr = (double[])array;
            this.input.getDoubleArr(this.pos, arr, 0, len);
            this.pos += (long)(len * 8);
            return arr;
        }
        if (componentType == Long.TYPE) {
            this.ensureReadAhead(len * 8);
            long[] arr = (long[])array;
            this.input.getLongArr(this.pos, arr, 0, len);
            this.pos += (long)(len * 8);
            return arr;
        }
        if (componentType == Boolean.TYPE) {
            this.ensureReadAhead(len);
            boolean[] arr = (boolean[])array;
            this.input.getBooleanArr(this.pos, arr, 0, len);
            this.pos += (long)len;
            return arr;
        }
        throw new RuntimeException("unexpected primitive type " + componentType.getName());
    }

    @Override
    public void readFIntArr(int len, int[] arr) throws IOException {
        this.input.getIntArr(this.pos, arr, 0, len);
        this.pos += (long)(len * 4);
    }

    @Override
    public int readFInt() throws IOException {
        return this.readPlainInt();
    }

    @Override
    public double readFDouble() throws IOException {
        return Double.longBitsToDouble(this.readPlainLong());
    }

    @Override
    public float readFFloat() throws IOException {
        return Float.intBitsToFloat(this.readPlainInt());
    }

    @Override
    public final byte readFByte() throws IOException {
        this.ensureReadAhead(1);
        return this.input.get(this.pos++);
    }

    @Override
    public int readIntByte() throws IOException {
        int res = this.ensureReadAhead(1);
        if (res == -1) {
            return -1;
        }
        return this.input.get(this.pos++) & 0xFF;
    }

    @Override
    public long readFLong() throws IOException {
        return this.readPlainLong();
    }

    @Override
    public char readFChar() throws IOException {
        return this.readPlainChar();
    }

    @Override
    public short readFShort() throws IOException {
        return this.readPlainShort();
    }

    private char readPlainChar() throws IOException {
        this.ensureReadAhead(2);
        char res = this.input.getChar(this.pos);
        this.pos += 2L;
        return res;
    }

    private short readPlainShort() throws IOException {
        this.ensureReadAhead(2);
        short res = this.input.getShort(this.pos);
        this.pos += 2L;
        return res;
    }

    @Override
    public int readPlainInt() throws IOException {
        this.ensureReadAhead(4);
        int res = this.input.getInt(this.pos);
        this.pos += 4L;
        return res;
    }

    private long readPlainLong() throws IOException {
        this.ensureReadAhead(8);
        long res = this.input.getLong(this.pos);
        this.pos += 8L;
        return res;
    }

    @Override
    public byte[] getBuffer() {
        if (this.input instanceof HeapBytez && ((HeapBytez)this.input).getOffsetIndex() == 0L) {
            return ((HeapBytez)this.input).asByteArray();
        }
        byte[] res = new byte[(int)this.pos];
        this.input.getArr(0L, res, 0, (int)this.pos);
        return res;
    }

    @Override
    public int getInputPos() {
        return (int)this.pos;
    }

    @Override
    public void moveTo(int position) {
        this.pos = position;
    }

    @Override
    public void reset() {
        this.pos = 0L;
        this.clnames.clear();
        this.inputStream = null;
    }

    @Override
    public void setInputStream(InputStream in) {
        if (in == FSTObjectInput.emptyStream) {
            this.inputStream = null;
            this.readUntil = 0L;
            return;
        }
        this.inputStream = in;
        this.clnames.clear();
        this.pos = 0L;
        if (this.input == null) {
            this.input = new HeapBytez(new byte[4096]);
        }
        this.readUntil = 0L;
    }

    @Override
    public void resetToCopyOf(byte[] bytes, int off, int len) {
        this.inputStream = null;
        if (this.input == null) {
            byte[] base = new byte[len];
            this.input = new HeapBytez(base, 0L, len);
        }
        if (this.input.length() < (long)len) {
            this.input = (HeapBytez)this.input.newInstance(len);
        }
        this.input.set(0L, bytes, off, len);
        this.pos = 0L;
        this.clnames.clear();
    }

    @Override
    public void resetWith(byte[] bytes, int len) {
        this.inputStream = null;
        if (this.input == null) {
            this.input = new HeapBytez(bytes, 0L, len);
            return;
        }
        if (this.input.getClass() == HeapBytez.class) {
            ((HeapBytez)this.input).setBase(bytes, 0L, len);
        } else {
            BasicBytez newBytez = this.input.newInstance(len);
            newBytez.set(0L, bytes, 0, len);
        }
        this.pos = 0L;
        this.clnames.clear();
    }

    @Override
    public FSTClazzInfo readClass() throws IOException, ClassNotFoundException {
        return this.clnames.decodeClass(this);
    }

    @Override
    public Class classForName(String name) throws ClassNotFoundException {
        return this.clnames.classForName(name);
    }

    @Override
    public void registerClass(Class possible) {
        this.clnames.registerClass(possible);
    }

    @Override
    public void close() {
        this.conf.returnObject(this.clnames);
    }

    @Override
    public void skip(int n) {
        this.pos += (long)n;
    }

    @Override
    public void readPlainBytes(byte[] b, int off, int len) {
        this.ensureReadAhead(len);
        this.input.getArr(this.pos, b, off, len);
        this.pos += (long)len;
    }

    @Override
    public boolean isMapBased() {
        return false;
    }

    @Override
    public Object getDirectObject() {
        return null;
    }

    @Override
    public int getObjectHeaderLen() {
        return -1;
    }

    @Override
    public void consumeEndMarker() {
    }

    @Override
    public Class readArrayHeader() throws Exception {
        return this.readClass().getClazz();
    }

    @Override
    public void readExternalEnd() {
    }

    @Override
    public boolean isEndMarker(String s) {
        return false;
    }

    @Override
    public int readVersionTag() throws IOException {
        return this.readFByte();
    }

    @Override
    public void pushBack(int bytes) {
        this.pos -= (long)bytes;
    }

    @Override
    public void readArrayEnd(FSTClazzInfo clzSerInfo) {
    }

    @Override
    public void readObjectEnd() {
    }

    @Override
    public Object coerceElement(Class arrType, Object value) {
        return value;
    }

    @Override
    public int available() {
        return (int)(this.input.length() - this.pos);
    }
}

