/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kson;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Scanner;
import org.nustaq.kson.JSonSerializer;
import org.nustaq.kson.KsonArgTypesResolver;
import org.nustaq.kson.KsonDeserializer;
import org.nustaq.kson.KsonSerializer;
import org.nustaq.kson.KsonStringCharInput;
import org.nustaq.kson.KsonStringOutput;
import org.nustaq.kson.KsonTypeMapper;
import org.nustaq.serialization.FSTConfiguration;

public class Kson {
    public static FSTConfiguration conf = FSTConfiguration.createStructConfiguration().setForceClzInit(true);
    KsonTypeMapper mapper;
    boolean supportJSon = true;

    public Kson(KsonTypeMapper mapper) {
        this.mapper = mapper;
    }

    public Kson() {
        this(new KsonTypeMapper());
    }

    public static Class fumbleOutGenericKeyType(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType params = (ParameterizedType)genericType;
            Type[] actualTypeArguments = params.getActualTypeArguments();
            Type actualTypeArgument = null;
            if (actualTypeArguments != null && actualTypeArguments.length > 0) {
                actualTypeArgument = actualTypeArguments[0];
            }
            if (!(actualTypeArgument instanceof Class)) {
                while (actualTypeArgument instanceof ParameterizedType) {
                    actualTypeArgument = ((ParameterizedType)actualTypeArgument).getRawType();
                }
                if (!(actualTypeArgument instanceof Class)) {
                    return null;
                }
            }
            return (Class)actualTypeArgument;
        }
        return null;
    }

    public static Class fumbleOutGenericValueType(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType params = (ParameterizedType)genericType;
            Type[] actualTypeArguments = params.getActualTypeArguments();
            Type actualTypeArgument = null;
            if (actualTypeArguments != null && actualTypeArguments.length > 1 && !((actualTypeArgument = actualTypeArguments[1]) instanceof Class)) {
                while (actualTypeArgument instanceof ParameterizedType) {
                    actualTypeArgument = ((ParameterizedType)actualTypeArgument).getRawType();
                }
                if (!(actualTypeArgument instanceof Class)) {
                    return null;
                }
            }
            return (Class)actualTypeArgument;
        }
        return null;
    }

    public Kson map(String name, Class c) {
        this.mapper.map(name, c);
        return this;
    }

    public Kson map(Class ... c) {
        this.mapper.map(c);
        return this;
    }

    public Object readObject(String dson) throws Exception {
        KsonStringCharInput in = new KsonStringCharInput(dson);
        return new KsonDeserializer(in, this.mapper).supportJSon(this.supportJSon).readObject(null, null, null);
    }

    public Object readObject(String dsonOrJSon, String expectedType, KsonArgTypesResolver resolve) throws Exception {
        KsonStringCharInput in = new KsonStringCharInput(dsonOrJSon);
        Class type = this.mapper.getType(expectedType);
        return new KsonDeserializer(in, this.mapper).supportJSon(this.supportJSon).setArgTypesRessolver(resolve).readObject(type, String.class, null);
    }

    public Object readObject(String dsonOrJSon, String expectedType) throws Exception {
        if (expectedType == null) {
            return this.readObject(dsonOrJSon);
        }
        KsonStringCharInput in = new KsonStringCharInput(dsonOrJSon);
        Class type = this.mapper.getType(expectedType);
        return new KsonDeserializer(in, this.mapper).supportJSon(this.supportJSon).readObject(type, String.class, null);
    }

    public boolean isSupportJSon() {
        return this.supportJSon;
    }

    public Kson supportJSon(boolean supportJSon) {
        this.supportJSon = supportJSon;
        return this;
    }

    public Object readObject(File file) throws Exception {
        return this.readObject(file, (String)null);
    }

    public Object readObject(File file, Class type) throws Exception {
        return this.readObject(file, type.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject(File file, String type) throws Exception {
        try (FileInputStream fin = new FileInputStream(file);){
            Object object = this.readObject(fin, "UTF-8", type);
            return object;
        }
    }

    public Object readObject(InputStream stream, String encoding, String expectedType) throws Exception {
        return this.readObject(new Scanner(stream, encoding).useDelimiter("\\A").next(), expectedType);
    }

    public String writeObject(Object o) throws Exception {
        KsonStringOutput out = new KsonStringOutput();
        new KsonSerializer(out, this.mapper, conf).writeObject(o);
        return out.getBuilder().toString();
    }

    public String writeObject(Object o, boolean tagTopLevel) throws Exception {
        KsonStringOutput out = new KsonStringOutput();
        new KsonSerializer(out, this.mapper, conf).writeObject(o, tagTopLevel ? null : o.getClass());
        return out.getBuilder().toString();
    }

    public String writeJSonObject(Object o, boolean tagTopLevel) throws Exception {
        KsonStringOutput out = new KsonStringOutput();
        new JSonSerializer(out, this.mapper, conf).writeObject(o, tagTopLevel ? null : o.getClass());
        return out.getBuilder().toString();
    }

    public String writePlainJSonObject(Object o) throws Exception {
        KsonStringOutput out = new KsonStringOutput();
        new JSonSerializer(out, this.mapper, conf).writeObject(o, null);
        return out.getBuilder().toString();
    }

    public KsonTypeMapper getMapper() {
        return this.mapper;
    }
}

