/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.common;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationAlert;
import org.apache.wicket.Component;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessagesModel;
import org.apache.wicket.feedback.FencedFeedbackPanel;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.util.time.Duration;

public class NotificationPanel
extends FencedFeedbackPanel {
    private Duration duration;
    private boolean showRenderedMessages = false;

    public NotificationPanel(String id) {
        this(id, (Component)null);
    }

    public NotificationPanel(String id, Component fence) {
        this(id, fence, null);
    }

    public NotificationPanel(String id, IFeedbackMessageFilter filter) {
        this(id, null, filter);
    }

    public NotificationPanel(String id, Component fence, IFeedbackMessageFilter filter) {
        super(id, fence, filter);
    }

    public NotificationPanel showRenderedMessages(boolean showRenderedMessages) {
        this.showRenderedMessages = showRenderedMessages;
        return this;
    }

    public NotificationPanel hideAfter(Duration duration) {
        this.duration = duration;
        return this;
    }

    protected FeedbackMessagesModel newFeedbackMessagesModel() {
        FeedbackMessagesModel model = new FeedbackMessagesModel((Component)this);
        if (!this.showRenderedMessages) {
            model.setFilter(new IFeedbackMessageFilter(){

                public boolean accept(FeedbackMessage message) {
                    return !message.isRendered();
                }
            });
        }
        return model;
    }

    protected String getCSSClass(FeedbackMessage message) {
        return null;
    }

    protected Component newMessageDisplayComponent(String markupId, FeedbackMessage message) {
        return new NotificationAlert(markupId, message, this.duration);
    }
}

