/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.convert.BasicType;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.lang.ClassScaner;
import com.xiaoleilu.hutool.lang.Filter;
import com.xiaoleilu.hutool.lang.Singleton;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static <T> Class<T> getClass(T obj) {
        return null == obj ? null : obj.getClass();
    }

    public static String getClassName(Object obj, boolean isSimple) {
        if (null == obj) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        return ClassUtil.getClassName(clazz, isSimple);
    }

    public static String getClassName(Class<?> clazz, boolean isSimple) {
        if (null == clazz) {
            return null;
        }
        return isSimple ? clazz.getSimpleName() : clazz.getName();
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            classes[i] = objects[i].getClass();
        }
        return classes;
    }

    public static boolean equals(Class<?> clazz, String className, boolean ignoreCase) {
        if (null == clazz || StrUtil.isBlank(className)) {
            return false;
        }
        if (ignoreCase) {
            return className.equalsIgnoreCase(clazz.getName()) || className.equalsIgnoreCase(clazz.getSimpleName());
        }
        return className.equals(clazz.getName()) || className.equals(clazz.getSimpleName());
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return ClassScaner.scanPackageByAnnotation(packageName, annotationClass);
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        return ClassScaner.scanPackageBySuper(packageName, superClass);
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScaner.scanPackage();
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScaner.scanPackage(packageName);
    }

    public static Set<Class<?>> scanPackage(String packageName, Filter<Class<?>> classFilter) {
        return ClassScaner.scanPackage(packageName, classFilter);
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        Method[] methodArray;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methodArray = ClassUtil.getPublicMethods(clazz)) {
            String methodName = method.getName();
            methodSet.add(methodName);
        }
        return methodSet;
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return clazz.getMethods();
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Filter<Method> filter) {
        ArrayList<Method> methodList;
        if (null == clazz) {
            return null;
        }
        Method[] methods = ClassUtil.getPublicMethods(clazz);
        if (null != filter) {
            methodList = new ArrayList();
            for (Method method : methods) {
                if (!filter.accept(method)) continue;
                methodList.add(method);
            }
        } else {
            methodList = CollectionUtil.newArrayList(methods);
        }
        return methodList;
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        final HashSet<Method> excludeMethodSet = CollectionUtil.newHashSet(excludeMethods);
        return ClassUtil.getPublicMethods(clazz, new Filter<Method>(){

            @Override
            public boolean accept(Method method) {
                return false == excludeMethodSet.contains(method);
            }
        });
    }

    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        final HashSet<String> excludeMethodNameSet = CollectionUtil.newHashSet(excludeMethodNames);
        return ClassUtil.getPublicMethods(clazz, new Filter<Method>(){

            @Override
            public boolean accept(Method method) {
                return false == excludeMethodNameSet.contains(method.getName());
            }
        });
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws NoSuchMethodException, SecurityException {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return ClassUtil.getDeclaredMethod(clazz, methodName, paramTypes);
        }
    }

    public static Set<String> getDeclaredMethodNames(Class<?> clazz) {
        Method[] methodArray;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methodArray = ClassUtil.getDeclaredMethods(clazz)) {
            String methodName = method.getName();
            methodSet.add(methodName);
        }
        return methodSet;
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        HashSet<Method> methodSet = new HashSet<Method>();
        while (null != clazz) {
            Method[] declaredMethods;
            for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
                methodSet.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return methodSet.toArray(new Method[methodSet.size()]);
    }

    public static Method getDeclaredMethodOfObj(Object obj, String methodName, Object ... args) throws NoSuchMethodException, SecurityException {
        return ClassUtil.getDeclaredMethod(obj.getClass(), methodName, ClassUtil.getClasses(args));
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Method method = null;
        while (null != clazz) {
            try {
                method = clazz.getDeclaredMethod(methodName, parameterTypes);
                break;
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return method;
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) throws NoSuchFieldException, SecurityException {
        if (null == clazz || StrUtil.isBlank(fieldName)) {
            return null;
        }
        return clazz.getDeclaredField(fieldName);
    }

    public static Field[] getDeclaredFields(Class<?> clazz) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        return clazz.getDeclaredFields();
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !method.getName().equals("equals")) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 1 && paramTypes[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    public static Set<String> getClassPathResources() {
        return ClassUtil.getClassPaths("");
    }

    public static Set<String> getClassPaths(String packageName) {
        Enumeration<URL> resources;
        String packagePath = packageName.replace(".", "/");
        try {
            resources = ClassUtil.getClassLoader().getResources(packagePath);
        }
        catch (IOException e) {
            throw new UtilException(StrUtil.format((CharSequence)"Loading classPath [{}] error!", packagePath), e);
        }
        HashSet<String> paths = new HashSet<String>();
        while (resources.hasMoreElements()) {
            paths.add(resources.nextElement().getPath());
        }
        return paths;
    }

    public static String getClassPath() {
        return ClassUtil.getClassPathURL().getPath();
    }

    public static URL getClassPathURL() {
        return ClassUtil.getResourceURL("");
    }

    @Deprecated
    public static URL getURL(String resource) {
        return ClassUtil.getResourceUrl(resource, null);
    }

    public static URL getResourceURL(String resource) {
        return ClassUtil.getResourceUrl(resource, null);
    }

    public static URL getResourceUrl(String resource, Class<?> baseClass) {
        return null != baseClass ? baseClass.getResource(resource) : ClassUtil.getClassLoader().getResource(resource);
    }

    public static String[] getJavaClassPaths() {
        String[] classPaths = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        return classPaths;
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = ClassUtil.getContextClassLoader();
        if (classLoader == null && null == (classLoader = ClassUtil.class.getClassLoader())) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static <T> T newInstance(String clazz) {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format((CharSequence)"Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format((CharSequence)"Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) {
        if (ArrayUtil.isEmpty(params)) {
            return ClassUtil.newInstance(clazz);
        }
        Class<?>[] paramTypes = ClassUtil.getClasses(params);
        Constructor<T> constructor = ClassUtil.getConstructor(clazz, ClassUtil.getClasses(params));
        if (null == constructor) {
            throw new UtilException("No Constructor matched for parameter types: [{}]", new Object[]{paramTypes});
        }
        try {
            return ClassUtil.getConstructor(clazz, paramTypes).newInstance(params);
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format((CharSequence)"Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<?>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassUtil.isAllAssignableFrom(pts, parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    public static boolean isAllAssignableFrom(Class<?>[] types1, Class<?>[] types2) {
        if (ArrayUtil.isEmpty(types1) && ArrayUtil.isEmpty(types2)) {
            return true;
        }
        if (types1.length == types2.length) {
            for (int i = 0; i < types1.length; ++i) {
                if (types1[i].isAssignableFrom(types2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static <T> Class<T> loadClass(String className, boolean isInitialized) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className, isInitialized, ClassUtil.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e);
        }
        return clazz;
    }

    public static <T> Class<T> loadClass(String className) {
        return ClassUtil.loadClass(className, true);
    }

    public static <T> T invoke(String classNameDotMethodName, Object[] args) {
        return ClassUtil.invoke(classNameDotMethodName, false, args);
    }

    public static <T> T invoke(String classNameWithMethodName, boolean isSingleton, Object[] args) {
        if (StrUtil.isBlank(classNameWithMethodName)) {
            throw new UtilException("Blank classNameDotMethodName!");
        }
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new UtilException("Invalid classNameWithMethodName [{}]!", classNameWithMethodName);
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        String methodName = classNameWithMethodName.substring(splitIndex + 1);
        return ClassUtil.invoke(className, methodName, isSingleton, args);
    }

    public static <T> T invoke(String className, String methodName, Object[] args) {
        return ClassUtil.invoke(className, methodName, false, args);
    }

    public static <T> T invoke(String className, String methodName, boolean isSingleton, Object[] args) {
        Class<T> clazz = ClassUtil.loadClass(className);
        try {
            Method method = ClassUtil.getDeclaredMethod(clazz, methodName, ClassUtil.getClasses(args));
            if (null == method) {
                throw new NoSuchMethodException(StrUtil.format((CharSequence)"No such method: [{}]", methodName));
            }
            if (ClassUtil.isStatic(method)) {
                return ClassUtil.invoke(null, method, args);
            }
            return ClassUtil.invoke(isSingleton ? Singleton.get(clazz, new Object[0]) : clazz.newInstance(), method, args);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static <T> T invoke(Object obj, String methodName, Object[] args) {
        try {
            Method method = ClassUtil.getDeclaredMethodOfObj(obj, methodName, args);
            if (null == method) {
                throw new NoSuchMethodException(StrUtil.format((CharSequence)"No such method: [{}]", methodName));
            }
            return ClassUtil.invoke(obj, method, args);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static <T> T invokeStatic(Method method, Object[] args) throws InvocationTargetException, IllegalArgumentException {
        return ClassUtil.invoke(null, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object[] args) throws InvocationTargetException, IllegalArgumentException {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return (T)method.invoke(ClassUtil.isStatic(method) ? null : obj, args);
        }
        catch (IllegalAccessException e) {
            throw new UtilException(e);
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return BasicType.wrapperPrimitiveMap.containsKey(clazz);
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || ClassUtil.isPrimitiveWrapper(clazz);
    }

    public static boolean isSimpleTypeOrArray(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return ClassUtil.isSimpleValueType(clazz) || clazz.isArray() && ClassUtil.isSimpleValueType(clazz.getComponentType());
    }

    public static boolean isSimpleValueType(Class<?> clazz) {
        return ClassUtil.isBasicType(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.equals(URI.class) || clazz.equals(URL.class) || clazz.equals(Locale.class) || clazz.equals(Class.class);
    }

    public static boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        Class<?> resolvedWrapper;
        Class<?> resolvedPrimitive;
        if (null == targetType || null == sourceType) {
            return false;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        return targetType.isPrimitive() ? (resolvedPrimitive = BasicType.wrapperPrimitiveMap.get(sourceType)) != null && targetType.equals(resolvedPrimitive) : (resolvedWrapper = BasicType.primitiveWrapperMap.get(sourceType)) != null && targetType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isPublic(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("Class to provided is null.");
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Method method) {
        if (null == method) {
            throw new NullPointerException("Method to provided is null.");
        }
        return ClassUtil.isPublic(method.getDeclaringClass());
    }

    public static boolean isNotPublic(Class<?> clazz) {
        return false == ClassUtil.isPublic(clazz);
    }

    public static boolean isNotPublic(Method method) {
        return false == ClassUtil.isPublic(method);
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static Method setAccessible(Method method) {
        if (null != method && ClassUtil.isNotPublic(method)) {
            method.setAccessible(true);
        }
        return method;
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isNormalClass(Class<?> clazz) {
        return null != clazz && false == clazz.isInterface() && false == ClassUtil.isAbstract(clazz) && false == clazz.isEnum() && false == clazz.isArray() && false == clazz.isAnnotation() && false == clazz.isSynthetic() && false == clazz.isPrimitive();
    }

    public static Class<?> getTypeArgument(Class<?> clazz) {
        return ClassUtil.getTypeArgument(clazz, 0);
    }

    public static Class<?> getTypeArgument(Class<?> clazz, int index) {
        Type type;
        ParameterizedType genericSuperclass;
        Type[] types;
        Type superType = clazz.getGenericSuperclass();
        if (superType instanceof ParameterizedType && null != (types = (genericSuperclass = (ParameterizedType)superType).getActualTypeArguments()) && types.length > index && (type = types[index]) instanceof Class) {
            return (Class)type;
        }
        return null;
    }

    public static String getPackage(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(".");
        if (packageEndIndex == -1) {
            return "";
        }
        return className.substring(0, packageEndIndex);
    }

    public static String getPackagePath(Class<?> clazz) {
        return ClassUtil.getPackage(clazz).replace('.', '/');
    }
}

