/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.jekyll.tag.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTag;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagBlock;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagExtension;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JekyllTagNodeRenderer
implements NodeRenderer {
    private final boolean enabledRendering;
    private final Map<String, String> includeContent;

    public JekyllTagNodeRenderer(DataHolder options) {
        this.enabledRendering = (Boolean)JekyllTagExtension.ENABLE_RENDERING.getFrom(options);
        this.includeContent = (Map)JekyllTagExtension.INCLUDED_HTML.getFrom(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(JekyllTag.class, (CustomNodeRenderer)new CustomNodeRenderer<JekyllTag>(){

            public void render(JekyllTag node, NodeRendererContext context, HtmlWriter html) {
                JekyllTagNodeRenderer.this.render(node, context, html);
            }
        }));
        set.add(new NodeRenderingHandler(JekyllTagBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<JekyllTagBlock>(){

            public void render(JekyllTagBlock node, NodeRendererContext context, HtmlWriter html) {
                JekyllTagNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(JekyllTag node, NodeRendererContext context, HtmlWriter html) {
        String content;
        if (this.enabledRendering) {
            html.text((CharSequence)node.getChars());
        } else if (node.getTag().equals("include") && this.includeContent != null && !node.getParameters().isEmpty() && (content = this.includeContent.get(node.getParameters())) != null && !content.isEmpty()) {
            html.rawPre((CharSequence)content);
        }
    }

    private void render(JekyllTagBlock node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren((Node)node);
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new JekyllTagNodeRenderer(options);
        }
    }
}

