/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.jekyll.tag.internal;

import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.BlockContent;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTag;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagBlock;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagExtension;
import com.vladsch.flexmark.ext.jekyll.tag.internal.JekyllTagParsing;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;

public class JekyllTagBlockParser
extends AbstractBlockParser {
    private final JekyllTagBlock block = new JekyllTagBlock();
    private BlockContent content = new BlockContent();

    JekyllTagBlockParser(DataHolder options) {
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        return BlockContinue.none();
    }

    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    public void closeBlock(ParserState state) {
        this.block.setContent(this.content);
        this.content = null;
    }

    public void parseInlines(InlineParser inlineParser) {
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final JekyllTagParsing parsing;
        private final boolean listIncludesOnly;

        BlockFactory(DataHolder options) {
            super(options);
            this.parsing = new JekyllTagParsing(new Parsing(options));
            this.listIncludesOnly = (Boolean)JekyllTagExtension.LIST_INCLUDES_ONLY.getFrom(options);
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BasedSequence tryLine;
            Matcher matcher;
            BasedSequence line = state.getLine();
            int currentIndent = state.getIndent();
            if (currentIndent == 0 && !(matchedBlockParser.getBlockParser().getBlock() instanceof Paragraph) && (matcher = this.parsing.MACRO_OPEN.matcher((CharSequence)(tryLine = line.subSequence(state.getIndex())))).find()) {
                BasedSequence tag = tryLine.subSequence(0, matcher.end());
                BasedSequence tagName = line.subSequence(matcher.start(1), matcher.end(1));
                BasedSequence parameters = tryLine.subSequence(matcher.end(1), matcher.end() - 2).trim();
                JekyllTag tagNode = new JekyllTag(tag.subSequence(0, 2), tagName, parameters, tag.endSequence(2));
                tagNode.setCharsFromContent();
                JekyllTagBlockParser parser = new JekyllTagBlockParser((DataHolder)state.getProperties());
                parser.block.appendChild((Node)tagNode);
                if (!this.listIncludesOnly || tagName.equals("include")) {
                    List tagList = (List)JekyllTagExtension.TAG_LIST.getFrom((DataHolder)state.getProperties());
                    tagList.add(tagNode);
                }
                return BlockStart.of((BlockParser[])new BlockParser[]{parser}).atIndex(state.getLineEndIndex());
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

