/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.jsonfilter;

import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JFMessages;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JSONObjectFilter;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class NegateJSONObjectFilter
extends JSONObjectFilter {
    public static final String FILTER_TYPE = "negate";
    public static final String FIELD_NEGATE_FILTER = "negateFilter";
    private static final Set<String> REQUIRED_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("negateFilter")));
    private static final Set<String> OPTIONAL_FIELD_NAMES = Collections.emptySet();
    private static final long serialVersionUID = -9067967834329526711L;
    private volatile JSONObjectFilter negateFilter;

    NegateJSONObjectFilter() {
        this.negateFilter = null;
    }

    public NegateJSONObjectFilter(JSONObjectFilter negateFilter) {
        Validator.ensureNotNull(negateFilter);
        this.negateFilter = negateFilter;
    }

    public JSONObjectFilter getNegateFilter() {
        return this.negateFilter;
    }

    public void setNegateFilter(JSONObjectFilter negateFilter) {
        Validator.ensureNotNull(negateFilter);
        this.negateFilter = negateFilter;
    }

    @Override
    public String getFilterType() {
        return FILTER_TYPE;
    }

    @Override
    protected Set<String> getRequiredFieldNames() {
        return REQUIRED_FIELD_NAMES;
    }

    @Override
    protected Set<String> getOptionalFieldNames() {
        return OPTIONAL_FIELD_NAMES;
    }

    @Override
    public boolean matchesJSONObject(JSONObject o) {
        return !this.negateFilter.matchesJSONObject(o);
    }

    @Override
    public JSONObject toJSONObject() {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(2));
        fields.put("filterType", new JSONString(FILTER_TYPE));
        fields.put(FIELD_NEGATE_FILTER, this.negateFilter.toJSONObject());
        return new JSONObject(fields);
    }

    @Override
    protected NegateJSONObjectFilter decodeFilter(JSONObject filterObject) throws JSONException {
        JSONValue v = filterObject.getField(FIELD_NEGATE_FILTER);
        if (v == null) {
            throw new JSONException(JFMessages.ERR_OBJECT_FILTER_MISSING_REQUIRED_FIELD.get(String.valueOf(filterObject), FILTER_TYPE, FIELD_NEGATE_FILTER));
        }
        if (!(v instanceof JSONObject)) {
            throw new JSONException(JFMessages.ERR_OBJECT_FILTER_VALUE_NOT_OBJECT.get(String.valueOf(filterObject), FILTER_TYPE, FIELD_NEGATE_FILTER));
        }
        try {
            return new NegateJSONObjectFilter(JSONObjectFilter.decode((JSONObject)v));
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new JSONException(JFMessages.ERR_OBJECT_FILTER_VALUE_NOT_FILTER.get(String.valueOf(filterObject), FILTER_TYPE, FIELD_NEGATE_FILTER, e.getMessage()), e);
        }
    }
}

