/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.zinc;

import com.typesafe.zinc.Setup$Defaults$;
import com.typesafe.zinc.Util;
import com.typesafe.zinc.Util$;
import java.io.File;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import sbt.ConsoleLogger;
import sbt.ConsoleLogger$;
import sbt.ConsoleOut;
import sbt.IO$;
import sbt.Logger;
import sbt.Relation;
import sbt.inc.Analysis;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util$
implements ScalaObject {
    public static final Util$ MODULE$;
    private final Regex Duration;

    static {
        new Util$();
    }

    public Logger logger(boolean quiet, Enumeration.Value level, boolean color) {
        Util.SilentLogger silentLogger;
        if (quiet) {
            silentLogger = new Util.SilentLogger();
        } else {
            boolean x$3 = ConsoleLogger$.MODULE$.formatEnabled() && color;
            ConsoleOut x$4 = ConsoleLogger$.MODULE$.apply$default$1();
            boolean x$5 = ConsoleLogger$.MODULE$.apply$default$2();
            Function1 x$6 = ConsoleLogger$.MODULE$.apply$default$4();
            ConsoleLogger log = ConsoleLogger$.MODULE$.apply(x$4, x$5, x$3, x$6);
            log.setLevel(level);
            silentLogger = log;
        }
        return silentLogger;
    }

    public String timing(long start2) {
        long end = System.currentTimeMillis();
        return Predef$.MODULE$.augmentString("at %s [%s]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dateTime(end), this.duration(end - start2)}));
    }

    public String duration(long millis) {
        long secs = millis / 1000L;
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)(secs / 60L)), (Object)BoxesRunTime.boxToLong((long)(secs % 60L)), (Object)BoxesRunTime.boxToLong((long)(millis % 1000L)));
        if (tuple3 != null) {
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            long m = BoxesRunTime.unboxToLong((Object)tuple32._1());
            long s = BoxesRunTime.unboxToLong((Object)tuple32._2());
            long ms = BoxesRunTime.unboxToLong((Object)tuple32._3());
            return m > 0L ? Predef$.MODULE$.augmentString("%d:%02d.%03ds").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m), BoxesRunTime.boxToLong((long)s), BoxesRunTime.boxToLong((long)ms)})) : Predef$.MODULE$.augmentString("%d.%03ds").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)s), BoxesRunTime.boxToLong((long)ms)}));
        }
        throw new MatchError((Object)tuple3);
    }

    public String dateTime(long time) {
        return DateFormat.getDateTimeInstance().format(new Date(time));
    }

    public File normalise(Option<File> cwd, File file) {
        return cwd.isDefined() && !file.isAbsolute() ? new File((File)cwd.get(), file.getPath()) : file;
    }

    public Option<File> normaliseOpt(Option<File> cwd$3, Option<File> optFile) {
        return cwd$3.isDefined() ? optFile.map((Function1)new Serializable(cwd$3){
            public static final long serialVersionUID;
            private final Option cwd$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final File apply(File file) {
                return Util$.MODULE$.normalise((Option<File>)this.cwd$3, file);
            }
            {
                this.cwd$3 = option;
            }
        }) : optFile;
    }

    public Seq<File> normaliseSeq(Option<File> cwd$2, Seq<File> files) {
        return cwd$2.isDefined() ? (Seq)files.map((Function1)new Serializable(cwd$2){
            public static final long serialVersionUID;
            private final Option cwd$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final File apply(File file) {
                return Util$.MODULE$.normalise((Option<File>)this.cwd$2, file);
            }
            {
                this.cwd$2 = option;
            }
        }, Seq$.MODULE$.canBuildFrom()) : files;
    }

    public Map<File, File> normaliseMap(Option<File> cwd$4, Map<File, File> mapped) {
        return cwd$4.isDefined() ? (Map)mapped.map((Function1)new Serializable(cwd$4){
            public static final long serialVersionUID;
            private final Option cwd$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<File, File> apply(Tuple2<File, File> tuple2) {
                Tuple2<File, File> tuple22 = tuple2;
                if (tuple22 != null) {
                    return new Tuple2((Object)Util$.MODULE$.normalise((Option<File>)this.cwd$4, (File)tuple22._1()), (Object)Util$.MODULE$.normalise((Option<File>)this.cwd$4, (File)tuple22._2()));
                }
                throw new MatchError(tuple22);
            }
            {
                this.cwd$4 = option;
            }
        }, Map$.MODULE$.canBuildFrom()) : mapped;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int intProperty(String name, int n) {
        int n2;
        String value = System.getProperty(name);
        if (value == null) {
            n2 = n;
            return n2;
        }
        int exceptionResult1 = 0;
        try {
            exceptionResult1 = Predef$.MODULE$.augmentString(value).toInt();
        }
        catch (Exception exception) {
            exceptionResult1 = n;
        }
        n2 = exceptionResult1;
        return n2;
    }

    public Set<String> stringSetProperty(String name, Set<String> set) {
        String value = System.getProperty(name);
        return value != null ? Predef$.MODULE$.refArrayOps((Object[])value.split(",")).toSet() : set;
    }

    public File fileProperty(String name) {
        return new File(System.getProperty(name, ""));
    }

    public Option<File> optFileProperty(String name) {
        return Option$.MODULE$.apply((Object)System.getProperty(name, null)).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final File apply(String string) {
                return new File(string);
            }
        });
    }

    public Option<String> propertyFromResource(String resource, String property, ClassLoader classLoader) {
        Properties props = this.propertiesFromResource(resource, classLoader);
        return Option$.MODULE$.apply((Object)props.getProperty(property));
    }

    public Properties propertiesFromResource(String resource, ClassLoader classLoader) {
        Properties props = new Properties();
        InputStream stream = classLoader.getResourceAsStream(resource);
        try {
            props.load(stream);
        }
        catch (Exception exception) {
            stream.close();
        }
        return props;
        finally {
            stream.close();
        }
    }

    public void setProperties(Seq<String> props) {
        props.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(String prop) {
                String[] kv2 = prop.split("=");
                return kv2.length == 2 ? System.setProperty(kv2[0], kv2[1]) : BoxedUnit.UNIT;
            }
        });
    }

    public Regex Duration() {
        return this.Duration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long duration(String arg, long l) {
        long l2;
        long exceptionResult2;
        List list;
        String string = arg;
        Option option = this.Duration().unapplySeq((Object)string);
        if (!option.isEmpty() && ((list = (List)option.get()) == null ? false : list.lengthCompare(2) == 0)) {
            int n;
            String string2;
            String unit;
            String string3;
            String string4 = string3 = (unit = (string2 = (String)list.apply(1)));
            String string5 = "h";
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                n = 3600000;
            } else {
                String string6 = string3;
                String string7 = "m";
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    n = 60000;
                } else {
                    String string8 = string3;
                    String string9 = "s";
                    n = !(string8 != null ? !string8.equals(string9) : string9 != null) ? 1000 : 0;
                }
            }
            int multiplier = n;
            exceptionResult2 = 0L;
            try {
                exceptionResult2 = Predef$.MODULE$.augmentString((String)list.apply(0)).toLong() * (long)multiplier;
            }
            catch (Exception exception) {
                exceptionResult2 = l;
            }
        } else {
            l2 = l;
            return l2;
        }
        l2 = exceptionResult2;
        return l2;
    }

    public Util.Alarm timer(long delay, Function0<BoxedUnit> body) {
        return new Util.Alarm(delay, body);
    }

    public void printRelations(Analysis analysis$1, Option<File> output, Option<File> cwd$1) {
        output.foreach((Function1)new Serializable(analysis$1, cwd$1){
            public static final long serialVersionUID;
            private final Analysis analysis$1;
            private final Option cwd$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File file) {
                String userDir$1 = Predef$.MODULE$.any2stringadd(this.cwd$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final File apply() {
                        return Setup$Defaults$.MODULE$.userDir();
                    }
                })).$plus("/");
                Seq relationStrings = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relation[]{this.analysis$1.relations().srcProd(), this.analysis$1.relations().binaryDep(), this.analysis$1.relations().internalSrcDep(), this.analysis$1.relations().externalDep(), this.analysis$1.relations().classes()}))).map((Function1)new Serializable(this, userDir$1){
                    public static final long serialVersionUID;
                    private final anonfun.printRelations.1 $outer;
                    private final String userDir$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply(Relation<?, ?> relation2) {
                        return this.$outer.relation$1(relation2, this.userDir$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.userDir$1 = string;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                String output = Predef$.MODULE$.augmentString(Predef$.MODULE$.augmentString("\n        |products:\n        |%s\n        |binary dependencies:\n        |%s\n        |source dependencies:\n        |%s\n        |external dependencies:\n        |%s\n        |class names:\n        |%s\n        ".trim()).stripMargin()).format(relationStrings);
                IO$.MODULE$.write(file, output, IO$.MODULE$.write$default$3(), IO$.MODULE$.write$default$4());
            }

            private final String noCwd$1(String path, String string) {
                return Predef$.MODULE$.augmentString(path).stripPrefix(string);
            }

            public final String keyValue$1(Tuple2 kv2, String string) {
                return new StringBuilder().append((Object)"   ").append((Object)this.noCwd$1(kv2._1().toString(), string)).append((Object)" -> ").append((Object)this.noCwd$1(kv2._2().toString(), string)).toString();
            }

            public final String relation$1(Relation r, String string) {
                return ((TraversableOnce)((SeqLike)r.all().toSeq().map((Function1)new Serializable(this, string){
                    public static final long serialVersionUID;
                    private final anonfun.printRelations.1 $outer;
                    private final String userDir$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply(Tuple2<Object, Object> tuple2) {
                        return this.$outer.keyValue$1(tuple2, this.userDir$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.userDir$1 = string;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n");
            }
            {
                this.analysis$1 = analysis;
                this.cwd$1 = option;
            }
        });
    }

    public void show(Object thing, Function1<String, BoxedUnit> output$1, String prefix, int level$1) {
        block8: {
            Object any;
            block5: {
                Object object;
                block9: {
                    Traversable traversable;
                    block11: {
                        block10: {
                            block7: {
                                block6: {
                                    Some some;
                                    while (true) {
                                        if ((object = thing) instanceof Tuple2) {
                                            Tuple2 tuple2 = (Tuple2)object;
                                            Object object2 = tuple2._1();
                                            Object object3 = tuple2._2();
                                            if (object2 instanceof Object) {
                                                if (object3 instanceof Object) {
                                                    prefix = new StringBuilder().append((Object)object2.toString()).append((Object)" = ").toString();
                                                    thing = object3;
                                                    continue;
                                                }
                                                any = tuple2;
                                            } else {
                                                any = tuple2;
                                            }
                                            break block5;
                                        }
                                        if (!(object instanceof Some)) break block6;
                                        some = (Some)object;
                                        Object object4 = some.x();
                                        if (!(object4 instanceof Object)) break;
                                        thing = object4;
                                    }
                                    any = some;
                                    break block5;
                                }
                                None$ none$ = None$.MODULE$;
                                Object object5 = object;
                                if (none$ != null ? !none$.equals(object5) : object5 != null) break block7;
                                this.out$1(prefix, output$1, level$1);
                                break block8;
                            }
                            if (!(object instanceof Traversable)) break block9;
                            traversable = (Traversable)object;
                            Traversable t = traversable;
                            if (!this.gd1$1(t)) break block10;
                            this.out$1(new StringBuilder().append((Object)prefix).append((Object)"{}").toString(), output$1, level$1);
                            break block8;
                        }
                        if (!(traversable instanceof Traversable)) break block11;
                        this.out$1(new StringBuilder().append((Object)prefix).append((Object)"{").toString(), output$1, level$1);
                        traversable.foreach((Function1)new Serializable(output$1, level$1){
                            public static final long serialVersionUID;
                            private final Function1 output$1;
                            private final int level$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply(Object a) {
                                Util$.MODULE$.show(a, (Function1<String, BoxedUnit>)this.output$1, "", this.level$1 + 1);
                            }
                            {
                                this.output$1 = function1;
                                this.level$1 = n;
                            }
                        });
                        this.out$1("}", output$1, level$1);
                        break block8;
                    }
                    any = traversable;
                    break block5;
                }
                any = object;
            }
            this.out$1(new StringBuilder().append((Object)prefix).append((Object)any.toString()).toString(), output$1, level$1);
        }
    }

    public int show$default$4() {
        return 0;
    }

    public String show$default$3() {
        return "";
    }

    public String counted(int count, String prefix, String single, String plural) {
        return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)count)).toString()).append((Object)" ").append((Object)prefix).append((Object)(count == 1 ? single : plural)).toString();
    }

    private final void out$1(String s, Function1 function1, int n) {
        function1.apply((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("   ").$times(n)).append((Object)s).toString());
    }

    private final boolean gd1$1(Traversable traversable) {
        return traversable.isEmpty();
    }

    private Util$() {
        MODULE$ = this;
        this.Duration = Predef$.MODULE$.augmentString("(\\d+)([hms])").r();
    }
}

