/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.zinc;

import com.typesafe.zinc.ScalaLocation;
import com.typesafe.zinc.Settings;
import com.typesafe.zinc.Setup;
import com.typesafe.zinc.Setup$Defaults$;
import com.typesafe.zinc.Util$;
import java.io.File;
import java.util.List;
import java.util.Properties;
import sbt.FileFilter;
import sbt.FileFilter$;
import sbt.Logger;
import sbt.Logger$;
import sbt.Path$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple7;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Setup$
implements ScalaObject,
Serializable {
    public static final Setup$ MODULE$;
    private final String Command;
    private final String Description;
    private final String HomeProperty;
    private final String DirProperty;
    private final String ScalaCompilerId;
    private final String ScalaLibraryId;
    private final String ScalaCompilerName;
    private final String ScalaLibraryName;
    private final String SbtInterfaceName;
    private final String CompilerInterfaceSourcesName;
    private Setup.Version zincVersion;
    private String versionString;
    public volatile int bitmap$0;

    static {
        new Setup$();
    }

    public String Command() {
        return this.Command;
    }

    public String Description() {
        return this.Description;
    }

    public String HomeProperty() {
        return this.HomeProperty;
    }

    public String DirProperty() {
        return this.DirProperty;
    }

    public String ScalaCompilerId() {
        return this.ScalaCompilerId;
    }

    public String ScalaLibraryId() {
        return this.ScalaLibraryId;
    }

    public String ScalaCompilerName() {
        return this.ScalaCompilerName;
    }

    public String ScalaLibraryName() {
        return this.ScalaLibraryName;
    }

    public String SbtInterfaceName() {
        return this.SbtInterfaceName;
    }

    public String CompilerInterfaceSourcesName() {
        return this.CompilerInterfaceSourcesName;
    }

    public Setup apply(Settings settings) {
        Tuple3<File, File, Seq<File>> tuple3 = this.scalaJars(settings.scala());
        if (tuple3 != null) {
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            File compiler = (File)tuple32._1();
            File library = (File)tuple32._2();
            Seq extra = (Seq)tuple32._3();
            File sbtInterface = (File)settings.sbt().sbtInterface().getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final File apply() {
                    return Setup$Defaults$.MODULE$.sbtInterface();
                }
            });
            File compilerInterfaceSrc = (File)settings.sbt().compilerInterfaceSrc().getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final File apply() {
                    return Setup$Defaults$.MODULE$.compilerInterfaceSrc();
                }
            });
            return this.setup(compiler, library, (Seq<File>)extra, sbtInterface, compilerInterfaceSrc, settings.javaHome());
        }
        throw new MatchError(tuple3);
    }

    public Setup setup(File scalaCompiler, File scalaLibrary, Seq<File> scalaExtra, File sbtInterface, File compilerInterfaceSrc, Option<File> javaHomeDir) {
        Serializable normalise = new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final File apply(File file) {
                return file.getCanonicalFile();
            }
        };
        File compilerJar = (File)normalise.apply((Object)scalaCompiler);
        File libraryJar = (File)normalise.apply((Object)scalaLibrary);
        Seq extraJars = (Seq)scalaExtra.map((Function1)normalise, Seq$.MODULE$.canBuildFrom());
        Option javaHome = javaHomeDir.map((Function1)normalise);
        File cacheDir = this.zincCacheDir();
        return new Setup(compilerJar, libraryJar, (Seq<File>)extraJars, sbtInterface, compilerInterfaceSrc, (Option<File>)javaHome, cacheDir);
    }

    public Setup create(File scalaCompiler, File scalaLibrary, List<File> scalaExtra, File sbtInterface, File compilerInterfaceSrc, File javaHome) {
        return this.setup(scalaCompiler, scalaLibrary, (Seq<File>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(scalaExtra).asScala()), sbtInterface, compilerInterfaceSrc, (Option<File>)Option$.MODULE$.apply((Object)javaHome));
    }

    public Tuple3<File, File, Seq<File>> scalaJars(ScalaLocation scala$1) {
        Tuple3 tuple3 = (Tuple3)this.splitScala(scala$1.path(), (Set<String>)this.splitScala$default$2()).orElse((Function0)new Serializable(scala$1){
            public static final long serialVersionUID;
            private final ScalaLocation scala$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<Tuple3<File, File, Seq<File>>> apply() {
                return Setup$.MODULE$.splitScala(Setup$.MODULE$.allLibs(this.scala$1.home()), Setup$Defaults$.MODULE$.scalaExcluded());
            }
            {
                this.scala$1 = scalaLocation;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple3<File, File, Seq<File>> apply() {
                return Setup$Defaults$.MODULE$.scalaJars();
            }
        });
        if (tuple3 != null) {
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            File compiler$1 = (File)tuple32._1();
            File library$1 = (File)tuple32._2();
            Seq extra = (Seq)tuple32._3();
            return new Tuple3(scala$1.compiler().getOrElse((Function0)new Serializable(compiler$1){
                public static final long serialVersionUID;
                private final File compiler$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final File apply() {
                    return this.compiler$1;
                }
                {
                    this.compiler$1 = file;
                }
            }), scala$1.library().getOrElse((Function0)new Serializable(library$1){
                public static final long serialVersionUID;
                private final File library$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final File apply() {
                    return this.library$1;
                }
                {
                    this.library$1 = file;
                }
            }), scala$1.extra().$plus$plus((GenTraversableOnce)extra, Seq$.MODULE$.canBuildFrom()));
        }
        throw new MatchError((Object)tuple3);
    }

    public Option<Tuple3<File, File, Seq<File>>> splitScala(Seq<File> jars, Set<String> excluded$1) {
        Seq filtered = (Seq)jars.filterNot((Function1)new Serializable(excluded$1){
            public static final long serialVersionUID;
            private final Set excluded$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File file) {
                return this.excluded$1.contains((Object)file.getName());
            }
            {
                this.excluded$1 = set;
            }
        });
        Tuple2 tuple2 = filtered.partition((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File file) {
                return file.getName().contains(Setup$.MODULE$.ScalaCompilerId());
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            Seq compiler = (Seq)tuple22._1();
            Seq other = (Seq)tuple22._2();
            Tuple2 tuple23 = other.partition((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(File file) {
                    return file.getName().contains(Setup$.MODULE$.ScalaLibraryId());
                }
            });
            if (tuple23 != null) {
                Tuple2 tuple24 = new Tuple2(tuple23._1(), tuple23._2());
                Seq library = (Seq)tuple24._1();
                Seq extra = (Seq)tuple24._2();
                return compiler.nonEmpty() && library.nonEmpty() ? new Some((Object)new Tuple3(compiler.apply(0), library.apply(0), (Object)extra)) : None$.MODULE$;
            }
            throw new MatchError((Object)tuple23);
        }
        throw new MatchError((Object)tuple2);
    }

    public Set splitScala$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public File zincCacheDir() {
        return Path$.MODULE$.richFile(Setup$Defaults$.MODULE$.zincDir()).$div(this.zincVersion().published());
    }

    public boolean verify(Setup setup, Logger log) {
        boolean scalaCompiler = this.requireFile(setup.scalaCompiler(), log);
        boolean scalaLibrary = this.requireFile(setup.scalaLibrary(), log);
        boolean sbtInterface = this.requireFile(setup.sbtInterface(), log);
        boolean compilerInterfaceSrc = this.requireFile(setup.compilerInterfaceSrc(), log);
        return scalaCompiler && scalaLibrary && sbtInterface && compilerInterfaceSrc;
    }

    /*
     * WARNING - void declaration
     */
    public boolean requireFile(File file$1, Logger log) {
        void var3_3;
        boolean exists = file$1.exists();
        if (!exists) {
            log.error((Function0)new Serializable(file$1){
                public static final long serialVersionUID;
                private final File file$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Required file not found: ").append((Object)this.file$1.getName()).toString();
                }
                {
                    this.file$1 = file;
                }
            });
        }
        return (boolean)var3_3;
    }

    public String prop(String name) {
        return new StringBuilder().append((Object)this.Command()).append((Object)".").append((Object)name).toString();
    }

    public Seq<File> allLibs(Option<File> homeDir) {
        return (Seq)homeDir.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<File> apply(File home) {
                return Path$.MODULE$.singleFileFinder(Path$.MODULE$.richFile(home).$div("lib")).$times$times((FileFilter)FileFilter$.MODULE$.globFilter("*.jar")).get();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public Option<File> optLib(Option<File> homeDir, String name$2) {
        return this.allLibs(homeDir).find((Function1)new Serializable(name$2){
            public static final long serialVersionUID;
            private final String name$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File file) {
                String string = file.getName();
                String string2 = this.name$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.name$2 = string;
            }
        });
    }

    public File optLibOrDefault(Option<File> homeDir, String name$1) {
        return (File)this.optLib(homeDir, name$1).getOrElse((Function0)new Serializable(name$1){
            public static final long serialVersionUID;
            private final String name$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final File apply() {
                return new File(this.name$1);
            }
            {
                this.name$1 = string;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Setup.Version zincVersion() {
        if ((this.bitmap$0 & 1) != 0) return this.zincVersion;
        Setup$ setup$ = this;
        synchronized (setup$) {
            if ((this.bitmap$0 & 1) == 0) {
                Properties props = Util$.MODULE$.propertiesFromResource("zinc.version.properties", this.getClass().getClassLoader());
                this.zincVersion = new Setup.Version(props.getProperty("version", "unknown"), props.getProperty("timestamp", ""), props.getProperty("commit", ""));
                this.bitmap$0 |= 1;
            }
            return this.zincVersion;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String versionString() {
        if ((this.bitmap$0 & 2) != 0) return this.versionString;
        Setup$ setup$ = this;
        synchronized (setup$) {
            if ((this.bitmap$0 & 2) == 0) {
                this.versionString = this.zincVersion().published().endsWith("-SNAPSHOT") ? Predef$.MODULE$.augmentString("%s %s-%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zincVersion().published(), this.zincVersion().timestamp(), Predef$.MODULE$.augmentString(this.zincVersion().commit()).take(10)})) : this.zincVersion().published();
                this.bitmap$0 |= 2;
            }
            return this.versionString;
        }
    }

    public void printVersion() {
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s (%s) %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.Command(), this.Description(), this.versionString()})));
    }

    public void debug(Setup setup, xsbti.Logger log$1) {
        this.show(setup, (Function1<String, BoxedUnit>)new Serializable(log$1){
            public static final long serialVersionUID;
            private final xsbti.Logger log$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String s$1) {
                this.log$1.debug(Logger$.MODULE$.f0((Function0)new Serializable(this, s$1){
                    public static final long serialVersionUID;
                    private final String s$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return this.s$1;
                    }
                    {
                        this.s$1 = string;
                    }
                }));
            }
            {
                this.log$1 = logger;
            }
        });
    }

    public void show(Setup setup, Function1<String, BoxedUnit> output) {
        Seq values = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"scala compiler").$minus$greater((Object)setup.scalaCompiler()), Predef$.MODULE$.any2ArrowAssoc((Object)"scala library").$minus$greater((Object)setup.scalaLibrary()), Predef$.MODULE$.any2ArrowAssoc((Object)"scala extra").$minus$greater(setup.scalaExtra()), Predef$.MODULE$.any2ArrowAssoc((Object)"sbt interface").$minus$greater((Object)setup.sbtInterface()), Predef$.MODULE$.any2ArrowAssoc((Object)"compiler interface sources").$minus$greater((Object)setup.compilerInterfaceSrc()), Predef$.MODULE$.any2ArrowAssoc((Object)"java home").$minus$greater(setup.javaHome()), Predef$.MODULE$.any2ArrowAssoc((Object)"cache directory").$minus$greater((Object)setup.cacheDir())}));
        Util$.MODULE$.show(new Tuple2((Object)"Setup", (Object)values), output, Util$.MODULE$.show$default$3(), Util$.MODULE$.show$default$4());
    }

    public Option unapply(Setup x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.scalaCompiler(), (Object)x$0.scalaLibrary(), x$0.scalaExtra(), (Object)x$0.sbtInterface(), (Object)x$0.compilerInterfaceSrc(), x$0.javaHome(), (Object)x$0.cacheDir()));
    }

    public Setup apply(File scalaCompiler, File scalaLibrary, Seq scalaExtra, File sbtInterface, File compilerInterfaceSrc, Option javaHome, File cacheDir) {
        return new Setup(scalaCompiler, scalaLibrary, (Seq<File>)scalaExtra, sbtInterface, compilerInterfaceSrc, (Option<File>)javaHome, cacheDir);
    }

    public Object readResolve() {
        return MODULE$;
    }

    private Setup$() {
        MODULE$ = this;
        this.Command = "zinc";
        this.Description = "scala incremental compiler";
        this.HomeProperty = this.prop("home");
        this.DirProperty = this.prop("dir");
        this.ScalaCompilerId = "scala-compiler";
        this.ScalaLibraryId = "scala-library";
        this.ScalaCompilerName = "scala-compiler.jar";
        this.ScalaLibraryName = "scala-library.jar";
        this.SbtInterfaceName = "sbt-interface.jar";
        this.CompilerInterfaceSourcesName = "compiler-interface-sources.jar";
    }
}

