/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.zinc;

import com.typesafe.zinc.Cache;
import com.typesafe.zinc.Cache$;
import com.typesafe.zinc.Compiler;
import com.typesafe.zinc.Setup;
import com.typesafe.zinc.Setup$Defaults$;
import com.typesafe.zinc.Util$;
import java.io.File;
import java.net.URLClassLoader;
import sbt.ClasspathOptions$;
import sbt.Path$;
import sbt.ScalaInstance;
import sbt.classpath.ClasspathUtilities$;
import sbt.compiler.AggressiveCompile$;
import sbt.compiler.AnalyzingCompiler;
import sbt.compiler.CompilerCache$;
import sbt.compiler.IC$;
import sbt.compiler.JavaTool;
import sbt.inc.Analysis;
import scala.Function0;
import scala.Option;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import xsbti.Logger;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.GlobalsCache;
import xsbti.compile.JavaCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Compiler$
implements ScalaObject {
    public static final Compiler$ MODULE$;
    private final String CompilerInterfaceId;
    private final String JavaClassVersion;
    private final Cache<Setup, Compiler> cache;
    private final GlobalsCache compilerCache;
    private final Cache<File, Analysis> analysisCache;

    static {
        new Compiler$();
    }

    public String CompilerInterfaceId() {
        return this.CompilerInterfaceId;
    }

    public String JavaClassVersion() {
        return this.JavaClassVersion;
    }

    public Cache<Setup, Compiler> cache() {
        return this.cache;
    }

    public GlobalsCache compilerCache() {
        return this.compilerCache;
    }

    public Cache<File, Analysis> analysisCache() {
        return this.analysisCache;
    }

    public Compiler apply(Setup setup$1, Logger log$1) {
        return this.cache().get(setup$1, (Function0<Compiler>)new Serializable(setup$1, log$1){
            public static final long serialVersionUID;
            private final Setup setup$1;
            private final Logger log$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Compiler apply() {
                return Compiler$.MODULE$.create(this.setup$1, this.log$1);
            }
            {
                this.setup$1 = setup;
                this.log$1 = logger;
            }
        });
    }

    public Compiler getOrCreate(Setup setup, Logger log) {
        return this.apply(setup, log);
    }

    public Compiler create(Setup setup, Logger log) {
        ScalaInstance instance = this.scalaInstance(setup);
        File interfaceJar = this.compilerInterface(setup, instance, log);
        AnalyzingCompiler scalac = IC$.MODULE$.newScalaCompiler((xsbti.compile.ScalaInstance)instance, interfaceJar, (ClasspathOptions)ClasspathOptions$.MODULE$.boot(), log);
        JavaTool javac = AggressiveCompile$.MODULE$.directOrFork(instance, ClasspathOptions$.MODULE$.javac(false), setup.javaHome());
        return new Compiler(scalac, (JavaCompiler)javac);
    }

    public GlobalsCache createCompilerCache(int maxCompilers) {
        return maxCompilers <= 0 ? CompilerCache$.MODULE$.fresh() : CompilerCache$.MODULE$.apply(maxCompilers);
    }

    public ScalaInstance scalaInstance(Setup setup) {
        File file = setup.scalaLibrary();
        File file2 = setup.scalaCompiler();
        URLClassLoader loader = this.scalaLoader((Seq<File>)((Seq)((SeqLike)setup.scalaExtra().$plus$colon((Object)file2, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)file, Seq$.MODULE$.canBuildFrom())));
        Option<String> version = this.scalaVersion(loader);
        return new ScalaInstance((String)version.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "unknown";
            }
        }), (ClassLoader)loader, setup.scalaLibrary(), setup.scalaCompiler(), setup.scalaExtra(), version);
    }

    public URLClassLoader scalaLoader(Seq<File> jars) {
        return new URLClassLoader(Path$.MODULE$.toURLs(jars), ClasspathUtilities$.MODULE$.rootLoader());
    }

    public Option<String> scalaVersion(ClassLoader scalaLoader) {
        return Util$.MODULE$.propertyFromResource("compiler.properties", "version.number", scalaLoader);
    }

    public File compilerInterface(Setup setup, ScalaInstance scalaInstance2, Logger log) {
        File dir = Path$.MODULE$.richFile(setup.cacheDir()).$div(this.interfaceId(scalaInstance2.actualVersion()));
        File interfaceJar = Path$.MODULE$.richFile(dir).$div(new StringBuilder().append((Object)this.CompilerInterfaceId()).append((Object)".jar").toString());
        if (!interfaceJar.exists()) {
            dir.mkdirs();
            IC$.MODULE$.compileInterfaceJar(this.CompilerInterfaceId(), setup.compilerInterfaceSrc(), interfaceJar, setup.sbtInterface(), (xsbti.compile.ScalaInstance)scalaInstance2, log);
        }
        return interfaceJar;
    }

    public String interfaceId(String scalaVersion) {
        return new StringBuilder().append((Object)this.CompilerInterfaceId()).append((Object)"-").append((Object)scalaVersion).append((Object)"-").append((Object)this.JavaClassVersion()).toString();
    }

    private Compiler$() {
        MODULE$ = this;
        this.CompilerInterfaceId = "compiler-interface";
        this.JavaClassVersion = System.getProperty("java.class.version");
        this.cache = Cache$.MODULE$.apply(Setup$Defaults$.MODULE$.compilerCacheLimit());
        this.compilerCache = this.createCompilerCache(Setup$Defaults$.MODULE$.residentCacheLimit());
        this.analysisCache = Cache$.MODULE$.apply(Setup$Defaults$.MODULE$.analysisCacheLimit());
    }
}

