/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.CodeSource;
import java.util.Properties;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sbt.AllPassFilter$;
import sbt.ErrorHandling$;
import sbt.GlobFilter$;
import sbt.IO$;
import sbt.NameFilter;
import sbt.Path$;
import sbt.PathFinder;
import sbt.PathFinder$;
import sbt.Using;
import sbt.Using$;
import scala.Array$;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IO$
implements ScalaObject {
    public static final IO$ MODULE$;
    private final int MaximumTries;
    private Random random;
    private final File temporaryDirectory;
    private final int BufferSize;
    private final String Newline;
    private final Charset utf8;
    private final Pattern PathSeparatorPattern;
    private volatile int bitmap$priv$0;

    static {
        new IO$();
    }

    private int MaximumTries() {
        return this.MaximumTries;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Random random() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.random;
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                this.random = new Random();
                this.bitmap$priv$0 |= 1;
            }
            return this.random;
        }
    }

    public File temporaryDirectory() {
        return this.temporaryDirectory;
    }

    private int BufferSize() {
        return this.BufferSize;
    }

    public String Newline() {
        return this.Newline;
    }

    public Charset utf8() {
        return this.utf8;
    }

    public URL classLocation(Class<?> cl) {
        CodeSource codeSource = cl.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            throw Predef$.MODULE$.error(new StringBuilder().append((Object)"No class location for ").append(cl).toString());
        }
        return codeSource.getLocation();
    }

    public File classLocationFile(Class<?> cl) {
        return this.toFile(this.classLocation(cl));
    }

    public <T> URL classLocation(Manifest<T> mf) {
        return this.classLocation(mf.erasure());
    }

    public <T> File classLocationFile(Manifest<T> mf) {
        return this.classLocationFile(mf.erasure());
    }

    /*
     * WARNING - void declaration
     */
    public File toFile(URL url) {
        void var2_2;
        File exceptionResult1 = null;
        try {
            exceptionResult1 = new File(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            exceptionResult1 = new File(url.getPath());
        }
        return var2_2;
    }

    public File asFile(URL url$1) {
        return (File)this.urlAsFile(url$1).getOrElse((Function0)new Serializable(url$1){
            public static final long serialVersionUID;
            private final URL url$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                return Predef$.MODULE$.error(new StringBuilder().append((Object)"URL is not a file: ").append((Object)this.url$1).toString());
            }
            {
                this.url$1 = uRL;
            }
        });
    }

    public Option<File> urlAsFile(URL url) {
        Object object;
        String string;
        String string2 = string = url.getProtocol();
        String string3 = "file";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            object = new Some((Object)this.toFile(url));
        } else {
            String path2;
            int end;
            String string4 = string;
            String string5 = "jar";
            object = !(string4 != null ? !string4.equals(string5) : string5 != null) ? new Some((Object)new File(new URI((end = (path2 = url.getPath()).indexOf(33)) == -1 ? path2 : path2.substring(0, end)))) : None$.MODULE$;
        }
        return object;
    }

    public void assertDirectory(File file$1) {
        Predef$.MODULE$.assert(file$1.isDirectory(), (Function0)new Serializable(file$1){
            public static final long serialVersionUID;
            private final File file$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)(this.file$1.exists() ? "Not a directory: " : "Directory not found: ")).append((Object)this.file$1).toString();
            }
            {
                this.file$1 = file;
            }
        });
    }

    public void assertDirectories(Seq<File> file) {
        file.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File file) {
                IO$.MODULE$.assertDirectory(file);
            }
        });
    }

    public Tuple2<String, String> split(String name) {
        int lastDot = name.lastIndexOf(46);
        return lastDot >= 0 ? new Tuple2((Object)name.substring(0, lastDot), (Object)name.substring(lastDot + 1)) : new Tuple2((Object)name, (Object)"");
    }

    public void touch(Traversable<File> files) {
        files.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File f) {
                IO$.MODULE$.touch(f, IO$.MODULE$.touch$default$2());
            }
        });
    }

    public void touch(File file, boolean setModified) {
        File absFile$1 = file.getAbsoluteFile();
        this.createDirectory(absFile$1.getParentFile());
        boolean created = BoxesRunTime.unboxToBoolean(ErrorHandling$.MODULE$.translate((Function0<String>)new Serializable(absFile$1){
            public static final long serialVersionUID;
            private final File absFile$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Could not create file ").append((Object)this.absFile$1).toString();
            }
            {
                this.absFile$1 = file;
            }
        }, new Serializable(absFile$1){
            public static final long serialVersionUID;
            private final File absFile$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.absFile$1.createNewFile();
            }
            {
                this.absFile$1 = file;
            }
        }));
        if (!created && !absFile$1.isDirectory() && setModified && !absFile$1.setLastModified(System.currentTimeMillis())) {
            throw Predef$.MODULE$.error(new StringBuilder().append((Object)"Could not update last modified time for file ").append((Object)absFile$1).toString());
        }
    }

    public boolean touch$default$2() {
        return true;
    }

    public void createDirectories(Traversable<File> dirs) {
        dirs.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File file) {
                IO$.MODULE$.createDirectory(file);
            }
        });
    }

    public void createDirectory(File dir$1) {
        for (int tryCount = 0; !dir$1.exists() && !dir$1.mkdirs() && tryCount < 100; ++tryCount) {
        }
        if (dir$1.isDirectory()) {
            return;
        }
        if (dir$1.exists()) {
            throw Predef$.MODULE$.error(new StringBuilder().append((Object)this.failBase$1(dir$1)).append((Object)": file exists and is not a directory.").toString());
        }
        throw Predef$.MODULE$.error(this.failBase$1(dir$1));
    }

    public void gzip(File in, File out$1) {
        File file = in;
        File file2 = out$1;
        Predef$.MODULE$.require(file != null ? !((Object)file).equals(file2) : file2 != null, (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Input file cannot be the same as the output file.";
            }
        });
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, new Serializable(out$1){
            public static final long serialVersionUID;
            private final File out$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(BufferedInputStream inputStream$1) {
                ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(this.out$1, new Serializable(this, inputStream$1){
                    public static final long serialVersionUID;
                    private final BufferedInputStream inputStream$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(BufferedOutputStream outputStream) {
                        IO$.MODULE$.gzip(this.inputStream$1, outputStream);
                    }
                    {
                        this.inputStream$1 = bufferedInputStream2;
                    }
                });
            }
            {
                this.out$1 = file;
            }
        });
    }

    public void gzip(InputStream input$1, OutputStream output) {
        Using$.MODULE$.gzipOutputStream().apply(output, new Serializable(input$1){
            public static final long serialVersionUID;
            private final InputStream input$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(GZIPOutputStream gzStream) {
                IO$.MODULE$.transfer(this.input$1, (OutputStream)gzStream);
            }
            {
                this.input$1 = inputStream;
            }
        });
    }

    public void gunzip(File in, File out$4) {
        File file = in;
        File file2 = out$4;
        Predef$.MODULE$.require(file != null ? !((Object)file).equals(file2) : file2 != null, (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Input file cannot be the same as the output file.";
            }
        });
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, new Serializable(out$4){
            public static final long serialVersionUID;
            private final File out$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(BufferedInputStream inputStream$2) {
                ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(this.out$4, new Serializable(this, inputStream$2){
                    public static final long serialVersionUID;
                    private final BufferedInputStream inputStream$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(BufferedOutputStream outputStream) {
                        IO$.MODULE$.gunzip(this.inputStream$2, outputStream);
                    }
                    {
                        this.inputStream$2 = bufferedInputStream2;
                    }
                });
            }
            {
                this.out$4 = file;
            }
        });
    }

    public void gunzip(InputStream input2, OutputStream output$1) {
        Using$.MODULE$.gzipInputStream().apply(input2, new Serializable(output$1){
            public static final long serialVersionUID;
            private final OutputStream output$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(GZIPInputStream gzStream) {
                IO$.MODULE$.transfer((InputStream)gzStream, this.output$1);
            }
            {
                this.output$1 = outputStream;
            }
        });
    }

    public scala.collection.immutable.Set<File> unzip(File from, File toDirectory$1, NameFilter filter$1, boolean preserveLastModified$1) {
        return (scala.collection.immutable.Set)((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, new Serializable(toDirectory$1, filter$1, preserveLastModified$1){
            public static final long serialVersionUID;
            private final File toDirectory$1;
            private final NameFilter filter$1;
            private final boolean preserveLastModified$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final scala.collection.immutable.Set<File> apply(BufferedInputStream in) {
                return IO$.MODULE$.unzipStream(in, this.toDirectory$1, this.filter$1, this.preserveLastModified$1);
            }
            {
                this.toDirectory$1 = file;
                this.filter$1 = nameFilter;
                this.preserveLastModified$1 = bl;
            }
        });
    }

    public boolean unzip$default$4() {
        return true;
    }

    public NameFilter unzip$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public scala.collection.immutable.Set<File> unzipURL(URL from, File toDirectory$3, NameFilter filter$3, boolean preserveLastModified$3) {
        return (scala.collection.immutable.Set)Using$.MODULE$.urlInputStream().apply(from, new Serializable(toDirectory$3, filter$3, preserveLastModified$3){
            public static final long serialVersionUID;
            private final File toDirectory$3;
            private final NameFilter filter$3;
            private final boolean preserveLastModified$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final scala.collection.immutable.Set<File> apply(BufferedInputStream in) {
                return IO$.MODULE$.unzipStream(in, this.toDirectory$3, this.filter$3, this.preserveLastModified$3);
            }
            {
                this.toDirectory$3 = file;
                this.filter$3 = nameFilter;
                this.preserveLastModified$3 = bl;
            }
        });
    }

    public boolean unzipURL$default$4() {
        return true;
    }

    public NameFilter unzipURL$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public scala.collection.immutable.Set<File> unzipStream(InputStream from, File toDirectory$2, NameFilter filter$2, boolean preserveLastModified$2) {
        this.createDirectory(toDirectory$2);
        return (scala.collection.immutable.Set)Using$.MODULE$.zipInputStream().apply(from, new Serializable(toDirectory$2, filter$2, preserveLastModified$2){
            public static final long serialVersionUID;
            private final File toDirectory$2;
            private final NameFilter filter$2;
            private final boolean preserveLastModified$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final scala.collection.immutable.Set<File> apply(ZipInputStream zipInput) {
                return IO$.MODULE$.sbt$IO$$extract(zipInput, this.toDirectory$2, this.filter$2, this.preserveLastModified$2);
            }
            {
                this.toDirectory$2 = file;
                this.filter$2 = nameFilter;
                this.preserveLastModified$2 = bl;
            }
        });
    }

    public boolean unzipStream$default$4() {
        return true;
    }

    public NameFilter unzipStream$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public final scala.collection.immutable.Set<File> sbt$IO$$extract(ZipInputStream from$1, File toDirectory$4, NameFilter filter$4, boolean preserveLastModified$4) {
        HashSet set$1 = new HashSet();
        this.next$1(from$1, toDirectory$4, filter$4, preserveLastModified$4, set$1);
        return (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)set$1);
    }

    public void download(URL url, File to$1) {
        Using$.MODULE$.urlInputStream().apply(url, new Serializable(to$1){
            public static final long serialVersionUID;
            private final File to$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(BufferedInputStream inputStream) {
                IO$.MODULE$.transfer((InputStream)inputStream, this.to$1);
            }
            {
                this.to$1 = file;
            }
        });
    }

    public void transfer(File in, File out$3) {
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, new Serializable(out$3){
            public static final long serialVersionUID;
            private final File out$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(BufferedInputStream in) {
                IO$.MODULE$.transfer((InputStream)in, this.out$3);
            }
            {
                this.out$3 = file;
            }
        });
    }

    public void transfer(File in, OutputStream out$2) {
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, new Serializable(out$2){
            public static final long serialVersionUID;
            private final OutputStream out$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(BufferedInputStream in) {
                IO$.MODULE$.transfer((InputStream)in, this.out$2);
            }
            {
                this.out$2 = outputStream;
            }
        });
    }

    public void transfer(InputStream in$1, File to) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(to, new Serializable(in$1){
            public static final long serialVersionUID;
            private final InputStream in$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(BufferedOutputStream outputStream) {
                IO$.MODULE$.transfer(this.in$1, (OutputStream)outputStream);
            }
            {
                this.in$1 = inputStream;
            }
        });
    }

    public void transfer(InputStream in, OutputStream out) {
        this.transferImpl(in, out, false);
    }

    public void transferAndClose(InputStream in, OutputStream out) {
        this.transferImpl(in, out, true);
    }

    private void transferImpl(InputStream in$2, OutputStream out$5, boolean close) {
        try {
            byte[] buffer$1 = new byte[this.BufferSize()];
            this.read$1(in$2, out$5, buffer$1);
            return;
        }
        finally {
            if (close) {
                in$2.close();
            }
        }
    }

    public <T> T withTemporaryDirectory(Function1<File, T> action) {
        File dir = this.createTemporaryDirectory();
        Object exceptionResult2 = null;
        try {
            exceptionResult2 = action.apply((Object)dir);
            return (T)exceptionResult2;
        }
        finally {
            this.delete(dir);
        }
    }

    public File createTemporaryDirectory() {
        return this.createUniqueDirectory(this.temporaryDirectory());
    }

    public File createUniqueDirectory(File baseDirectory$1) {
        return this.create$1(0, baseDirectory$1);
    }

    public <T> T withTemporaryFile(String prefix, String postfix, Function1<File, T> action) {
        File file = File.createTempFile(prefix, postfix);
        Object exceptionResult3 = null;
        try {
            exceptionResult3 = action.apply((Object)file);
            return (T)exceptionResult3;
        }
        finally {
            file.delete();
        }
    }

    public Iterable<File> jars(File dir) {
        return Predef$.MODULE$.wrapRefArray((Object[])this.listFiles(dir, GlobFilter$.MODULE$.apply("*.jar")));
    }

    public void deleteIfEmpty(Set<File> dirs$1) {
        HashMap isEmpty$1 = new HashMap();
        dirs$1.foreach((Function1)new Serializable(dirs$1, isEmpty$1){
            public static final long serialVersionUID;
            private final Set dirs$1;
            private final HashMap isEmpty$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File file) {
                return IO$.MODULE$.visit$1(file, this.dirs$1, this.isEmpty$1);
            }
            {
                this.dirs$1 = set2;
                this.isEmpty$1 = hashMap;
            }
        });
        ((HashMap)isEmpty$1.filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<File, Object> tuple2) {
                Tuple2<File, Object> tuple22 = tuple2;
                return tuple22 != null && BoxesRunTime.unboxToBoolean((Object)tuple22._2());
            }
        })).foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<File, Object> tuple2) {
                Tuple2<File, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    File file = (File)tuple22._1();
                    if (BoxesRunTime.unboxToBoolean((Object)tuple22._2())) {
                        return file.delete();
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple22);
            }
        });
    }

    public void delete(Iterable<File> files) {
        files.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File file) {
                IO$.MODULE$.delete(file);
            }
        });
    }

    public void deleteFilesEmptyDirs(Iterable<File> files) {
        this.delete(files);
        this.deleteEmpty$1(this.parents$1(files.toSet()));
    }

    public void delete(File file$2) {
        ErrorHandling$.MODULE$.translate((Function0<String>)new Serializable(file$2){
            public static final long serialVersionUID;
            private final File file$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Error deleting file ").append((Object)this.file$2).append((Object)": ").toString();
            }
            {
                this.file$2 = file;
            }
        }, new Serializable(file$2){
            public static final long serialVersionUID;
            private final File file$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply() {
                Object object;
                boolean deleted = this.file$2.delete();
                if (!deleted && this.file$2.isDirectory()) {
                    IO$.MODULE$.delete((Iterable<File>)Predef$.MODULE$.wrapRefArray((Object[])IO$.MODULE$.listFiles(this.file$2)));
                    object = BoxesRunTime.boxToBoolean((boolean)this.file$2.delete());
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.file$2 = file;
            }
        });
    }

    public File[] listFiles(FileFilter filter2, File dir) {
        return this.wrapNull(dir.listFiles(filter2));
    }

    public File[] listFiles(File dir, FileFilter filter2) {
        return this.wrapNull(dir.listFiles(filter2));
    }

    public File[] listFiles(File dir) {
        return this.wrapNull(dir.listFiles());
    }

    public File[] wrapNull(File[] a) {
        return a == null ? new File[]{} : a;
    }

    public void jar(Traversable<Tuple2<File, String>> sources, File outputJar, java.util.jar.Manifest manifest) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputJar, (Option<java.util.jar.Manifest>)new Some((Object)manifest));
    }

    public void zip(Traversable<Tuple2<File, String>> sources, File outputZip) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputZip, (Option<java.util.jar.Manifest>)None$.MODULE$);
    }

    private void archive(Seq<Tuple2<File, String>> sources$1, File outputFile, Option<java.util.jar.Manifest> manifest$1) {
        if (outputFile.isDirectory()) {
            throw Predef$.MODULE$.error(new StringBuilder().append((Object)"Specified output file ").append((Object)outputFile).append((Object)" is a directory.").toString());
        }
        File outputDir = outputFile.getParentFile();
        this.createDirectory(outputDir);
        this.withZipOutput(outputFile, manifest$1, (Function1<ZipOutputStream, BoxedUnit>)new Serializable(sources$1, manifest$1){
            public static final long serialVersionUID;
            private final Seq sources$1;
            private final Option manifest$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ZipOutputStream output) {
                Object createEntry = this.manifest$1.isDefined() ? new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final JarEntry apply(String string) {
                        return new JarEntry(string);
                    }
                } : new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final ZipEntry apply(String string) {
                        return new ZipEntry(string);
                    }
                };
                IO$.MODULE$.sbt$IO$$writeZip((Seq<Tuple2<File, String>>)this.sources$1, output, (Function1<String, ZipEntry>)createEntry);
            }
            {
                this.sources$1 = seq;
                this.manifest$1 = option;
            }
        });
    }

    public final void sbt$IO$$writeZip(Seq<Tuple2<File, String>> sources, ZipOutputStream output$2, Function1<String, ZipEntry> createEntry$1) {
        Seq files = (Seq)sources.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final List<Tuple2<File, String>> apply(Tuple2<File, String> tuple2) {
                Tuple2<File, String> tuple22 = tuple2;
                if (tuple22 != null) {
                    Nil$ nil$;
                    File file = (File)tuple22._1();
                    String string = (String)tuple22._2();
                    File file2 = file;
                    String name = string;
                    if (file2.isFile()) {
                        Tuple2 tuple23 = new Tuple2((Object)file2, (Object)IO$.MODULE$.sbt$IO$$normalizeName(name));
                        nil$ = Nil$.MODULE$.$colon$colon((Object)tuple23);
                    } else {
                        nil$ = Nil$.MODULE$;
                    }
                    return nil$;
                }
                throw new MatchError(tuple22);
            }
        }, Seq$.MODULE$.canBuildFrom());
        long now$1 = System.currentTimeMillis();
        long emptyCRC$1 = new CRC32().getValue();
        this.allDirectoryPaths((Iterable<Tuple2<File, String>>)files).foreach((Function1)new Serializable(output$2, createEntry$1, now$1, emptyCRC$1){
            public static final long serialVersionUID;
            private final ZipOutputStream output$2;
            private final Function1 createEntry$1;
            private final long now$1;
            private final long emptyCRC$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String string) {
                IO$.MODULE$.addDirectoryEntry$1(string, this.output$2, this.createEntry$1, this.now$1, this.emptyCRC$1);
            }
            {
                this.output$2 = zipOutputStream2;
                this.createEntry$1 = function1;
                this.now$1 = l;
                this.emptyCRC$1 = l2;
            }
        });
        files.foreach((Function1)new Serializable(output$2, createEntry$1){
            public static final long serialVersionUID;
            private final ZipOutputStream output$2;
            private final Function1 createEntry$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<File, String> tuple2) {
                Tuple2<File, String> tuple22 = tuple2;
                if (tuple22 != null) {
                    IO$.MODULE$.addFileEntry$1((File)tuple22._1(), (String)tuple22._2(), this.output$2, this.createEntry$1);
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                this.output$2 = zipOutputStream2;
                this.createEntry$1 = function1;
            }
        });
    }

    private List<String> relativeComponents(String path2) {
        return (List)Predef$.MODULE$.refArrayOps((Object[])path2.split("/")).toList().dropRight(1);
    }

    private List<String> directories(List<String> path2) {
        return (List)path2.foldLeft((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""})), (Function2)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final List<String> apply(List<String> e, String l) {
                String string = new StringBuilder().append((Object)((String)e.head())).append((Object)l).append((Object)"/").toString();
                return e.$colon$colon((Object)string);
            }
        });
    }

    public final List<String> sbt$IO$$directoryPaths(String path2) {
        return (List)this.directories(this.relativeComponents(path2)).filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                return string.length() > 1;
            }
        });
    }

    private TreeSet<String> allDirectoryPaths(Iterable<Tuple2<File, String>> files) {
        return (TreeSet)TreeSet$.MODULE$.apply((Seq)Nil$.MODULE$, (Ordering)Ordering.String$.MODULE$).$plus$plus((GenTraversableOnce)files.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final List<String> apply(Tuple2<File, String> tuple2) {
                Tuple2<File, String> tuple22 = tuple2;
                if (tuple22 != null) {
                    return IO$.MODULE$.sbt$IO$$directoryPaths((String)tuple22._2());
                }
                throw new MatchError(tuple22);
            }
        }, Iterable$.MODULE$.canBuildFrom()));
    }

    private String normalizeDirName(String name) {
        String norm1 = this.sbt$IO$$normalizeName(name);
        return norm1.endsWith("/") ? norm1 : new StringBuilder().append((Object)norm1).append((Object)"/").toString();
    }

    public final String sbt$IO$$normalizeName(String name) {
        char sep = File.separatorChar;
        return sep == '/' ? name : name.replace(sep, '/');
    }

    private void withZipOutput(File file, Option<java.util.jar.Manifest> manifest$2, Function1<ZipOutputStream, BoxedUnit> f$2) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(false))).apply(file, new Serializable(manifest$2, f$2){
            public static final long serialVersionUID;
            private final Option manifest$2;
            private final Function1 f$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(BufferedOutputStream fileOut) {
                ZipOutputStream zipOut;
                Option option;
                block9: {
                    Tuple2 tuple2;
                    block8: {
                        Tuple2 tuple22;
                        block7: {
                            option = this.manifest$2;
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            java.util.jar.Manifest manifest = (java.util.jar.Manifest)some.x();
                            java.util.jar.Manifest mf = manifest;
                            Attributes main = mf.getMainAttributes();
                            Object object = main.containsKey(Attributes.Name.MANIFEST_VERSION) ? BoxedUnit.UNIT : main.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                            tuple22 = new Tuple2((Object)new JarOutputStream((OutputStream)fileOut, mf), (Object)"jar");
                            break block8;
                        }
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                        tuple22 = tuple2 = new Tuple2((Object)new ZipOutputStream(fileOut), (Object)"zip");
                    }
                    if (tuple2 != null) {
                        Tuple2 tuple23 = new Tuple2(tuple2._1(), tuple2._2());
                        zipOut = (ZipOutputStream)tuple23._1();
                        String ext = (String)tuple23._2();
                        this.f$2.apply((Object)zipOut);
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                }
                throw new MatchError((Object)option);
                finally {
                    zipOut.close();
                }
            }
            {
                this.manifest$2 = option;
                this.f$2 = function1;
            }
        });
    }

    public Option<String> relativize(File base, File file) {
        String pathString$1 = file.getAbsolutePath();
        return this.baseFileString(base).flatMap((Function1)new Serializable(pathString$1){
            public static final long serialVersionUID;
            private final String pathString$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<String> apply(String baseString) {
                return this.pathString$1.startsWith(baseString) ? new Some((Object)this.pathString$1.substring(baseString.length())) : None$.MODULE$;
            }
            {
                this.pathString$1 = string;
            }
        });
    }

    private Option<String> baseFileString(File baseFile) {
        None$ none$;
        if (baseFile.isDirectory()) {
            String cp = baseFile.getAbsolutePath();
            Predef$.MODULE$.assert(cp.length() > 0);
            String normalized = cp.charAt(cp.length() - 1) == File.separatorChar ? cp : new StringBuilder().append((Object)cp).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).toString();
            none$ = new Some((Object)normalized);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public scala.collection.immutable.Set<File> copy(Traversable<Tuple2<File, File>> sources, boolean overwrite$1, boolean preserveLastModified$5) {
        return ((TraversableOnce)sources.map(Function$.MODULE$.tupled((Function2)new Serializable(overwrite$1, preserveLastModified$5){
            public static final long serialVersionUID;
            private final boolean overwrite$1;
            private final boolean preserveLastModified$5;

            static {
                long l = serialVersionUID = 0L;
            }

            public final File apply(File file, File file2) {
                return IO$.MODULE$.sbt$IO$$copyImpl(this.overwrite$1, this.preserveLastModified$5, file, file2);
            }
            {
                this.overwrite$1 = bl;
                this.preserveLastModified$5 = bl2;
            }
        }), Traversable$.MODULE$.canBuildFrom())).toSet();
    }

    public boolean copy$default$3() {
        return false;
    }

    public boolean copy$default$2() {
        return false;
    }

    public final File sbt$IO$$copyImpl(boolean overwrite, boolean preserveLastModified, File from, File to) {
        if (overwrite || !to.exists() || from.lastModified() > to.lastModified()) {
            if (from.isDirectory()) {
                this.createDirectory(to);
            } else {
                this.createDirectory(to.getParentFile());
                this.copyFile(from, to, preserveLastModified);
            }
        }
        return to;
    }

    public void copyDirectory(File source, File target, boolean overwrite, boolean preserveLastModified) {
        PathFinder qual$1 = PathFinder$.MODULE$.apply(source).$times$times$times();
        Function1<File, Option<File>> x$17 = Path$.MODULE$.rebase(source, target);
        boolean x$18 = qual$1.x$default$2();
        this.copy((Traversable<Tuple2<File, File>>)qual$1.x(x$17, x$18), overwrite, preserveLastModified);
    }

    public boolean copyDirectory$default$4() {
        return false;
    }

    public boolean copyDirectory$default$3() {
        return false;
    }

    public void copyFile(File sourceFile$1, File targetFile$1, boolean preserveLastModified) {
        Predef$.MODULE$.require(sourceFile$1.exists(), (Function0)new Serializable(sourceFile$1){
            public static final long serialVersionUID;
            private final File sourceFile$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Source file '").append((Object)this.sourceFile$1.getAbsolutePath()).append((Object)"' does not exist.").toString();
            }
            {
                this.sourceFile$1 = file;
            }
        });
        Predef$.MODULE$.require(!sourceFile$1.isDirectory(), (Function0)new Serializable(sourceFile$1){
            public static final long serialVersionUID;
            private final File sourceFile$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Source file '").append((Object)this.sourceFile$1.getAbsolutePath()).append((Object)"' is a directory.").toString();
            }
            {
                this.sourceFile$1 = file;
            }
        });
        ((Using)((Object)Using$.MODULE$.fileInputChannel())).apply(sourceFile$1, new Serializable(sourceFile$1, targetFile$1){
            public static final long serialVersionUID;
            public final File sourceFile$1;
            public final File targetFile$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(FileChannel in$3) {
                ((Using)((Object)Using$.MODULE$.fileOutputChannel())).apply(this.targetFile$1, new Serializable(this, in$3){
                    public static final long serialVersionUID;
                    private final anonfun.copyFile.3 $outer;
                    private final FileChannel in$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(FileChannel out) {
                        long copied = out.transferFrom(this.in$3, 0L, this.in$3.size());
                        if (copied != this.in$3.size()) {
                            throw Predef$.MODULE$.error(new StringBuilder().append((Object)"Could not copy '").append((Object)this.$outer.sourceFile$1).append((Object)"' to '").append((Object)this.$outer.targetFile$1).append((Object)"' (").append((Object)BoxesRunTime.boxToLong((long)copied)).append((Object)"/").append((Object)BoxesRunTime.boxToLong((long)this.in$3.size())).append((Object)" bytes copied)").toString());
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.in$3 = fileChannel;
                    }
                });
            }
            {
                this.sourceFile$1 = file;
                this.targetFile$1 = file2;
            }
        });
        if (preserveLastModified) {
            this.copyLastModified(sourceFile$1, targetFile$1);
        }
    }

    public boolean copyFile$default$3() {
        return false;
    }

    public boolean copyLastModified(File sourceFile2, File targetFile) {
        return targetFile.setLastModified(sourceFile2.lastModified());
    }

    public Charset defaultCharset() {
        return this.utf8();
    }

    public void write(File file, String content$1, Charset charset, boolean append) {
        this.writer(file, content$1, charset, append, (Function1)new Serializable(content$1){
            public static final long serialVersionUID;
            private final String content$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(BufferedWriter bufferedWriter) {
                bufferedWriter.write(this.content$1);
            }
            {
                this.content$1 = string;
            }
        });
    }

    public <T> T writer(File file, String content, Charset charset, boolean append, Function1<BufferedWriter, T> f) {
        if (charset.newEncoder().canEncode(content)) {
            return ((Using)((Object)Using$.MODULE$.fileWriter(charset, append))).apply(file, f);
        }
        throw Predef$.MODULE$.error(new StringBuilder().append((Object)"String cannot be encoded by charset ").append((Object)charset.name()).toString());
    }

    public <T> T reader(File file, Charset charset, Function1<BufferedReader, T> f) {
        return ((Using)((Object)Using$.MODULE$.fileReader(charset))).apply(file, f);
    }

    public String read(File file, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)file.length());
        this.transfer(file, (OutputStream)out);
        return out.toString(charset.name());
    }

    public Charset read$default$2() {
        return this.defaultCharset();
    }

    public Charset reader$default$2() {
        return this.defaultCharset();
    }

    public String readStream(InputStream in, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.transfer(in, (OutputStream)out);
        return out.toString(charset.name());
    }

    public Charset readStream$default$2() {
        return this.defaultCharset();
    }

    public byte[] readBytes(File file) {
        return (byte[])((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final byte[] apply(InputStream inputStream) {
                return IO$.MODULE$.readBytes(inputStream);
            }
        });
    }

    public byte[] readBytes(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.transfer(in, (OutputStream)out);
        return out.toByteArray();
    }

    public void append(File file, String content, Charset charset) {
        this.write(file, content, charset, true);
    }

    public void append(File file, byte[] bytes2) {
        this.writeBytes(file, bytes2, true);
    }

    public Charset append$default$3() {
        return this.defaultCharset();
    }

    public void write(File file, byte[] bytes2) {
        this.writeBytes(file, bytes2, false);
    }

    private void writeBytes(File file, byte[] bytes$1, boolean append) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(append))).apply(file, new Serializable(bytes$1){
            public static final long serialVersionUID;
            private final byte[] bytes$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(BufferedOutputStream bufferedOutputStream2) {
                bufferedOutputStream2.write(this.bytes$1);
            }
            {
                this.bytes$1 = byArray;
            }
        });
    }

    public List<String> readLinesURL(URL url, Charset charset) {
        return (List)Using$.MODULE$.urlReader(charset).apply(url, new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final List<String> apply(BufferedReader bufferedReader) {
                return IO$.MODULE$.readLines(bufferedReader);
            }
        });
    }

    public List<String> readLines(File file, Charset charset) {
        return (List)((Using)((Object)Using$.MODULE$.fileReader(charset))).apply(file, new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final List<String> apply(BufferedReader bufferedReader) {
                return IO$.MODULE$.readLines(bufferedReader);
            }
        });
    }

    public List<String> readLines(BufferedReader in) {
        return ((List)this.foldLines(in, (Object)Nil$.MODULE$, (Function2)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final List<String> apply(List<String> accum, String line) {
                String string = line;
                return accum.$colon$colon((Object)string);
            }
        })).reverse();
    }

    public Charset readLines$default$2() {
        return this.defaultCharset();
    }

    public Charset readLinesURL$default$2() {
        return this.defaultCharset();
    }

    public void foreachLine(BufferedReader in, Function1<String, BoxedUnit> f$4) {
        this.foldLines(in, (Object)BoxedUnit.UNIT, (Function2)new Serializable(f$4){
            public static final long serialVersionUID;
            private final Function1 f$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(BoxedUnit x$13, String line) {
                this.f$4.apply((Object)line);
            }
            {
                this.f$4 = function1;
            }
        });
    }

    public <T> T foldLines(BufferedReader in$4, T init, Function2<T, String, T> f$3) {
        return (T)this.readLine$1(init, in$4, f$3);
    }

    public void writeLines(File file, Seq<String> lines$1, Charset charset, boolean append) {
        this.writer(file, (String)lines$1.headOption().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "";
            }
        }), charset, append, (Function1)new Serializable(lines$1){
            public static final long serialVersionUID;
            private final Seq lines$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(BufferedWriter w$1) {
                this.lines$1.foreach((Function1)new Serializable(this, w$1){
                    public static final long serialVersionUID;
                    private final BufferedWriter w$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(String line) {
                        this.w$1.write(line);
                        this.w$1.newLine();
                    }
                    {
                        this.w$1 = bufferedWriter;
                    }
                });
            }
            {
                this.lines$1 = seq;
            }
        });
    }

    public void writeLines(PrintWriter writer$1, Seq<String> lines2) {
        lines2.foreach((Function1)new Serializable(writer$1){
            public static final long serialVersionUID;
            private final PrintWriter writer$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String string) {
                this.writer$1.println(string);
            }
            {
                this.writer$1 = printWriter;
            }
        });
    }

    public void write(Properties properties$1, String label$1, File to) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(to, new Serializable(properties$1, label$1){
            public static final long serialVersionUID;
            private final Properties properties$1;
            private final String label$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(BufferedOutputStream output) {
                this.properties$1.store(output, this.label$1);
            }
            {
                this.properties$1 = properties;
                this.label$1 = string;
            }
        });
    }

    public boolean writeLines$default$4() {
        return false;
    }

    public Charset writeLines$default$3() {
        return this.defaultCharset();
    }

    public boolean writer$default$4() {
        return false;
    }

    public boolean write$default$4() {
        return false;
    }

    public Charset write$default$3() {
        return this.defaultCharset();
    }

    public void load(Properties properties$2, File from) {
        if (from.exists()) {
            ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, new Serializable(properties$2){
                public static final long serialVersionUID;
                private final Properties properties$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(BufferedInputStream input2) {
                    this.properties$2.load(input2);
                }
                {
                    this.properties$2 = properties;
                }
            });
        }
    }

    private Pattern PathSeparatorPattern() {
        return this.PathSeparatorPattern;
    }

    public String[] pathSplit(String s) {
        return this.PathSeparatorPattern().split(s);
    }

    public <T> T stash(scala.collection.immutable.Set<File> files$1, Function0<T> f$5) {
        return this.withTemporaryDirectory((Function1<File, T>)new Serializable(files$1, f$5){
            public static final long serialVersionUID;
            private final scala.collection.immutable.Set files$1;
            private final Function0 f$5;

            static {
                long l = serialVersionUID = 0L;
            }

            public final T apply(File dir) {
                Tuple2<File, File>[] stashed = IO$.MODULE$.sbt$IO$$stashLocations(dir, (File[])this.files$1.toArray(ClassManifest$.MODULE$.classType(File.class)));
                IO$.MODULE$.move((Traversable<Tuple2<File, File>>)Predef$.MODULE$.wrapRefArray((Object[])stashed));
                Object exceptionResult5 = null;
                try {
                    exceptionResult5 = this.f$5.apply();
                }
                catch (Exception exception) {
                    Object exceptionResult6 = null;
                    try {
                        IO$.MODULE$.move((Traversable<Tuple2<File, File>>)((Traversable)Predef$.MODULE$.refArrayOps((Object[])stashed).map((Function1)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Tuple2<File, File> apply(Tuple2<File, File> tuple2) {
                                return tuple2.swap();
                            }
                        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
                        throw exception;
                    }
                    catch (Exception exception2) {
                        throw exception;
                    }
                }
                return (T)exceptionResult5;
            }
            {
                this.files$1 = set2;
                this.f$5 = function0;
            }
        });
    }

    public final Tuple2<File, File>[] sbt$IO$$stashLocations(File dir$2, File[] files) {
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])files).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(File.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{Manifest$.MODULE$.Int()}))))).filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<File, Object> tuple2) {
                Tuple2<File, Object> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).map((Function1)new Serializable(dir$2){
            public static final long serialVersionUID;
            private final File dir$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<File, File> apply(Tuple2<File, Object> tuple2) {
                Tuple2<File, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    return new Tuple2(tuple22._1(), (Object)new File(this.dir$2, Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)tuple22._2())).toHexString()));
                }
                throw new MatchError(tuple22);
            }
            {
                this.dir$2 = file;
            }
        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(File.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(File.class)}))));
    }

    public void move(Traversable<Tuple2<File, File>> files) {
        files.foreach(Function$.MODULE$.tupled((Function2)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File file, File file2) {
                IO$.MODULE$.move(file, file2);
            }
        }));
    }

    public void move(File a, File b) {
        if (b.exists()) {
            this.delete(b);
        }
        this.createDirectory(b.getParentFile());
        if (!a.renameTo(b)) {
            this.copyFile(a, b, true);
            this.delete(a);
        }
    }

    public <T> T gzipFileOut(File file, Function1<OutputStream, T> f$6) {
        return (T)((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(file, new Serializable(f$6){
            public static final long serialVersionUID;
            public final Function1 f$6;

            static {
                long l = serialVersionUID = 0L;
            }

            public final T apply(BufferedOutputStream fout) {
                return (T)Using$.MODULE$.gzipOutputStream().apply(fout, new Serializable(this){
                    public static final long serialVersionUID;
                    private final anonfun.gzipFileOut.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final T apply(GZIPOutputStream outg) {
                        return (T)Using$.MODULE$.bufferedOutputStream().apply(outg, this.$outer.f$6);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.f$6 = function1;
            }
        });
    }

    public <T> T gzipFileIn(File file, Function1<InputStream, T> f$7) {
        return (T)((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, new Serializable(f$7){
            public static final long serialVersionUID;
            public final Function1 f$7;

            static {
                long l = serialVersionUID = 0L;
            }

            public final T apply(BufferedInputStream fin) {
                return (T)Using$.MODULE$.gzipInputStream().apply(fin, new Serializable(this){
                    public static final long serialVersionUID;
                    private final anonfun.gzipFileIn.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final T apply(GZIPInputStream ing) {
                        return (T)Using$.MODULE$.bufferedInputStream().apply(ing, this.$outer.f$7);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.f$7 = function1;
            }
        });
    }

    public URI directoryURI(File dir) {
        this.assertAbsolute(dir);
        return this.directoryURI(dir.toURI().normalize());
    }

    /*
     * Unable to fully structure code
     */
    public URI directoryURI(URI uri) {
        block2: {
            if (!uri.isAbsolute()) break block2;
            str = uri.toASCIIString();
            if (str.endsWith("/")) ** GOTO lbl-1000
            v0 = uri.getScheme();
            var4_3 = "file";
            if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) {
                v1 = new StringBuilder().append((Object)str).append((Object)"/").toString();
            } else lbl-1000:
            // 2 sources

            {
                v1 = str;
            }
            dirStr = v1;
            return new URI(dirStr).normalize();
        }
        return uri;
    }

    public URI toURI(File f) {
        return f.isAbsolute() ? f.toURI() : new URI(this.sbt$IO$$normalizeName(f.getPath()));
    }

    /*
     * WARNING - void declaration
     */
    public File resolve(File base, File f) {
        void var3_3;
        this.assertAbsolute(base);
        File fabs = f.isAbsolute() ? f : new File(this.directoryURI(new File(base, f.getPath())));
        this.assertAbsolute(fabs);
        return var3_3;
    }

    public void assertAbsolute(File f$8) {
        Predef$.MODULE$.assert(f$8.isAbsolute(), (Function0)new Serializable(f$8){
            public static final long serialVersionUID;
            private final File f$8;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Not absolute: ").append((Object)this.f$8).toString();
            }
            {
                this.f$8 = file;
            }
        });
    }

    public void assertAbsolute(URI uri$1) {
        Predef$.MODULE$.assert(uri$1.isAbsolute(), (Function0)new Serializable(uri$1){
            public static final long serialVersionUID;
            private final URI uri$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Not absolute: ").append((Object)this.uri$1).toString();
            }
            {
                this.uri$1 = uRI;
            }
        });
    }

    public Seq<File> parseClasspath(String s) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.pathSplit(s)).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final File apply(String string) {
                return new File(string);
            }
        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(File.class)))).toSeq();
    }

    public ObjectInputStream objectInputStream(InputStream wrapped$1, ClassLoader loader$1) {
        return new ObjectInputStream(wrapped$1, loader$1){
            private final ClassLoader loader$1;

            public Class<?> resolveClass(ObjectStreamClass osc) {
                Class<?> c = Class.forName(osc.getName(), false, this.loader$1);
                return c == null ? super.resolveClass(osc) : c;
            }
            {
                this.loader$1 = classLoader;
                super(inputStream);
            }
        };
    }

    private final String failBase$1(File file) {
        return new StringBuilder().append((Object)"Could not create directory ").append((Object)file).toString();
    }

    private final void next$1(ZipInputStream zipInputStream2, File file, NameFilter nameFilter, boolean bl, HashSet hashSet) {
        ZipEntry entry2;
        while ((entry2 = zipInputStream2.getNextEntry()) != null) {
            Object object;
            String name$1 = entry2.getName();
            if (nameFilter.accept(name$1)) {
                Object object2;
                File target$1 = new File(file, name$1);
                if (entry2.isDirectory()) {
                    this.createDirectory(target$1);
                    object2 = BoxedUnit.UNIT;
                } else {
                    hashSet.$plus$eq((Object)target$1);
                    object2 = ErrorHandling$.MODULE$.translate((Function0<String>)new Serializable(name$1, target$1){
                        public static final long serialVersionUID;
                        private final String name$1;
                        private final File target$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Error extracting zip entry '").append((Object)this.name$1).append((Object)"' to '").append((Object)this.target$1).append((Object)"': ").toString();
                        }
                        {
                            this.name$1 = string;
                            this.target$1 = file;
                        }
                    }, new Serializable(zipInputStream2, target$1){
                        public static final long serialVersionUID;
                        public final ZipInputStream from$1;
                        private final File target$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            ((Using)((Object)Using$.MODULE$.fileOutputStream(false))).apply(this.target$1, new Serializable(this){
                                public static final long serialVersionUID;
                                private final anonfun.next.1.1 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final void apply(BufferedOutputStream out) {
                                    IO$.MODULE$.transfer((InputStream)this.$outer.from$1, (OutputStream)out);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        {
                            this.from$1 = zipInputStream2;
                            this.target$1 = file;
                        }
                    });
                }
                object = bl ? BoxesRunTime.boxToBoolean((boolean)target$1.setLastModified(entry2.getTime())) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            zipInputStream2.closeEntry();
        }
        return;
    }

    private final void read$1(InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        int byteCount;
        while ((byteCount = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, byteCount);
        }
    }

    private final File create$1(int tries, File file) {
        if (tries > this.MaximumTries()) {
            throw Predef$.MODULE$.error("Could not create temporary directory.");
        }
        String randomName = new StringBuilder().append((Object)"sbt_").append((Object)Integer.toHexString(this.random().nextInt())).toString();
        File f = new File(file, randomName);
        File exceptionResult4 = null;
        try {
            this.createDirectory(f);
            exceptionResult4 = f;
        }
        catch (Exception exception) {
            exceptionResult4 = this.create$1(tries + 1, file);
        }
        return exceptionResult4;
    }

    public final boolean visit$1(File f$1, Set set2, HashMap hashMap) {
        return BoxesRunTime.unboxToBoolean((Object)hashMap.getOrElseUpdate((Object)f$1, (Function0)new Serializable(set2, hashMap, f$1){
            public static final long serialVersionUID;
            public final Set dirs$1;
            public final HashMap isEmpty$1;
            private final File f$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.dirs$1.apply((Object)this.f$1) && this.f$1.isDirectory() && Predef$.MODULE$.refArrayOps((Object[])this.f$1.listFiles()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final anonfun.visit.1.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(File file) {
                        return IO$.MODULE$.visit$1(file, this.$outer.dirs$1, this.$outer.isEmpty$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.dirs$1 = set2;
                this.isEmpty$1 = hashMap;
                this.f$1 = file;
            }
        }));
    }

    public final boolean isEmptyDirectory$1(File dir) {
        return dir.isDirectory() && Predef$.MODULE$.refArrayOps((Object[])this.listFiles(dir)).isEmpty();
    }

    private final scala.collection.immutable.Set parents$1(scala.collection.immutable.Set fs) {
        return (scala.collection.immutable.Set)fs.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final File apply(File file) {
                return file.getParentFile();
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    private final void deleteEmpty$1(scala.collection.immutable.Set dirs) {
        scala.collection.immutable.Set empty;
        while ((empty = (scala.collection.immutable.Set)dirs.filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File file) {
                return IO$.MODULE$.isEmptyDirectory$1(file);
            }
        })).nonEmpty()) {
            empty.foreach((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(File file) {
                    return file.delete();
                }
            });
            dirs = this.parents$1(empty);
        }
    }

    public final void addDirectoryEntry$1(String name, ZipOutputStream zipOutputStream2, Function1 function1, long l, long l2) {
        zipOutputStream2.putNextEntry(this.makeDirectoryEntry$1(name, function1, l, l2));
        zipOutputStream2.closeEntry();
    }

    private final ZipEntry makeDirectoryEntry$1(String name, Function1 function1, long l, long l2) {
        ZipEntry e = (ZipEntry)function1.apply((Object)name);
        e.setTime(l);
        e.setSize(0L);
        e.setMethod(0);
        e.setCrc(l2);
        return e;
    }

    private final ZipEntry makeFileEntry$1(File file, String name, Function1 function1) {
        ZipEntry e = (ZipEntry)function1.apply((Object)name);
        e.setTime(file.lastModified());
        return e;
    }

    public final void addFileEntry$1(File file, String name, ZipOutputStream zipOutputStream2, Function1 function1) {
        zipOutputStream2.putNextEntry(this.makeFileEntry$1(file, name, function1));
        this.transfer(file, (OutputStream)zipOutputStream2);
        zipOutputStream2.closeEntry();
    }

    private final Object readLine$1(Object accum, BufferedReader bufferedReader, Function2 function2) {
        String line;
        while ((line = bufferedReader.readLine()) != null) {
            accum = function2.apply(accum, (Object)line);
        }
        return accum;
    }

    private IO$() {
        MODULE$ = this;
        this.MaximumTries = 10;
        this.temporaryDirectory = new File(System.getProperty("java.io.tmpdir"));
        this.BufferSize = 8192;
        this.Newline = System.getProperty("line.separator");
        this.utf8 = Charset.forName("UTF-8");
        this.PathSeparatorPattern = Pattern.compile(File.pathSeparator);
    }
}

