/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.TreeWalkerAuditEvent;
import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.RootNode;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.sf.saxon.om.Item;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;

public class XpathFilter
implements TreeWalkerFilter {
    private final Pattern fileRegexp;
    private final String filePattern;
    private final Pattern checkRegexp;
    private final String checkPattern;
    private final String moduleId;
    private final XPathExpression xpathExpression;
    private final String xpathQuery;

    public XpathFilter(String files, String checks, String moduleId, String query) {
        this.filePattern = files;
        this.fileRegexp = Pattern.compile(files);
        this.checkPattern = checks;
        this.checkRegexp = checks == null ? null : CommonUtils.createPattern(checks);
        this.moduleId = moduleId;
        this.xpathQuery = query;
        if (this.xpathQuery == null) {
            this.xpathExpression = null;
        } else {
            XPathEvaluator xpathEvaluator = new XPathEvaluator();
            try {
                this.xpathExpression = xpathEvaluator.createExpression(this.xpathQuery);
            }
            catch (XPathException ex) {
                throw new IllegalStateException("Unexpected xpath query: " + this.xpathQuery, ex);
            }
        }
    }

    @Override
    public boolean accept(TreeWalkerAuditEvent event) {
        return !this.isFileNameAndModuleAndCheckNameMatching(event) || !this.isXpathQueryMatching(event);
    }

    private boolean isFileNameAndModuleAndCheckNameMatching(TreeWalkerAuditEvent event) {
        return !(event.getFileName() == null || !this.fileRegexp.matcher(event.getFileName()).find() || event.getLocalizedMessage() == null || this.moduleId != null && !this.moduleId.equals(event.getModuleId()) || this.checkRegexp != null && !this.checkRegexp.matcher(event.getSourceName()).find());
    }

    private boolean isXpathQueryMatching(TreeWalkerAuditEvent event) {
        boolean isMatching;
        block1: {
            Item item;
            AbstractNode abstractNode;
            isMatching = false;
            if (this.xpathExpression == null) break block1;
            List<Item> items = this.getItems(event);
            Iterator<Item> iterator = items.iterator();
            while (iterator.hasNext() && !(isMatching = (abstractNode = (AbstractNode)(item = iterator.next())).getTokenType() == event.getTokenType() && abstractNode.getLineNumber() == event.getLine() && abstractNode.getColumnNumber() == event.getColumn())) {
            }
        }
        return isMatching;
    }

    private List<Item> getItems(TreeWalkerAuditEvent event) {
        List items;
        RootNode rootNode = event.getRootAst() == null ? null : new RootNode(event.getRootAst());
        try {
            XPathDynamicContext xpathDynamicContext = this.xpathExpression.createDynamicContext((Item)rootNode);
            items = this.xpathExpression.evaluate(xpathDynamicContext);
        }
        catch (XPathException ex) {
            throw new IllegalStateException("Cannot initialize context and evaluate query: " + this.xpathQuery, ex);
        }
        return items;
    }

    public int hashCode() {
        return Objects.hash(this.filePattern, this.checkPattern, this.moduleId, this.xpathQuery);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        XpathFilter xpathFilter = (XpathFilter)other;
        return Objects.equals(this.filePattern, xpathFilter.filePattern) && Objects.equals(this.checkPattern, xpathFilter.checkPattern) && Objects.equals(this.moduleId, xpathFilter.moduleId) && Objects.equals(this.xpathQuery, xpathFilter.xpathQuery);
    }
}

