/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public enum LineSeparatorOption {
    CRLF("\r\n"),
    CR("\r"),
    LF("\n"),
    LF_CR_CRLF("##"),
    SYSTEM(System.getProperty("line.separator"));

    private final byte[] lineSeparator;

    private LineSeparatorOption(String sep) {
        this.lineSeparator = sep.getBytes(StandardCharsets.US_ASCII);
    }

    public boolean matches(byte ... bytes) {
        if (this == LF_CR_CRLF) {
            return CRLF.matches(bytes) || LF.matches(Arrays.copyOfRange(bytes, 1, 2)) || CR.matches(Arrays.copyOfRange(bytes, 1, 2));
        }
        return Arrays.equals(bytes, this.lineSeparator);
    }

    public int length() {
        return this.lineSeparator.length;
    }
}

