/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.regexp;

import com.puppycrawl.tools.checkstyle.checks.regexp.DetectorOptions;
import java.util.List;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SinglelineDetector {
    private final DetectorOptions mOptions;
    private int mCurrentMatches;

    public SinglelineDetector(DetectorOptions aOptions) {
        this.mOptions = aOptions;
    }

    public void processLines(List<String> aLines) {
        this.resetState();
        int lineno = 0;
        for (String line : aLines) {
            this.checkLine(++lineno, line, this.mOptions.getPattern().matcher(line), 0);
        }
        this.finish();
    }

    private void finish() {
        if (this.mCurrentMatches < this.mOptions.getMinimum()) {
            if ("".equals(this.mOptions.getMessage())) {
                this.mOptions.getReporter().log(0, "regexp.minimum", this.mOptions.getMinimum(), this.mOptions.getFormat());
            } else {
                this.mOptions.getReporter().log(0, this.mOptions.getMessage(), new Object[0]);
            }
        }
    }

    private void resetState() {
        this.mCurrentMatches = 0;
    }

    private void checkLine(int aLineno, String aLine, Matcher aMatcher, int aStartPosition) {
        boolean foundMatch = aMatcher.find(aStartPosition);
        if (!foundMatch) {
            return;
        }
        int startCol = aMatcher.start(0);
        int endCol = aMatcher.end(0);
        if (this.mOptions.getSuppressor().shouldSuppress(aLineno, startCol, aLineno, endCol - 1)) {
            if (endCol < aLine.length()) {
                this.checkLine(aLineno, aLine, aMatcher, endCol);
            }
            return;
        }
        ++this.mCurrentMatches;
        if (this.mCurrentMatches > this.mOptions.getMaximum()) {
            if ("".equals(this.mOptions.getMessage())) {
                this.mOptions.getReporter().log(aLineno, "regexp.exceeded", aMatcher.pattern().toString());
            } else {
                this.mOptions.getReporter().log(aLineno, this.mOptions.getMessage(), new Object[0]);
            }
        }
    }
}

