/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.JavaNetNetUtil;
import com.oracle.svm.core.posix.JavaNetNetUtilMD;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_jvm;
import com.oracle.svm.core.posix.Target_os;
import com.oracle.svm.core.posix.Util_java_net_DatagramPacket;
import com.oracle.svm.core.posix.Util_java_net_DatagramSocketImpl;
import com.oracle.svm.core.posix.Util_java_net_PlainDatagramSocketImpl;
import com.oracle.svm.core.posix.Util_jni;
import com.oracle.svm.core.posix.VmPrimsJNI;
import com.oracle.svm.core.posix.VmPrimsJVM;
import com.oracle.svm.core.posix.headers.Ioctl;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.VMError;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@TargetClass(className="java.net.PlainDatagramSocketImpl")
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
final class Target_java_net_PlainDatagramSocketImpl {
    @Alias
    boolean connected;
    @Alias
    int trafficClass;
    @Alias
    int timeout;

    Target_java_net_PlainDatagramSocketImpl() {
    }

    @Substitute
    protected void bind0(int localportArg, InetAddress iaObj) throws SocketException {
        int localport = localportArg;
        FileDescriptor fdObj = Util_java_net_DatagramSocketImpl.as_Target_java_net_DatagramSocketImpl((Target_java_net_PlainDatagramSocketImpl)this).fd;
        CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        len_Pointer.write(0);
        Socket.sockaddr him = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        if (iaObj == null) {
            throw new NullPointerException("iaObj is null.");
        }
        if (JavaNetNetUtilMD.NET_InetAddressToSockaddr(iaObj, localport, him, len_Pointer, Util_jni.JNI_TRUE()) != 0) {
            return;
        }
        JavaNetNetUtilMD.setDefaultScopeID(him);
        if (JavaNetNetUtilMD.NET_Bind(fd, him, len_Pointer.read()) < 0) {
            if (Errno.errno() == Errno.EADDRINUSE() || Errno.errno() == Errno.EADDRNOTAVAIL() || Errno.errno() == Errno.EPERM() || Errno.errno() == Errno.EACCES()) {
                throw new BindException(PosixUtils.lastErrorString("Bind failed"));
            }
            throw new SocketException(PosixUtils.lastErrorString("Bind failed"));
        }
        if (localport == 0) {
            if (VmPrimsJVM.JVM_GetSockName(fd, him, len_Pointer) == -1) {
                throw new SocketException(PosixUtils.lastErrorString("Error getting socket name"));
            }
            Util_java_net_PlainDatagramSocketImpl.as_Target_java_net_DatagramSocketImpl((Target_java_net_PlainDatagramSocketImpl)this).localPort = localport = JavaNetNetUtilMD.NET_GetPortFromSockaddr(him);
        } else {
            Util_java_net_PlainDatagramSocketImpl.as_Target_java_net_DatagramSocketImpl((Target_java_net_PlainDatagramSocketImpl)this).localPort = localport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    protected void send(DatagramPacket packet) throws IOException {
        CCharPointer BUF = (CCharPointer)StackValue.get((int)JavaNetNetUtilMD.MAX_BUFFER_LEN(), CCharPointer.class);
        CCharPointer fullPacket = (CCharPointer)WordFactory.nullPointer();
        boolean mallocedPacket = false;
        FileDescriptor fdObj = Util_java_net_DatagramSocketImpl.as_Target_java_net_DatagramSocketImpl((Target_java_net_PlainDatagramSocketImpl)this).fd;
        int trafficClassLocal = this.trafficClass;
        byte[] packetBuffer = null;
        InetAddress packetAddress = null;
        int fd = 0;
        Socket.sockaddr rmtaddr = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
        CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        len_Pointer.write(0);
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        fd = PosixUtils.getFD(fdObj);
        if (packet == null) {
            throw new NullPointerException("packet");
        }
        boolean connectedLocal = this.connected;
        packetBuffer = Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).buf;
        packetAddress = Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).address;
        if (packetBuffer == null || packetAddress == null) {
            throw new NullPointerException("null buffer || null address");
        }
        int packetBufferOffset = Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).offset;
        int packetBufferLen = Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).length;
        if (connectedLocal) {
            len_Pointer.write(0);
            rmtaddr = (Socket.sockaddr)WordFactory.nullPointer();
        } else {
            int packetPort = Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).port;
            if (JavaNetNetUtilMD.NET_InetAddressToSockaddr(packetAddress, packetPort, rmtaddr, len_Pointer, Util_jni.JNI_TRUE()) != 0) {
                return;
            }
        }
        JavaNetNetUtilMD.setDefaultScopeID(rmtaddr);
        if (packetBufferLen > JavaNetNetUtilMD.MAX_BUFFER_LEN()) {
            if (packetBufferLen > JavaNetNetUtil.MAX_PACKET_LEN()) {
                packetBufferLen = JavaNetNetUtil.MAX_PACKET_LEN();
            }
            if (!(fullPacket = (CCharPointer)LibC.malloc(WordFactory.unsigned((int)packetBufferLen))).isNull()) {
                throw new OutOfMemoryError("Send buffer native heap allocation failed");
            }
            mallocedPacket = true;
        } else {
            fullPacket = BUF;
        }
        VmPrimsJNI.GetByteArrayRegion(packetBuffer, packetBufferOffset, packetBufferLen, fullPacket);
        if (IsDefined.socket_AF_INET6() && trafficClassLocal != 0 && JavaNetNetUtil.ipv6_available()) {
            JavaNetNetUtilMD.NET_SetTrafficClass(rmtaddr, trafficClassLocal);
        }
        int ret = JavaNetNetUtilMD.NET_SendTo(fd, fullPacket, packetBufferLen, 0, rmtaddr, len_Pointer.read());
        try {
            if (ret < 0) {
                if (ret == Target_jvm.JVM_IO_ERR()) {
                    if (Errno.errno() == Errno.ECONNREFUSED()) {
                        throw new PortUnreachableException("ICMP Port Unreachable");
                    }
                    throw PosixUtils.newIOExceptionWithLastError("sendto failed");
                }
                if (ret == Target_jvm.JVM_IO_INTR()) {
                    throw new IOException("operation interrupted");
                }
            }
        }
        finally {
            if (mallocedPacket) {
                LibC.free((PointerBase)fullPacket);
            }
        }
    }

    @Substitute
    protected int peek(InetAddress i) throws IOException {
        throw VMError.unsupportedFeature("Unimplemented: java.net.PlainDatagramSocketImpl.peek(InetAddress)");
    }

    @Substitute
    protected int peekData(DatagramPacket p) throws IOException {
        throw VMError.unsupportedFeature("Unimplemented: java.net.PlainDatagramSocketImpl.peekData(DatagramPacket)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    protected void receive0(DatagramPacket packet) throws IOException {
        CCharPointer BUF = (CCharPointer)StackValue.get((int)JavaNetNetUtilMD.MAX_BUFFER_LEN(), CCharPointer.class);
        CCharPointer fullPacket = (CCharPointer)WordFactory.nullPointer();
        boolean mallocedPacket = false;
        FileDescriptor fdObj = Util_java_net_DatagramSocketImpl.as_Target_java_net_DatagramSocketImpl((Target_java_net_PlainDatagramSocketImpl)this).fd;
        int timeoutLocal = this.timeout;
        Socket.sockaddr remote_addr = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
        CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        if (packet == null) {
            throw new NullPointerException("packet");
        }
        byte[] packetBuffer = Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).buf;
        if (packetBuffer == null) {
            throw new NullPointerException("packet buffer");
        }
        int packetBufferOffset = Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).offset;
        int packetBufferLen = Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).bufLength;
        try {
            boolean retry;
            if (packetBufferLen > JavaNetNetUtilMD.MAX_BUFFER_LEN()) {
                if (packetBufferLen > JavaNetNetUtil.MAX_PACKET_LEN()) {
                    packetBufferLen = JavaNetNetUtil.MAX_PACKET_LEN();
                }
                if ((fullPacket = (CCharPointer)LibC.malloc(WordFactory.unsigned((int)packetBufferLen))).isNull()) {
                    throw new OutOfMemoryError("Receive buffer native heap allocation failed");
                }
                mallocedPacket = true;
            } else {
                fullPacket = BUF;
            }
            do {
                int ret;
                retry = false;
                if (timeoutLocal > 0 && (ret = JavaNetNetUtilMD.NET_Timeout(fd, timeoutLocal)) <= 0) {
                    if (ret == 0) {
                        throw new SocketTimeoutException("Receive timed out");
                    }
                    if (ret == Target_jvm.JVM_IO_ERR()) {
                        if (Errno.errno() == Errno.ENOMEM()) {
                            throw new OutOfMemoryError("NET_Timeout native heap allocation failed");
                        }
                        if (IsDefined.__linux__()) {
                            if (Errno.errno() == Errno.EBADF()) {
                                throw new SocketException("Socket closed");
                            }
                            throw new SocketException(PosixUtils.lastErrorString("Receive failed"));
                        }
                        throw new SocketException("Socket closed");
                    }
                    if (ret == Target_jvm.JVM_IO_INTR()) {
                        throw new InterruptedIOException("operation interrupted");
                    }
                }
                len_Pointer.write(JavaNetNetUtilMD.SOCKADDR_LEN());
                int n = JavaNetNetUtilMD.NET_RecvFrom(fd, fullPacket, packetBufferLen, 0, remote_addr, len_Pointer);
                if (n > packetBufferLen) {
                    n = packetBufferLen;
                }
                if (n == Target_jvm.JVM_IO_ERR()) {
                    Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).offset = 0;
                    Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).length = 0;
                    int errno = Errno.errno();
                    if (errno == Errno.ECONNREFUSED()) {
                        throw new PortUnreachableException("ICMP Port Unreachable");
                    }
                    if (errno == Errno.EBADF()) {
                        throw new SocketException("Socket closed");
                    }
                    throw new SocketException(PosixUtils.lastErrorString("Receive failed"));
                }
                if (n == Target_jvm.JVM_IO_INTR()) {
                    Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).offset = 0;
                    Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).length = 0;
                    throw new InterruptedIOException("operation interrupted");
                }
                CIntPointer port_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
                InetAddress packetAddress = Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).address;
                if (packetAddress != null && !JavaNetNetUtil.NET_SockaddrEqualsInetAddress(remote_addr, packetAddress)) {
                    packetAddress = null;
                }
                if (packetAddress == null) {
                    Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).address = packetAddress = JavaNetNetUtil.NET_SockaddrToInetAddress(remote_addr, port_Pointer);
                } else {
                    port_Pointer.write(JavaNetNetUtilMD.NET_GetPortFromSockaddr(remote_addr));
                }
                VmPrimsJNI.SetByteArrayRegion(packetBuffer, packetBufferOffset, n, fullPacket);
                Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).port = port_Pointer.read();
                Util_java_net_DatagramPacket.as_Target_java_net_DatagramPacket((DatagramPacket)packet).length = n;
            } while (retry);
        }
        finally {
            if (mallocedPacket) {
                LibC.free((PointerBase)fullPacket);
            }
        }
    }

    @Substitute
    protected void datagramSocketClose() {
        FileDescriptor fdObj = Util_java_net_DatagramSocketImpl.as_Target_java_net_DatagramSocketImpl((Target_java_net_PlainDatagramSocketImpl)this).fd;
        if (fdObj == null) {
            return;
        }
        int fd = PosixUtils.getFD(fdObj);
        if (fd == -1) {
            return;
        }
        PosixUtils.setFD(fdObj, -1);
        JavaNetNetUtilMD.NET_SocketClose(fd);
    }

    @Substitute
    protected Object socketGetOption(int opt) throws SocketException {
        CIntPointer level_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer optname_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer optlen_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer optval_i_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CCharPointer optval_c_Pointer = (CCharPointer)StackValue.get(CCharPointer.class);
        PointerBase optval_Pointer = WordFactory.nullPointer();
        int fd = Util_java_net_PlainDatagramSocketImpl.getFD(this);
        if (fd < 0) {
            throw new SocketException("socket closed");
        }
        if (opt == 16 || opt == 31) {
            return Util_java_net_PlainDatagramSocketImpl.getMulticastInterface(fd, opt);
        }
        if (opt == 15) {
            Socket.sockaddr him = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
            CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            CIntPointer port_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            len_Pointer.write(JavaNetNetUtilMD.SOCKADDR_LEN());
            if (Target_os.get_sock_name(fd, him, len_Pointer) == -1) {
                throw new SocketException(PosixUtils.lastErrorString("Error getting socket name"));
            }
            InetAddress iaObj = JavaNetNetUtil.NET_SockaddrToInetAddress(him, port_Pointer);
            return iaObj;
        }
        if (JavaNetNetUtilMD.NET_MapSocketOption(opt, level_Pointer, optname_Pointer) != 0) {
            throw new SocketException("Invalid option");
        }
        if (opt == 18 && level_Pointer.read() == NetinetIn.IPPROTO_IP()) {
            optlen_Pointer.write(SizeOf.get(CCharPointer.class));
            optval_Pointer = optval_c_Pointer;
        } else {
            optlen_Pointer.write(SizeOf.get(CIntPointer.class));
            optval_Pointer = optval_i_Pointer;
        }
        if (JavaNetNetUtilMD.NET_GetSockOpt(fd, level_Pointer.read(), optname_Pointer.read(), optval_Pointer, optlen_Pointer) < 0) {
            throw new SocketException(PosixUtils.lastErrorString("Error getting socket option"));
        }
        switch (opt) {
            case 18: {
                if (level_Pointer.read() == NetinetIn.IPPROTO_IP()) {
                    return Util_java_net_PlainDatagramSocketImpl.createBoolean(Util_java_net_PlainDatagramSocketImpl.not(optval_c_Pointer.read()));
                }
                return Util_java_net_PlainDatagramSocketImpl.createBoolean(Util_java_net_PlainDatagramSocketImpl.not(optval_i_Pointer.read()));
            }
            case 4: 
            case 32: {
                return Util_java_net_PlainDatagramSocketImpl.createBoolean(optval_i_Pointer.read());
            }
            case 3: 
            case 4097: 
            case 4098: {
                return Util_java_net_PlainDatagramSocketImpl.createInteger(optval_i_Pointer.read());
            }
        }
        return null;
    }

    @Substitute
    protected void socketSetOption0(int opt, Object value) throws SocketException {
        CIntPointer level_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer optname_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer optval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        int optlen = SizeOf.get(CIntPointer.class);
        int fd = Util_java_net_PlainDatagramSocketImpl.getFD(this);
        if (fd < 0) {
            throw new SocketException("Socket closed");
        }
        if (value == null) {
            throw new NullPointerException("value argument");
        }
        if (opt == 16 || opt == 31) {
            Util_java_net_PlainDatagramSocketImpl.setMulticastInterface(fd, opt, value);
            return;
        }
        if (opt == 18) {
            Util_java_net_PlainDatagramSocketImpl.setMulticastLoopbackMode(fd, opt, value);
            return;
        }
        if (JavaNetNetUtilMD.NET_MapSocketOption(opt, level_Pointer, optname_Pointer) != 0) {
            throw new SocketException("Invalid option");
        }
        switch (opt) {
            case 3: 
            case 4097: 
            case 4098: {
                optval_Pointer.write(((Integer)value).intValue());
                break;
            }
            case 4: 
            case 32: {
                boolean on = (Boolean)value;
                optval_Pointer.write(on ? 1 : 0);
                break;
            }
            default: {
                throw new SocketException("Socket option not supported by PlainDatagramSocketImp");
            }
        }
        if (JavaNetNetUtilMD.NET_SetSockOpt(fd, level_Pointer.read(), optname_Pointer.read(), (WordPointer)optval_Pointer, optlen) < 0) {
            throw new SocketException(PosixUtils.lastErrorString("Error setting socket option"));
        }
    }

    @Substitute
    protected void datagramSocketCreate() throws SocketException {
        FileDescriptor fdObj = Util_java_net_DatagramSocketImpl.as_Target_java_net_DatagramSocketImpl((Target_java_net_PlainDatagramSocketImpl)this).fd;
        CIntPointer arg_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer t_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        t_Pointer.write(1);
        int domain = IsDefined.socket_AF_INET6() ? (JavaNetNetUtil.ipv6_available() ? Socket.AF_INET6() : Socket.AF_INET()) : Socket.AF_INET();
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        int fd = Socket.socket(domain, Socket.SOCK_DGRAM(), 0);
        if (fd == Target_jvm.JVM_IO_ERR()) {
            throw new SocketException(PosixUtils.lastErrorString("Error creating socket"));
        }
        if (IsDefined.socket_AF_INET6() && domain == Socket.AF_INET6()) {
            arg_Pointer.write(0);
            if (Socket.setsockopt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_V6ONLY(), (PointerBase)arg_Pointer, SizeOf.get(CIntPointer.class)) < 0) {
                try {
                    throw new SocketException(PosixUtils.lastErrorString("cannot set IPPROTO_IPV6"));
                }
                catch (Throwable throwable) {
                    Unistd.close(fd);
                    throw throwable;
                }
            }
        }
        if (IsDefined.__APPLE__()) {
            arg_Pointer.write(65507);
            if (Socket.setsockopt(fd, Socket.SOL_SOCKET(), Socket.SO_SNDBUF(), (PointerBase)arg_Pointer, SizeOf.get(CIntPointer.class)) < 0) {
                try {
                    String tmpbuf = PosixUtils.lastErrorString("cannot set socket option");
                    throw new SocketException(tmpbuf);
                }
                catch (Throwable throwable) {
                    Unistd.close(fd);
                    throw throwable;
                }
            }
            if (Socket.setsockopt(fd, Socket.SOL_SOCKET(), Socket.SO_RCVBUF(), (PointerBase)arg_Pointer, SizeOf.get(CIntPointer.class)) < 0) {
                try {
                    String tmpbuf = PosixUtils.lastErrorString("cannot set socket option");
                    throw new SocketException(tmpbuf);
                }
                catch (Throwable throwable) {
                    Unistd.close(fd);
                    throw throwable;
                }
            }
        }
        if (Socket.setsockopt(fd, Socket.SOL_SOCKET(), Socket.SO_BROADCAST(), (PointerBase)t_Pointer, SizeOf.get(CIntPointer.class)) < 0) {
            try {
                String tmpbuf = PosixUtils.lastErrorString("cannot set socket option");
                throw new SocketException(tmpbuf);
            }
            catch (Throwable throwable) {
                Unistd.close(fd);
                throw throwable;
            }
        }
        if (IsDefined.__linux__()) {
            int level;
            arg_Pointer.write(0);
            int n = level = domain == Socket.AF_INET6() ? NetinetIn.IPPROTO_IPV6() : NetinetIn.IPPROTO_IP();
            if (Socket.setsockopt(fd, level, NetinetIn.IP_MULTICAST_ALL(), (PointerBase)arg_Pointer, SizeOf.get(CIntPointer.class)) < 0 && Errno.errno() != Errno.ENOPROTOOPT()) {
                try {
                    String tmpbuf = PosixUtils.lastErrorString("cannot set socket option");
                    throw new SocketException(tmpbuf);
                }
                catch (Throwable throwable) {
                    Unistd.close(fd);
                    throw throwable;
                }
            }
        }
        if (IsDefined.__linux__() && IsDefined.socket_AF_INET6() && domain == Socket.AF_INET6()) {
            int ttl = 1;
            CIntPointer ttl_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            ttl_Pointer.write(ttl);
            if (Socket.setsockopt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_MULTICAST_HOPS(), (PointerBase)ttl_Pointer, SizeOf.get(CIntPointer.class)) < 0) {
                try {
                    String tmpbuf = PosixUtils.lastErrorString("cannot set socket option");
                    throw new SocketException(tmpbuf);
                }
                catch (Throwable throwable) {
                    Unistd.close(fd);
                    throw throwable;
                }
            }
        }
        PosixUtils.setFD(fdObj, fd);
    }

    @Substitute
    int dataAvailable() {
        CIntPointer retval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        FileDescriptor fdObj = Util_java_net_DatagramSocketImpl.as_Target_java_net_DatagramSocketImpl((Target_java_net_PlainDatagramSocketImpl)this).fd;
        if (fdObj == null) {
            return -1;
        }
        int fd = PosixUtils.getFD(fdObj);
        if (Ioctl.ioctl(fd, Ioctl.FIONREAD(), (PointerBase)retval_Pointer) < 0) {
            return -1;
        }
        return retval_Pointer.read();
    }

    @Substitute
    protected void setTimeToLive(int ttl) throws IOException {
        FileDescriptor fdObj = Util_java_net_DatagramSocketImpl.as_Target_java_net_DatagramSocketImpl((Target_java_net_PlainDatagramSocketImpl)this).fd;
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        if (IsDefined.socket_AF_INET6()) {
            if (IsDefined.__linux__()) {
                Util_java_net_PlainDatagramSocketImpl.setTTL(fd, ttl);
                if (JavaNetNetUtil.ipv6_available()) {
                    Util_java_net_PlainDatagramSocketImpl.setHopLimit(fd, ttl);
                }
            } else if (JavaNetNetUtil.ipv6_available()) {
                Util_java_net_PlainDatagramSocketImpl.setHopLimit(fd, ttl);
            } else {
                Util_java_net_PlainDatagramSocketImpl.setTTL(fd, ttl);
            }
        } else {
            Util_java_net_PlainDatagramSocketImpl.setTTL(fd, ttl);
        }
    }

    @Substitute
    protected int getTimeToLive() throws IOException {
        FileDescriptor fdObj = Util_java_net_DatagramSocketImpl.as_Target_java_net_DatagramSocketImpl((Target_java_net_PlainDatagramSocketImpl)this).fd;
        int fd = -1;
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        fd = PosixUtils.getFD(fdObj);
        if (IsDefined.socket_AF_INET6() && JavaNetNetUtil.ipv6_available()) {
            CCharPointer ttl_Pointer = (CCharPointer)StackValue.get(CCharPointer.class);
            ttl_Pointer.write((byte)0);
            CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            len_Pointer.write(SizeOf.get(CCharPointer.class));
            if (Socket.getsockopt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_MULTICAST_HOPS(), (PointerBase)ttl_Pointer, len_Pointer) < 0) {
                throw new SocketException(PosixUtils.lastErrorString("Error getting socket option"));
            }
            return ttl_Pointer.read();
        }
        CCharPointer ttl_Pointer = (CCharPointer)StackValue.get(CCharPointer.class);
        ttl_Pointer.write((byte)0);
        CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        len_Pointer.write(SizeOf.get(CCharPointer.class));
        if (Socket.getsockopt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_TTL(), (PointerBase)ttl_Pointer, len_Pointer) < 0) {
            throw new SocketException(PosixUtils.lastErrorString("Error getting socket option"));
        }
        return ttl_Pointer.read();
    }

    @Substitute
    protected void connect0(InetAddress address, int port) throws SocketException {
        FileDescriptor fdObj = Util_java_net_DatagramSocketImpl.as_Target_java_net_DatagramSocketImpl((Target_java_net_PlainDatagramSocketImpl)this).fd;
        Socket.sockaddr rmtaddr = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
        CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        len_Pointer.write(0);
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (JavaNetNetUtilMD.NET_InetAddressToSockaddr(address, port, rmtaddr, len_Pointer, true) != 0) {
            return;
        }
        JavaNetNetUtilMD.setDefaultScopeID(rmtaddr);
        if (VmPrimsJVM.JVM_Connect(fd, rmtaddr, len_Pointer.read()) == -1) {
            throw new ConnectException(PosixUtils.lastErrorString("Connect failed"));
        }
    }
}

