/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.IsolateEnterStub;
import com.oracle.svm.core.code.IsolateLeaveStub;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.jdk.IgnoreForGetCallerClass;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.stack.StackFrameVisitor;
import java.util.ArrayList;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.util.DirectAnnotationAccess;
import org.graalvm.word.Pointer;

public class StackTraceBuilder
implements StackFrameVisitor {
    private final ArrayList<StackTraceElement> trace = new ArrayList();
    private final boolean filterExceptions;

    public StackTraceBuilder(boolean filterExceptions) {
        this.filterExceptions = filterExceptions;
    }

    @Override
    public boolean visitFrame(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame) {
        if (deoptimizedFrame != null) {
            for (DeoptimizedFrame.VirtualFrame frame = deoptimizedFrame.getTopFrame(); frame != null; frame = frame.getCaller()) {
                if (this.addToTrace(frame.getFrameInfo())) continue;
                return false;
            }
        } else {
            CodeInfoQueryResult codeInfo = CodeInfoTable.lookupCodeInfoQueryResult(ip);
            for (FrameInfoQueryResult frameInfo = codeInfo.getFrameInfo(); frameInfo != null; frameInfo = frameInfo.getCaller()) {
                if (this.addToTrace(frameInfo)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean addToTrace(FrameInfoQueryResult frameInfo) {
        Class<?> clazz = frameInfo.getSourceClass();
        if (clazz != null) {
            if (clazz == JavaMainWrapper.class && this.trace.size() > 0) {
                return false;
            }
            if (clazz == IsolateEnterStub.class || clazz == IsolateLeaveStub.class) {
                return true;
            }
            if (DirectAnnotationAccess.isAnnotationPresent(clazz, IgnoreForGetCallerClass.class)) {
                return true;
            }
            if (this.filterExceptions) {
                if (this.trace.size() == 0 && Throwable.class.isAssignableFrom(clazz)) {
                    return true;
                }
                if (clazz == ImplicitExceptions.class) {
                    return true;
                }
            }
        }
        StackTraceElement sourceReference = frameInfo.getSourceReference();
        this.trace.add(sourceReference);
        return true;
    }

    public StackTraceElement[] getTrace() {
        return this.trace.toArray(new StackTraceElement[this.trace.size()]);
    }
}

