/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.annotate.Substitute;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ClassForNameSupport {
    private final Map<String, Class<?>> knownClasses = new HashMap();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerClass(Class<?> clazz) {
        ((ClassForNameSupport)ImageSingletons.lookup(ClassForNameSupport.class)).knownClasses.put(clazz.getName(), clazz);
    }

    @Substitute
    public static Class<?> forName(String className) throws ClassNotFoundException {
        Class<?> result = ((ClassForNameSupport)ImageSingletons.lookup(ClassForNameSupport.class)).knownClasses.get(className);
        if (result == null) {
            throw new ClassNotFoundException(className);
        }
        return result;
    }
}

