/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.graal.nodes.DeoptSourcePositionInfoNode;
import java.util.ArrayList;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.DynamicDeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.Phase;

public class CollectDeoptimizationSourcePositionsPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        ArrayList<NodeSourcePosition> deoptimzationSourcePositions = new ArrayList<NodeSourcePosition>();
        deoptimzationSourcePositions.add(null);
        for (DeoptimizeNode node : graph.getNodes(DeoptimizeNode.TYPE)) {
            node.setDebugId(deoptimzationSourcePositions.size());
            deoptimzationSourcePositions.add(node.getNodeSourcePosition());
        }
        assert (graph.getNodes(DynamicDeoptimizeNode.TYPE).isEmpty()) : "must collect NodeSourcePosition before DeoptimizationGroupingPhase";
        graph.addAfterFixed((FixedWithNextNode)graph.start(), (FixedNode)graph.add((Node)new DeoptSourcePositionInfoNode(deoptimzationSourcePositions)));
    }
}

