/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.DeoptimizationSourcePositionDecoder;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import java.util.Objects;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

public class DeoptimizationRuntime {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor DEOPTIMIZE = SnippetRuntime.findForeignCall(DeoptimizationRuntime.class, "deoptimize", true, LocationIdentity.any());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget
    private static void deoptimize(long actionAndReason, SpeculationLog.SpeculationReason speculation) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            Pointer sp = KnownIntrinsics.readCallerStackPointer();
            DeoptimizationAction action = Deoptimizer.decodeDeoptAction(actionAndReason);
            if (Deoptimizer.Options.TraceDeoptimization.getValue().booleanValue()) {
                DeoptimizationRuntime.traceDeoptimization(actionAndReason, speculation, action, sp);
            }
            if (action.doesInvalidateCompilation()) {
                Deoptimizer.invalidateMethodOfFrame(sp, speculation);
            } else {
                Deoptimizer.deoptimizeFrame(sp, false, speculation);
            }
            if (Deoptimizer.Options.TraceDeoptimization.getValue().booleanValue()) {
                Log.log().string("]").newline();
            }
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    private static void traceDeoptimization(long actionAndReason, SpeculationLog.SpeculationReason speculation, DeoptimizationAction action, Pointer sp) {
        NodeSourcePosition sourcePosition;
        Log log = Log.log().string("[Deoptimization initiated").newline();
        CodePointer ip = KnownIntrinsics.readReturnAddress();
        SubstrateInstalledCode installedCode = CodeInfoTable.lookupInstalledCode(ip);
        if (installedCode != null) {
            log.string("    name: ").string(installedCode.getName()).newline();
        }
        log.string("    sp: ").hex((WordBase)sp).string("  ip: ").hex((WordBase)ip).newline();
        DeoptimizationReason reason = Deoptimizer.decodeDeoptReason(actionAndReason);
        log.string("    reason: ").string(reason.toString()).string("  action: ").string(action.toString()).newline();
        int debugId = Deoptimizer.decodeDebugId(actionAndReason);
        log.string("    debugId: ").signed(debugId).string("  speculation: ").string(Objects.toString(speculation)).newline();
        CodeInfoQueryResult info = CodeInfoTable.lookupCodeInfoQueryResult(ip);
        if (info != null && (sourcePosition = DeoptimizationSourcePositionDecoder.decode(debugId, info)) != null) {
            log.string("    stack trace that triggered deoptimization:").newline();
            for (NodeSourcePosition cur = sourcePosition; cur != null; cur = cur.getCaller()) {
                log.string("        at ");
                if (cur.getMethod() != null) {
                    StackTraceElement element = cur.getMethod().asStackTraceElement(cur.getBCI());
                    if (element.getFileName() != null && element.getLineNumber() >= 0) {
                        log.string(element.toString());
                    } else {
                        log.string(cur.getMethod().format("%H.%n(%p)")).string(" bci ").signed(cur.getBCI());
                    }
                } else {
                    log.string("[unknown method]");
                }
                log.newline();
            }
        }
    }
}

