/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff;

import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.pecoff.PECoffDummyRelocation;
import com.oracle.objectfile.pecoff.PECoffRelocationTable;
import com.oracle.objectfile.pecoff.PECoffX86_64Relocation;

public enum PECoffMachine {
    NONE{

        @Override
        Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes() {
            return PECoffDummyRelocation.class;
        }
    }
    ,
    X86_64{

        @Override
        Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes() {
            return PECoffX86_64Relocation.class;
        }
    };


    abstract Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes();

    public static PECoffRelocationTable.PECoffRelocationMethod getRelocation(PECoffMachine m, ObjectFile.RelocationKind k, int sizeInBytes) {
        switch (m) {
            case X86_64: {
                switch (k) {
                    case DIRECT: {
                        switch (sizeInBytes) {
                            case 8: {
                                return PECoffX86_64Relocation.ADDR64;
                            }
                        }
                        throw new IllegalArgumentException("unsupported DIRECT relocation type, size: " + sizeInBytes);
                    }
                    case PC_RELATIVE: {
                        switch (sizeInBytes) {
                            case 4: {
                                return PECoffX86_64Relocation.REL32;
                            }
                        }
                        throw new IllegalArgumentException("unsupported relocation type: " + (Object)((Object)k) + " size: " + sizeInBytes);
                    }
                }
                throw new IllegalArgumentException("cannot map unknown relocation kind to an PECoff x86-64 relocation type");
            }
        }
        return PECoffDummyRelocation.R_NONE;
    }

    public static PECoffMachine from(int m) {
        switch (m) {
            case 0: {
                return NONE;
            }
            case 34404: {
                return X86_64;
            }
        }
        throw new IllegalStateException("unknown PECoff machine type");
    }

    public short toShort() {
        if (this == NONE) {
            return 0;
        }
        if (this == X86_64) {
            return -31132;
        }
        throw new IllegalStateException("should not reach here");
    }

    public static PECoffMachine getSystemNativeValue() {
        String archStr = System.getProperty("os.arch").toLowerCase();
        if (archStr.equals("amd64") || archStr.equals("x86_64")) {
            return X86_64;
        }
        throw new IllegalStateException("unknown PECoff machine type");
    }
}

