/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.StringTable;
import com.oracle.objectfile.SymbolTable;
import com.oracle.objectfile.elf.ELFMachine;
import com.oracle.objectfile.elf.ELFNobitsSection;
import com.oracle.objectfile.elf.ELFProgbitsSection;
import com.oracle.objectfile.elf.ELFRelocationSection;
import com.oracle.objectfile.elf.ELFStrtab;
import com.oracle.objectfile.elf.ELFSymtab;
import com.oracle.objectfile.elf.ELFUserDefinedSection;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.objectfile.io.OutputAssembler;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ELFObjectFile
extends ObjectFile {
    public static final int IDENT_LENGTH = 16;
    public static final char[] IDENT_MAGIC = new char[]{'\u007f', 'E', 'L', 'F'};
    private final ELFHeader header;
    private final ELFStrtab shstrtab;
    private final SectionHeaderTable sht;
    protected ELFSection interp;
    private ELFEncoding dataEncoding = ELFEncoding.getSystemNativeValue();
    private char version;
    private ELFOsAbi osabi = ELFOsAbi.getSystemNativeValue();
    private char abiVersion;
    private ELFClass fileClass = ELFClass.getSystemNativeValue();
    private ELFMachine machine = ELFMachine.getSystemNativeValue();
    private long processorSpecificFlags;
    private final boolean runtimeDebugInfoGeneration;

    public ELFObjectFile(ELFMachine machine, boolean runtimeDebugInfoGeneration) {
        this.runtimeDebugInfoGeneration = runtimeDebugInfoGeneration;
        this.header = new ELFHeader("ELFHeader");
        this.machine = machine;
        this.shstrtab = new SectionHeaderStrtab();
        this.sht = new SectionHeaderTable();
    }

    public ELFObjectFile(ELFMachine machine) {
        this(machine, false);
    }

    public ELFObjectFile() {
        this(ELFMachine.getSystemNativeValue());
    }

    public ELFObjectFile(boolean runtimeDebugInfoGeneration) {
        this(ELFMachine.getSystemNativeValue(), runtimeDebugInfoGeneration);
    }

    @Override
    public ObjectFile.Format getFormat() {
        return ObjectFile.Format.ELF;
    }

    public void setFileClass(ELFClass fileClass) {
        this.fileClass = fileClass;
    }

    @Override
    public void setMainEntryPoint(String name) {
    }

    private ELFSymtab getSymtab(boolean isDynamic) {
        ELFSymtab symtab = (ELFSymtab)(isDynamic ? this.elementForName(".dynsym") : this.elementForName(".symtab"));
        if (symtab == null) {
            throw new IllegalStateException("no appropriate symtab");
        }
        return symtab;
    }

    @Override
    protected ELFSymtab createSymbolTable() {
        String name = ".symtab";
        ELFSymtab symtab = (ELFSymtab)this.elementForName(".symtab");
        if (symtab == null) {
            symtab = new ELFSymtab(this, name, false);
        }
        return symtab;
    }

    @Override
    public ObjectFile.Symbol createDefinedSymbol(String name, ObjectFile.Element baseSection, long position, int size, boolean isCode, boolean isGlobal) {
        ELFSymtab symtab = this.createSymbolTable();
        return symtab.newDefinedEntry(name, (ObjectFile.Section)baseSection, position, size, isGlobal, isCode);
    }

    @Override
    public ObjectFile.Symbol createUndefinedSymbol(String name, int size, boolean isCode) {
        ELFSymtab symtab = this.createSymbolTable();
        return symtab.newUndefinedEntry(name, isCode);
    }

    @Override
    protected ObjectFile.Segment getOrCreateSegment(String maybeSegmentName, String sectionName, boolean writable, boolean executable) {
        return null;
    }

    @Override
    public ELFUserDefinedSection newUserDefinedSection(ObjectFile.Segment segment, String name, int alignment, ElementImpl impl) {
        ELFUserDefinedSection userDefined = new ELFUserDefinedSection(this, name, alignment, SectionType.PROGBITS, impl);
        assert (userDefined.getImpl() == impl);
        if (segment != null) {
            this.getOrCreateSegment(segment.getName(), name, true, false).add(userDefined);
        }
        if (impl != null) {
            impl.setElement(userDefined);
        }
        return userDefined;
    }

    @Override
    public ELFProgbitsSection newProgbitsSection(ObjectFile.Segment segment, String name, int alignment, boolean writable, boolean executable, ObjectFile.ProgbitsSectionImpl impl) {
        EnumSet<ELFSectionFlag> flags = EnumSet.noneOf(ELFSectionFlag.class);
        flags.add(ELFSectionFlag.ALLOC);
        if (executable) {
            flags.add(ELFSectionFlag.EXECINSTR);
        }
        if (writable) {
            flags.add(ELFSectionFlag.WRITE);
        }
        ELFProgbitsSection progbits = new ELFProgbitsSection(this, name, alignment, impl, flags);
        impl.setElement(progbits);
        return progbits;
    }

    @Override
    public ELFNobitsSection newNobitsSection(ObjectFile.Segment segment, String name, ObjectFile.NobitsSectionImpl impl) {
        ELFNobitsSection nobits = new ELFNobitsSection(this, name, impl);
        impl.setElement(nobits);
        return nobits;
    }

    public ELFSection getSectionByIndex(int i) {
        return (ELFSection)this.elements.get(this.elements.sectionIndexToElementIndex(i - 1));
    }

    public int getIndexForSection(ELFSection s) {
        return this.elements.elementIndexToSectionIndex(this.elements.indexOf(s)) + 1;
    }

    @Override
    protected boolean elementsCanSharePage(ObjectFile.Element s1, ObjectFile.Element s2, int off1, int off2) {
        assert (s1 instanceof ELFSection);
        assert (s2 instanceof ELFSection);
        ELFSection es1 = (ELFSection)s1;
        ELFSection es2 = (ELFSection)s2;
        boolean flagsCompatible = ELFSectionFlag.flagSetAsIfSegmentFlags(es1.getFlags()).equals(ELFSectionFlag.flagSetAsIfSegmentFlags(es2.getFlags()));
        return flagsCompatible && super.elementsCanSharePage(es1, es2, off1, off2);
    }

    @Override
    public Set<ObjectFile.Segment> getSegments() {
        return new HashSet<ObjectFile.Segment>();
    }

    public ELFEncoding getDataEncoding() {
        return this.dataEncoding;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.getDataEncoding().toByteOrder();
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.dataEncoding = byteOrder == ByteOrder.LITTLE_ENDIAN ? ELFEncoding.ELFDATA2LSB : ELFEncoding.ELFDATA2MSB;
    }

    public char getVersion() {
        return this.version;
    }

    public ELFOsAbi getOsAbi() {
        return this.osabi;
    }

    public int getAbiVersion() {
        return this.abiVersion;
    }

    public ELFClass getFileClass() {
        return this.fileClass;
    }

    @Override
    public int getWordSizeInBytes() {
        return this.fileClass == ELFClass.ELFCLASS64 ? 8 : 4;
    }

    @Override
    public boolean shouldRecordDebugRelocations() {
        return true;
    }

    public ELFMachine getMachine() {
        return this.machine;
    }

    public void setMachine(ELFMachine machine) {
        this.machine = machine;
    }

    public long getFlags() {
        return this.processorSpecificFlags;
    }

    public ELFRelocationSection getOrCreateDynamicRelocSection(ELFSymtab syms, boolean withExplicitAddends) {
        throw new AssertionError((Object)"can't create dynamic relocations in this kind of ELF file");
    }

    public ELFRelocationSection getOrCreateRelocSection(ELFUserDefinedSection elfUserDefinedSection, ELFSymtab syms, boolean withExplicitAddends) {
        ELFRelocationSection rs;
        String nameStem = withExplicitAddends ? ".rela" : ".rel";
        String name = nameStem + elfUserDefinedSection.getName();
        ObjectFile.Element el = this.elementForName(name);
        if (el == null) {
            rs = new ELFRelocationSection(this, name, elfUserDefinedSection, syms, withExplicitAddends);
        } else if (el instanceof ELFRelocationSection) {
            rs = (ELFRelocationSection)el;
        } else {
            throw new IllegalStateException(name + " section exists but is not an ELFRelocationSection");
        }
        return rs;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return (SymbolTable)((Object)this.elementForName(".symtab"));
    }

    @Override
    protected int getMinimumFileSize() {
        return 0;
    }

    public class SectionHeaderTable
    extends ObjectFile.Element {
        @Override
        public ElementImpl getImpl() {
            return this;
        }

        @Override
        public boolean isLoadable() {
            return false;
        }

        public SectionHeaderTable() {
            super("ELFSectionHeaderTable");
            assert (ELFObjectFile.this.elements.sectionsCount() == 1);
        }

        @Override
        public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            HashSet<BuildDependency> deps = ObjectFile.defaultDependencies(decisions, this);
            LayoutDecision ourContent = decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT);
            deps.add(BuildDependency.createOrGet(ourContent, decisions.get(ELFObjectFile.this.shstrtab).getDecision(LayoutDecision.Kind.SIZE)));
            deps.add(BuildDependency.createOrGet(ourContent, decisions.get(ELFObjectFile.this.shstrtab).getDecision(LayoutDecision.Kind.OFFSET)));
            deps.add(BuildDependency.createOrGet(ourContent, decisions.get(ELFObjectFile.this.shstrtab).getDecision(LayoutDecision.Kind.CONTENT)));
            decisions.get(ELFObjectFile.this.shstrtab).getDecision(LayoutDecision.Kind.OFFSET);
            decisions.get(ELFObjectFile.this.shstrtab).getDecision(LayoutDecision.Kind.CONTENT);
            for (ObjectFile.Element e : ELFObjectFile.this.getElements()) {
                if (e == this || e == ELFObjectFile.this.shstrtab) continue;
                deps.add(BuildDependency.createOrGet(ourContent, decisions.get(e).getDecision(LayoutDecision.Kind.OFFSET)));
                deps.add(BuildDependency.createOrGet(ourContent, decisions.get(e).getDecision(LayoutDecision.Kind.SIZE)));
            }
            return deps;
        }

        @Override
        public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
            SectionHeaderEntryStruct s = new SectionHeaderEntryStruct();
            OutputAssembler oa = AssemblyBuffer.createOutputAssembler(ELFObjectFile.this.getDataEncoding().toByteOrder());
            s.write(oa);
            int entrySize = oa.pos();
            return (ELFObjectFile.this.elements.sectionsCount() + 1) * entrySize;
        }

        @Override
        public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
            OutputAssembler oa = AssemblyBuffer.createOutputAssembler(ELFObjectFile.this.getDataEncoding().toByteOrder());
            this.write(oa, alreadyDecided);
            if (contentHint != null) {
                // empty if block
            }
            return oa.getBlob();
        }

        @Override
        public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
            return ObjectFile.defaultDecisions(this, copyingIn);
        }

        @Override
        public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
            return ObjectFile.defaultGetOrDecideOffset(alreadyDecided, this, offsetHint);
        }

        @Override
        public int getOrDecideVaddr(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
            return ObjectFile.defaultGetOrDecideVaddr(alreadyDecided, this, vaddrHint);
        }

        public void write(OutputAssembler out, Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
            LayoutDecision shstrtabDecision = alreadyDecided.get(ELFObjectFile.this.shstrtab).getDecision(LayoutDecision.Kind.CONTENT);
            byte[] shstrtabContents = (byte[])shstrtabDecision.getValue();
            StringTable strings = new StringTable(shstrtabContents);
            SectionHeaderEntryStruct ent = new SectionHeaderEntryStruct();
            assert (ent.isNullEntry());
            ent.write(out);
            HashMap<ObjectFile.Section, Integer> sectionIndices = new HashMap<ObjectFile.Section, Integer>();
            List<ObjectFile.Section> sections = ELFObjectFile.this.getSections();
            Iterator iter = sections.iterator();
            int currentSectionIndex = 0;
            while (iter.hasNext()) {
                ObjectFile.Section s = (ObjectFile.Section)iter.next();
                sectionIndices.put(s, ++currentSectionIndex);
                assert (ELFObjectFile.this.getSectionByIndex(currentSectionIndex) == s);
            }
            assert (ELFObjectFile.this.elements.sectionsCount() == currentSectionIndex);
            for (ObjectFile.Section s : ELFObjectFile.this.getSections()) {
                ELFSection linkedSection;
                ELFSection es = (ELFSection)s;
                ent.namePtr = strings.indexFor(ELFObjectFile.this.nameForElement(s));
                ent.type = es.getType();
                assert (s.getImpl().isLoadable() == es.getFlags().contains(ELFSectionFlag.ALLOC));
                ent.flags = ObjectFile.flagSetAsLong(es.getFlags());
                ent.fileOffset = ((Integer)alreadyDecided.get(es).getDecidedValue(LayoutDecision.Kind.OFFSET)).intValue();
                ent.virtualAddress = es.getFlags().contains(ELFSectionFlag.ALLOC) && ELFObjectFile.this.runtimeDebugInfoGeneration ? (long)((Integer)alreadyDecided.get(es).getDecidedValue(LayoutDecision.Kind.VADDR)).intValue() : 0L;
                ent.sectionSize = ((Integer)alreadyDecided.get(es).getDecidedValue(LayoutDecision.Kind.SIZE)).intValue();
                if (ent.sectionSize == 0L) {
                    ent.sectionSize = es.getMemSize(alreadyDecided);
                }
                ent.link = (linkedSection = es.getLinkedSection()) == null ? 0 : (Integer)sectionIndices.get(linkedSection);
                ent.info = (int)es.getLinkedInfo();
                ent.addrAlign = es.getAlignment();
                ent.entrySize = es.getEntrySize();
                ent.write(out);
            }
        }
    }

    class SectionHeaderEntryStruct
    implements Cloneable {
        int namePtr;
        SectionType type;
        long flags;
        long virtualAddress;
        long fileOffset;
        long sectionSize;
        int link;
        int info;
        long addrAlign;
        long entrySize;

        SectionHeaderEntryStruct() {
            this.type = SectionType.NULL;
            this.addrAlign = 0L;
        }

        private SectionHeaderEntryStruct(int namePtr, SectionType type, long flags, long virtualAddress, long fileOffset, long sectionSize, int link, int info, long addrAlign, long entrySize) {
            this.type = SectionType.NULL;
            this.addrAlign = 0L;
            this.namePtr = namePtr;
            assert (type != null);
            this.type = type;
            this.flags = flags;
            this.virtualAddress = virtualAddress;
            this.fileOffset = fileOffset;
            this.sectionSize = sectionSize;
            this.link = link;
            this.info = info;
            this.addrAlign = addrAlign;
            this.entrySize = entrySize;
        }

        public SectionHeaderEntryStruct clone() {
            return new SectionHeaderEntryStruct(this.namePtr, this.type, this.flags, this.virtualAddress, this.fileOffset, this.sectionSize, this.link, this.info, this.addrAlign, this.entrySize);
        }

        private void write(OutputAssembler db) {
            switch (ELFObjectFile.this.getFileClass()) {
                case ELFCLASS32: {
                    db.write4Byte(this.isNullEntry() ? 0 : this.namePtr);
                    db.write4Byte(this.type.toInt());
                    db.write4Byte(Math.toIntExact(this.flags));
                    db.write4Byte(Math.toIntExact(this.virtualAddress));
                    db.write4Byte(Math.toIntExact(this.fileOffset));
                    db.write4Byte(Math.toIntExact(this.sectionSize));
                    db.write4Byte(this.link);
                    db.write4Byte(this.info);
                    db.write4Byte(Math.toIntExact(this.addrAlign));
                    db.write4Byte(Math.toIntExact(this.entrySize));
                    break;
                }
                case ELFCLASS64: {
                    db.write4Byte(this.isNullEntry() ? 0 : this.namePtr);
                    db.write4Byte(this.type.toInt());
                    db.write8Byte(this.flags);
                    db.write8Byte(this.virtualAddress);
                    db.write8Byte(this.fileOffset);
                    db.write8Byte(this.sectionSize);
                    db.write4Byte(this.link);
                    db.write4Byte(this.info);
                    db.write8Byte(this.addrAlign);
                    db.write8Byte(this.entrySize);
                    break;
                }
                default: {
                    throw new RuntimeException(ELFObjectFile.this.getFileClass().toString());
                }
            }
        }

        public int getWrittenSize() {
            OutputAssembler temp = AssemblyBuffer.createOutputAssembler(ByteOrder.nativeOrder());
            this.write(temp);
            return temp.pos();
        }

        public String toString() {
            if (this.isNullEntry()) {
                return "SHT NULL Entry";
            }
            return "SHT Entry: " + String.format("\n  %s", new Object[]{this.type}) + String.format("\n  flags %#x", this.flags) + String.format("\n  virtual address %#x", this.virtualAddress) + String.format("\n  offset %#x (%1$d), size %d", this.fileOffset, this.sectionSize) + String.format("\n  link %#x, info %#x, align %#x, entry size %#x (%4$d)", this.link, this.info, this.addrAlign, this.entrySize) + "\n";
        }

        public boolean isNullEntry() {
            return this.namePtr == 0 && this.type == SectionType.NULL && this.flags == 0L && this.virtualAddress == 0L && this.link == 0 && this.info == 0 && this.addrAlign == 0L && this.entrySize == 0L;
        }
    }

    public static enum ELFSegmentFlag {
        X,
        W,
        R;


        public static EnumSet<ELFSegmentFlag> flagSetFromLong(long flags) {
            EnumSet<ELFSegmentFlag> working = EnumSet.noneOf(ELFSegmentFlag.class);
            for (ELFSegmentFlag f : ELFSegmentFlag.values()) {
                if ((flags & (long)(1 << f.ordinal())) == 0L) continue;
                working.add(f);
            }
            return working;
        }

        public static long flagSetToLong(EnumSet<ELFSegmentFlag> flags) {
            long working = 0L;
            for (int i = 0; i < ELFSegmentFlag.values().length; ++i) {
                if (!flags.contains((Object)ELFSegmentFlag.values()[i])) continue;
                working |= (long)(1 << i);
            }
            return working;
        }
    }

    public static enum ELFSectionFlag implements ObjectFile.ValueEnum
    {
        WRITE(1),
        ALLOC(2),
        EXECINSTR(4),
        MASKPROC(-268435456);

        private final int value;

        private ELFSectionFlag(int value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        public static EnumSet<ELFSegmentFlag> flagSetAsIfSegmentFlags(EnumSet<ELFSectionFlag> flags) {
            EnumSet<ELFSegmentFlag> out = EnumSet.of(ELFSegmentFlag.R);
            if (flags.contains(WRITE)) {
                out.add(ELFSegmentFlag.W);
            }
            if (flags.contains(EXECINSTR)) {
                out.add(ELFSegmentFlag.X);
            }
            return out;
        }
    }

    public static enum SegmentType {
        NULL,
        LOAD,
        DYNAMIC,
        INTERP,
        NOTE,
        SHLIB,
        PHDR,
        TLS,
        NUM;

    }

    public static enum SectionType {
        NULL,
        PROGBITS,
        SYMTAB,
        STRTAB,
        RELA,
        HASH,
        DYNAMIC,
        NOTE,
        NOBITS,
        REL,
        SHLIB,
        DYNSYM,
        LOOS,
        HIOS,
        LOPROC,
        HIPROC;


        public int toInt() {
            if (this.ordinal() < 12) {
                return this.ordinal();
            }
            switch (this) {
                case LOOS: {
                    return 0x60000000;
                }
                case HIOS: {
                    return 0x6FFFFFFF;
                }
                case LOPROC: {
                    return 0x70000000;
                }
                case HIPROC: {
                    return Integer.MAX_VALUE;
                }
            }
            throw new IllegalStateException("should not reach here");
        }
    }

    public class ELFHeader
    extends ObjectFile.Header {
        public ELFHeader(String name) {
            super(name);
            ELFObjectFile.this.version = '\u0001';
            ELFObjectFile.this.processorSpecificFlags = 0L;
        }

        @Override
        public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            HashSet<BuildDependency> dependencies = new HashSet<BuildDependency>();
            LayoutDecision ourContent = decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT);
            LayoutDecision ourOffset = decisions.get(this).getDecision(LayoutDecision.Kind.OFFSET);
            LayoutDecision ourSize = decisions.get(this).getDecision(LayoutDecision.Kind.SIZE);
            LayoutDecision shtSize = decisions.get(ELFObjectFile.this.sht).getDecision(LayoutDecision.Kind.SIZE);
            LayoutDecision shtOffset = decisions.get(ELFObjectFile.this.sht).getDecision(LayoutDecision.Kind.OFFSET);
            dependencies.add(BuildDependency.createOrGet(ourOffset, ourSize));
            dependencies.add(BuildDependency.createOrGet(ourContent, shtSize));
            dependencies.add(BuildDependency.createOrGet(ourContent, shtOffset));
            return dependencies;
        }

        @Override
        public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
            OutputAssembler oa = AssemblyBuffer.createOutputAssembler(ELFObjectFile.this.getDataEncoding().toByteOrder());
            Struct contents = new Struct();
            contents.ident.fileClass = ELFObjectFile.this.getFileClass();
            contents.ident.dataEncoding = ELFObjectFile.this.getDataEncoding();
            contents.ident.version = ELFObjectFile.this.getVersion();
            contents.ident.osabi = ELFObjectFile.this.getOsAbi();
            contents.ident.abiVersion = (char)ELFObjectFile.this.getAbiVersion();
            contents.type = this.getType();
            contents.machine = ELFObjectFile.this.getMachine();
            contents.version = ELFObjectFile.this.getVersion();
            contents.entry = 0L;
            contents.shoff = ((Integer)alreadyDecided.get(ELFObjectFile.this.sht).getDecidedValue(LayoutDecision.Kind.OFFSET)).intValue();
            contents.flags = (int)ELFObjectFile.this.getFlags();
            contents.ehsize = (short)contents.getWrittenSize();
            contents.shentsize = (short)new SectionHeaderEntryStruct().getWrittenSize();
            int shtSize = (Integer)alreadyDecided.get(ELFObjectFile.this.sht).getDecidedValue(LayoutDecision.Kind.SIZE);
            assert (shtSize % contents.shentsize == 0);
            contents.shnum = (short)(shtSize / contents.shentsize);
            Iterator<ObjectFile.Section> i = ELFObjectFile.this.getSections().iterator();
            short index = 1;
            boolean sawShStrTab = false;
            while (i.hasNext()) {
                if (i.next() == ELFObjectFile.this.shstrtab) {
                    sawShStrTab = true;
                    break;
                }
                index = (short)(index + 1);
            }
            contents.shstrndx = sawShStrTab ? index : (short)0;
            contents.write(oa);
            if (contentHint != null) {
                // empty if block
            }
            return oa.getBlob();
        }

        @Override
        public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
            return 0;
        }

        @Override
        public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
            int size = new Struct().getWrittenSize();
            assert (sizeHint == -1 || sizeHint == size);
            return size;
        }

        public short getShNum() {
            return (short)ELFObjectFile.this.elements.sectionsCount();
        }

        public ELFType getType() {
            return ELFType.REL;
        }

        class Struct {
            IdentStruct ident = new IdentStruct();
            ELFType type = ELFType.NONE;
            ELFMachine machine = ELFMachine.NONE;
            int version;
            long entry;
            long phoff;
            long shoff;
            int flags;
            short ehsize;
            short phentsize;
            short phnum;
            short shentsize;
            short shnum;
            short shstrndx;

            Struct() {
            }

            public void write(OutputAssembler out) {
                this.ident.write(out);
                out.write2Byte(this.type.toShort());
                out.write2Byte(this.machine.toShort());
                out.write4Byte(this.version);
                switch (ELFObjectFile.this.getFileClass()) {
                    case ELFCLASS32: {
                        out.write4Byte(Math.toIntExact(this.entry));
                        out.write4Byte(Math.toIntExact(this.phoff));
                        out.write4Byte(Math.toIntExact(this.shoff));
                        break;
                    }
                    case ELFCLASS64: {
                        out.write8Byte(this.entry);
                        out.write8Byte(this.phoff);
                        out.write8Byte(this.shoff);
                        break;
                    }
                    default: {
                        throw new RuntimeException(ELFObjectFile.this.getFileClass().toString());
                    }
                }
                out.write4Byte(this.flags);
                out.write2Byte(this.ehsize);
                out.write2Byte(this.phentsize);
                out.write2Byte(this.phnum);
                out.write2Byte(this.shentsize);
                out.write2Byte(this.shnum);
                out.write2Byte(this.shstrndx);
            }

            public int getWrittenSize() {
                OutputAssembler oa = AssemblyBuffer.createOutputAssembler();
                this.write(oa);
                return oa.pos();
            }

            class IdentStruct {
                public char[] magic = new char[4];
                public ELFClass fileClass = ELFClass.getSystemNativeValue();
                public ELFEncoding dataEncoding = ELFEncoding.getSystemNativeValue();
                public char version;
                public ELFOsAbi osabi = ELFOsAbi.getSystemNativeValue();
                public char abiVersion;

                IdentStruct(char[] magic, ELFClass fileClass, ELFEncoding dataEncoding, char version, ELFOsAbi osabi, char abiVersion) {
                    this.magic = magic;
                    this.fileClass = fileClass;
                    this.dataEncoding = dataEncoding;
                    this.version = version;
                    this.osabi = osabi;
                    this.abiVersion = abiVersion;
                }

                IdentStruct() {
                    this.magic = Arrays.copyOf(IDENT_MAGIC, IDENT_MAGIC.length);
                    assert (Arrays.equals(IDENT_MAGIC, this.magic));
                }

                void write(OutputAssembler out) {
                    int pos = out.pos();
                    byte[] magicBlob = new byte[IDENT_MAGIC.length];
                    for (int i = 0; i < IDENT_MAGIC.length; ++i) {
                        magicBlob[i] = (byte)this.magic[i];
                    }
                    out.writeBlob(magicBlob);
                    out.writeByte(this.fileClass.value());
                    out.writeByte(this.dataEncoding.value());
                    out.writeByte((byte)this.version);
                    out.writeByte(this.osabi.value());
                    out.writeByte((byte)this.abiVersion);
                    int nWritten = out.pos() - pos;
                    for (int i = 0; i < 16 - nWritten; ++i) {
                        out.writeByte((byte)0);
                    }
                }

                public String toString() {
                    return String.format("ELF Ident:\n\t[class %s, encoding %s, version %d, OS/ABI %s, ABI version %d]", new Object[]{this.fileClass, this.dataEncoding, (int)this.version, this.osabi, (int)this.abiVersion});
                }
            }
        }
    }

    public static enum ELFClass {
        ELFCLASS32(1),
        ELFCLASS64(2);

        private final int value;

        private ELFClass(int value) {
            this.value = value;
        }

        public byte value() {
            return (byte)this.value;
        }

        public static ELFClass getSystemNativeValue() {
            return ELFCLASS64;
        }
    }

    public static enum ELFOsAbi {
        ELFOSABI_SYSV(0),
        ELFOSABI_HPUX(1),
        ELFOSABI_STANDALONE(255);

        private final int value;

        private ELFOsAbi(int value) {
            this.value = value;
        }

        public byte value() {
            return (byte)this.value;
        }

        public static ELFOsAbi getSystemNativeValue() {
            return ELFOSABI_SYSV;
        }
    }

    public static enum ELFEncoding {
        ELFDATA2LSB(1),
        ELFDATA2MSB(2);

        private final int value;

        private ELFEncoding(int value) {
            this.value = value;
        }

        public byte value() {
            return (byte)this.value;
        }

        public ByteOrder toByteOrder() {
            return this == ELFDATA2LSB ? ByteOrder.LITTLE_ENDIAN : (this == ELFDATA2MSB ? ByteOrder.BIG_ENDIAN : ByteOrder.nativeOrder());
        }

        public static ELFEncoding getSystemNativeValue() {
            return ELFDATA2LSB;
        }
    }

    public static enum ELFType {
        NONE,
        REL,
        EXEC,
        DYN,
        CORE,
        LOOS,
        HIOS,
        LOPROC,
        HIPROC;


        public short toShort() {
            if (this.ordinal() < 5) {
                return (short)this.ordinal();
            }
            switch (this) {
                case LOOS: {
                    return -512;
                }
                case HIOS: {
                    return -257;
                }
                case LOPROC: {
                    return -256;
                }
                case HIPROC: {
                    return -1;
                }
            }
            throw new IllegalStateException("should not reach here");
        }
    }

    public abstract class ELFSection
    extends ObjectFile.Section {
        final SectionType type;
        EnumSet<ELFSectionFlag> flags;

        public ELFSection(String name, SectionType type) {
            this(name, type, EnumSet.noneOf(ELFSectionFlag.class));
        }

        public ELFSection(String name, SectionType type, EnumSet<ELFSectionFlag> flags) {
            this(name, this$0.getWordSizeInBytes(), type, flags, -1);
        }

        public ELFSection(String name, int alignment, SectionType type, EnumSet<ELFSectionFlag> flags, int sectionIndex) {
            super(name, alignment, sectionIndex == -1 ? -1 : ELFObjectFile.this.elements.sectionIndexToElementIndex(sectionIndex - 1));
            this.type = type;
            this.flags = flags;
        }

        @Override
        public ELFObjectFile getOwner() {
            return ELFObjectFile.this;
        }

        public SectionType getType() {
            return this.type;
        }

        @Override
        public boolean isLoadable() {
            if (this.getImpl() == this) {
                return this.flags.contains(ELFSectionFlag.ALLOC);
            }
            boolean implIsLoadable = this.getImpl().isLoadable();
            assert (implIsLoadable == this.flags.contains(ELFSectionFlag.ALLOC));
            return implIsLoadable;
        }

        @Override
        public boolean isReferenceable() {
            if (this.getImpl() == this) {
                return this.isLoadable();
            }
            return this.getImpl().isReferenceable();
        }

        public ELFSection getLinkedSection() {
            return null;
        }

        public long getLinkedInfo() {
            return 0L;
        }

        public int getEntrySize() {
            return 0;
        }

        public EnumSet<ELFSectionFlag> getFlags() {
            return this.flags;
        }

        public void setFlags(EnumSet<ELFSectionFlag> flags) {
            this.flags = flags;
        }
    }

    protected class SectionHeaderStrtab
    extends ELFStrtab {
        SectionHeaderStrtab() {
            super(ELFObjectFile.this, ".shstrtab", SectionType.STRTAB);
            this.addContentProvider(new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    final Iterator<ObjectFile.Section> underlyingIterator = ELFObjectFile.this.elements.sectionsIterator();
                    return new Iterator<String>(){

                        @Override
                        public boolean hasNext() {
                            return underlyingIterator.hasNext();
                        }

                        @Override
                        public String next() {
                            return ((ObjectFile.Section)underlyingIterator.next()).getName();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            });
        }

        @Override
        public boolean isLoadable() {
            return false;
        }
    }
}

